/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.geometry;

import ch.systemsx.cisd.common.geometry.Point;

public class ConversionUtils {
    private static final int MAX_LETTER_NUMBER = ConversionUtils.getLetterNumber('Z');

    public static Point parseSpreadsheetLocation(String spreadsheetLocation) {
        int y;
        if (spreadsheetLocation == null || spreadsheetLocation.length() == 0) {
            throw new IllegalArgumentException("Unspecified location.");
        }
        int indexOfFirstDigit = 0;
        while (indexOfFirstDigit < spreadsheetLocation.length() && !Character.isDigit(spreadsheetLocation.charAt(indexOfFirstDigit))) {
            ++indexOfFirstDigit;
        }
        if (indexOfFirstDigit == 0) {
            throw new IllegalArgumentException("Missing letter part of the location: " + spreadsheetLocation);
        }
        int x = 0;
        int i = 0;
        while (i < indexOfFirstDigit) {
            char letter = spreadsheetLocation.charAt(i);
            int digit = ConversionUtils.getLetterNumber(letter);
            if (digit < 0 || digit > MAX_LETTER_NUMBER) {
                throw new IllegalArgumentException("Invalid letter '" + letter + "' in location: " + spreadsheetLocation);
            }
            x = x * MAX_LETTER_NUMBER + digit;
            ++i;
        }
        try {
            y = Integer.parseInt(spreadsheetLocation.substring(indexOfFirstDigit));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Number part of the location is not a number: " + spreadsheetLocation);
        }
        if (y < 1) {
            throw new IllegalArgumentException("Number part of the location is not a positive number: " + spreadsheetLocation);
        }
        return new Point(x - 1, y - 1);
    }

    public static String convertToSpreadsheetLocation(Point p) {
        if (p == null) {
            throw new IllegalArgumentException("Unspecified point.");
        }
        String xText = ConversionUtils.translateRowNumberIntoLetterCode(p.getX() + 1);
        int y = p.getY() + 1;
        String yText = "" + y;
        return String.format("%s%s", xText, yText);
    }

    public static String translateRowNumberIntoLetterCode(int rowNumber) {
        int rowIndex = rowNumber - 1;
        String code = "";
        while (rowIndex >= 0) {
            code = String.valueOf((char)(rowIndex % 26 + 65)) + code;
            rowIndex = rowIndex / 26 - 1;
        }
        return code;
    }

    private static int getLetterNumber(char ch) {
        return Character.toUpperCase(ch) - 65 + 1;
    }

    private ConversionUtils() {
    }
}

