/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.process;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.unix.Unix;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.io.File;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public final class FileRenamingCallable
implements Callable<Boolean> {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, FileRenamingCallable.class);
    private final File sourceFile;
    private final File destinationFile;
    private int failures;

    public FileRenamingCallable(File sourceFile, File destinationFile) {
        assert (sourceFile != null) : "Unspecified source file";
        assert (destinationFile != null) : "Unspecified d file";
        this.sourceFile = sourceFile;
        this.destinationFile = destinationFile;
    }

    @Override
    public final Boolean call() throws Exception {
        if (!this.sourceFile.exists()) {
            operationLog.error((Object)String.format("Path '%s' doesn't exist, so it can't be moved to '%s'.", this.sourceFile, this.destinationFile));
            return false;
        }
        if (this.destinationFile.exists()) {
            operationLog.error((Object)String.format("Destination path '%s' already exists.", this.destinationFile));
            return false;
        }
        boolean renamed = this.sourceFile.renameTo(this.destinationFile);
        if (!renamed) {
            if (Unix.isOperational()) {
                try {
                    short permissions = Unix.getFileInfo(this.sourceFile.getPath()).getPermissions();
                    Unix.setAccessMode(this.sourceFile.getPath(), (short)511);
                    renamed = this.sourceFile.renameTo(this.destinationFile);
                    Unix.setAccessMode(this.destinationFile.getPath(), permissions);
                }
                catch (IOExceptionUnchecked ex) {
                    operationLog.warn((Object)String.format("Moving path '%s' to directory '%s' failed (attempt %d).", this.sourceFile, this.destinationFile, ++this.failures), (Throwable)ex.getCause());
                    return null;
                }
            }
            if (!renamed) {
                operationLog.warn((Object)String.format("Moving path '%s' to directory '%s' failed (attempt %d).", this.sourceFile, this.destinationFile, ++this.failures));
                return null;
            }
        }
        return true;
    }
}

