/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.serviceconversation.server;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.InterruptedExceptionUnchecked;
import ch.systemsx.cisd.base.exceptions.TimeoutExceptionUnchecked;
import ch.systemsx.cisd.common.serviceconversation.IServiceMessageTransport;
import ch.systemsx.cisd.common.serviceconversation.IServiceMessenger;
import ch.systemsx.cisd.common.serviceconversation.ServiceMessage;
import ch.systemsx.cisd.common.serviceconversation.UnexpectedMessagePayloadException;
import ch.systemsx.cisd.common.serviceconversation.server.ServiceConversationServer;
import java.io.Serializable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

class BidirectionalServiceMessenger {
    private final BlockingQueue<ServiceMessage> incoming = new LinkedBlockingQueue<ServiceMessage>();
    private final String conversationId;
    private final IServiceMessageTransport responseMessenger;
    private final int messageReceivingTimeoutMillis;
    private int outgoingMessageIdx;
    private int messageIdxLastSeen = -1;
    private final AtomicBoolean interrupted = new AtomicBoolean();

    BidirectionalServiceMessenger(String conversationId, int messageReceivingTimeoutMillis, IServiceMessageTransport responseMessenger) {
        this.conversationId = conversationId;
        this.messageReceivingTimeoutMillis = messageReceivingTimeoutMillis;
        this.responseMessenger = responseMessenger;
    }

    IServiceMessenger getServiceMessenger() {
        return new IServiceMessenger(){

            @Override
            public <T extends Serializable> T receive(Class<T> messageClass) {
                T payload = this.tryReceive(messageClass, BidirectionalServiceMessenger.this.messageReceivingTimeoutMillis);
                if (payload == null) {
                    ServiceConversationServer.operationLog.error((Object)String.format("[id: %s] %s", BidirectionalServiceMessenger.this.conversationId, "Timeout while waiting for message from client."));
                    throw new TimeoutExceptionUnchecked("Timeout while waiting for message from client.");
                }
                return payload;
            }

            @Override
            public <T extends Serializable> T tryReceive(Class<T> messageClass, int timeoutMillis) {
                ServiceMessage message;
                block5: {
                    if (BidirectionalServiceMessenger.this.interrupted.get()) {
                        throw new InterruptedExceptionUnchecked();
                    }
                    try {
                        message = (ServiceMessage)BidirectionalServiceMessenger.this.incoming.poll(timeoutMillis, TimeUnit.MILLISECONDS);
                        if (message != null) break block5;
                    }
                    catch (InterruptedException ex) {
                        throw CheckedExceptionTunnel.wrapIfNecessary(ex);
                    }
                    return null;
                }
                Serializable payload = message.getPayload();
                if (messageClass != null && !messageClass.isAssignableFrom(payload.getClass())) {
                    throw new UnexpectedMessagePayloadException(payload.getClass(), messageClass);
                }
                return (T)payload;
            }

            @Override
            public void send(Serializable message) {
                if (BidirectionalServiceMessenger.this.interrupted.get()) {
                    throw new InterruptedExceptionUnchecked();
                }
                BidirectionalServiceMessenger.this.responseMessenger.send(new ServiceMessage(BidirectionalServiceMessenger.this.conversationId, BidirectionalServiceMessenger.this.nextOutgoingMessageIndex(), false, message));
            }

            @Override
            public String getId() {
                return BidirectionalServiceMessenger.this.conversationId;
            }
        };
    }

    int nextOutgoingMessageIndex() {
        return this.outgoingMessageIdx++;
    }

    public void sendToService(ServiceMessage message) {
        if (message.getMessageIdx() <= this.messageIdxLastSeen) {
            return;
        }
        this.messageIdxLastSeen = message.getMessageIdx();
        this.incoming.add(message);
    }

    public void sendToClient(ServiceMessage message) {
        this.responseMessenger.send(message);
    }

    public void markAsInterrupted() {
        this.interrupted.set(true);
    }

    public boolean isMarkedAsInterrupted() {
        return this.interrupted.get();
    }
}

