/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration.postgresql;

import ch.systemsx.cisd.common.db.ISqlScriptExecutor;
import ch.systemsx.cisd.common.db.Script;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.dbmigration.AbstractDatabaseAdminDAO;
import ch.systemsx.cisd.dbmigration.DBUtilities;
import ch.systemsx.cisd.dbmigration.IMassUploader;
import ch.systemsx.cisd.dbmigration.MassUploadFileType;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;

public class PostgreSQLAdminDAO
extends AbstractDatabaseAdminDAO {
    private static final String SQL_FILE_TYPE = ".sql";
    private static final String CREATE_DATABASE_SQL_TEMPLATE = "create database %1$s with owner = \"%2$s\" encoding = 'utf8' template = template0 tablespace = pg_default; alter database %1$s set default_with_oids = off; alter database %1$s set join_collapse_limit = '32'; alter database %1$s set from_collapse_limit = '32'; ";
    private static final String CREATE_PLPGSQL = "create language plpgsql;";
    private static final String CREATE_TABLE_DATABASE_VERSION_LOGS_SQL = "create table database_version_logs (db_version varchar(4) not null, module_name varchar(250), run_status varchar(10), run_status_timestamp timestamp, module_code bytea, run_exception bytea);";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, PostgreSQLAdminDAO.class);

    public PostgreSQLAdminDAO(DataSource dataSource, ISqlScriptExecutor scriptExecutor, IMassUploader massUploader, String owner, String readOnlyGroup, String readWriteGroup, String databaseName, String databaseURL) {
        super(dataSource, scriptExecutor, massUploader, owner, readOnlyGroup, readWriteGroup, databaseName, databaseURL);
    }

    @Override
    public void createOwner() {
        try {
            this.getJdbcTemplate().execute("create user \"" + this.owner + "\"");
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)("Created role '" + this.owner + "'."));
            }
        }
        catch (DataAccessException ex) {
            if (DBUtilities.isDuplicateObjectException(ex)) {
                if (operationLog.isInfoEnabled()) {
                    operationLog.info((Object)("Role '" + this.owner + "' already exists."));
                }
            }
            operationLog.error((Object)("Database role '" + this.owner + "' couldn't be created:"), (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public void createGroups() {
        if (StringUtils.isNotBlank((String)this.readOnlyGroupOrNull)) {
            this.createRole(this.readOnlyGroupOrNull);
        }
        if (StringUtils.isNotBlank((String)this.readWriteGroupOrNull)) {
            this.createRole(this.readWriteGroupOrNull);
        }
    }

    private void createRole(String role) {
        try {
            this.getJdbcTemplate().execute("create role \"" + role + "\" with LOGIN");
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)("Created role '" + role + "'."));
            }
        }
        catch (DataAccessException ex) {
            if (DBUtilities.isDuplicateObjectException(ex)) {
                if (operationLog.isInfoEnabled()) {
                    operationLog.info((Object)("Role '" + role + "' already exists."));
                }
            }
            operationLog.error((Object)("Database role '" + role + "' couldn't be created:"), (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public void createDatabase() {
        this.createEmptyDatabase();
        this.createLanguagePlPgSQLIfNecessary();
        this.createDatabaseVersionLogsTable();
    }

    private void createDatabaseVersionLogsTable() {
        try {
            this.scriptExecutor.execute(new Script("create database_version_logs table", CREATE_TABLE_DATABASE_VERSION_LOGS_SQL), true, null);
        }
        catch (RuntimeException ex) {
            operationLog.error((Object)"Failed to create database_version_logs table.", (Throwable)ex);
            throw ex;
        }
    }

    private void createEmptyDatabase() {
        operationLog.info((Object)("Try to create empty database '" + this.databaseName + "' with owner '" + this.owner + "'."));
        try {
            this.getJdbcTemplate().execute(String.format(CREATE_DATABASE_SQL_TEMPLATE, this.databaseName, this.owner));
        }
        catch (RuntimeException ex) {
            if (ex instanceof DataAccessException && DBUtilities.isDuplicateDatabaseException((DataAccessException)((Object)ex))) {
                operationLog.warn((Object)("Cannot create database '" + this.databaseName + "' since it already exists."));
            }
            operationLog.error((Object)("Failed to create database '" + this.databaseName + "'."), (Throwable)ex);
            throw ex;
        }
    }

    private void createLanguagePlPgSQLIfNecessary() {
        operationLog.info((Object)"Try to create PL/PgSQL language.");
        try {
            this.getJdbcTemplate().execute(CREATE_PLPGSQL);
        }
        catch (RuntimeException ex) {
            if (ex instanceof DataAccessException && DBUtilities.isDuplicateObjectException((DataAccessException)((Object)ex))) {
                operationLog.info((Object)"No need to create language PL/PgSQL since it already exists.");
            }
            operationLog.error((Object)"Failed to create language PL/PgSQL.", (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public void dropDatabase() {
        block2: {
            try {
                this.getJdbcTemplate().execute("drop database " + this.databaseName);
            }
            catch (DataAccessException ex) {
                if (DBUtilities.isDBNotExistException(ex)) break block2;
                throw ex;
            }
        }
    }

    @Override
    public void restoreDatabaseFromDump(File dumpFolder, String version) {
        this.createEmptyDatabase();
        this.createLanguagePlPgSQLIfNecessary();
        Script schemaScript = this.tryLoadScript(dumpFolder, "schema", version);
        this.scriptExecutor.execute(schemaScript, false, null);
        File[] massUploadFiles = this.getMassUploadFiles(dumpFolder);
        this.massUploader.performMassUpload(massUploadFiles);
        Script finishScript = this.tryLoadScript(dumpFolder, "finish", version);
        this.scriptExecutor.execute(finishScript, false, null);
    }

    private Script tryLoadScript(File dumpFolder, String prefix, String version) throws ConfigurationFailureException {
        File scriptFile = new File(dumpFolder, String.valueOf(prefix) + "-" + version + SQL_FILE_TYPE);
        if (!scriptFile.canRead()) {
            String message = "No " + prefix + " script found for version " + version + " in a file " + scriptFile;
            operationLog.error((Object)message);
            throw new ConfigurationFailureException(message);
        }
        Script script = new Script(scriptFile.getPath(), FileUtilities.loadToString(scriptFile), version);
        return script;
    }

    private File[] getMassUploadFiles(File dumpFolder) {
        Object[] csvFiles;
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)("Searching for mass upload files in directory '" + dumpFolder.getAbsolutePath() + "'."));
        }
        if ((csvFiles = dumpFolder.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return MassUploadFileType.CSV.isOfType(name) || MassUploadFileType.TSV.isOfType(name);
            }
        })) == null) {
            operationLog.warn((Object)("Path '" + dumpFolder.getAbsolutePath() + "' is not a directory."));
            return new File[0];
        }
        Arrays.sort(csvFiles);
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)("Found " + csvFiles.length + " files for mass uploading."));
        }
        File[] csvPaths = new File[csvFiles.length];
        int i = 0;
        while (i < csvFiles.length) {
            csvPaths[i] = new File(dumpFolder, (String)csvFiles[i]);
            ++i;
        }
        return csvPaths;
    }
}

