/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.imagereaders.bioformats;

import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.LUT;
import ij.process.ShortProcessor;
import java.awt.image.ColorModel;
import java.io.IOException;
import loci.common.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageTools;

final class BioFormatsImageProcessor {
    static LUT createColorModel(IFormatReader reader) throws FormatException, IOException {
        byte[][] byteTable = reader.get8BitLookupTable();
        if (byteTable == null) {
            byteTable = BioFormatsImageProcessor.convertTo8Bit(reader.get16BitLookupTable());
        }
        if (byteTable == null || byteTable.length == 0) {
            return null;
        }
        int colors = byteTable.length;
        int samples = byteTable[0].length;
        byte[] r = colors >= 1 ? byteTable[0] : new byte[samples];
        byte[] g = colors >= 2 ? byteTable[1] : new byte[samples];
        byte[] b = colors >= 3 ? byteTable[2] : new byte[samples];
        return new LUT(8, samples, r, g, b);
    }

    static byte[][] convertTo8Bit(short[][] shortTable) {
        if (shortTable == null) {
            return null;
        }
        byte[][] byteTable = new byte[shortTable.length][256];
        int c = 0;
        while (c < byteTable.length) {
            int len = Math.min(byteTable[c].length, shortTable[c].length);
            int i = 0;
            while (i < len) {
                int valuesPerBin = shortTable[c].length / byteTable[c].length;
                double average = 0.0;
                int p = 0;
                while (p < valuesPerBin) {
                    average += (double)shortTable[c][i * valuesPerBin + p];
                    ++p;
                }
                byteTable[c][i] = (byte)(255.0 * ((average /= (double)valuesPerBin) / 65535.0));
                ++i;
            }
            ++c;
        }
        return byteTable;
    }

    static ImageProcessor openProcessor(IFormatReader reader, int no, int channel, int x, int y, int w, int h) throws FormatException, IOException {
        byte[] b = reader.openBytes(no, x, y, w, h);
        int channelCount = reader.getRGBChannelCount();
        int type = reader.getPixelType();
        int bpp = FormatTools.getBytesPerPixel((int)type);
        boolean interleave = reader.isInterleaved();
        if (b.length != w * h * channelCount * bpp && b.length != w * h * bpp) {
            throw new FormatException("Invalid byte array length: " + b.length + " (expected w=" + w + ", h=" + h + ", c=" + channelCount + ", bpp=" + bpp + ")");
        }
        LUT cm = BioFormatsImageProcessor.createColorModel(reader);
        boolean isFloat = FormatTools.isFloatingPoint((int)type);
        boolean isLittle = reader.isLittleEndian();
        boolean isSigned = FormatTools.isSigned((int)type);
        ByteProcessor ip = null;
        byte[] channelData = ImageTools.splitChannels((byte[])b, (int)channel, (int)channelCount, (int)bpp, (boolean)false, (boolean)interleave);
        Object pixels = DataTools.makeDataArray((byte[])channelData, (int)bpp, (boolean)isFloat, (boolean)isLittle);
        if (pixels instanceof byte[]) {
            byte[] q = (byte[])pixels;
            if (q.length != w * h) {
                byte[] tmp = q;
                q = new byte[w * h];
                System.arraycopy(tmp, 0, q, 0, Math.min(q.length, tmp.length));
            }
            if (isSigned) {
                q = DataTools.makeSigned((byte[])q);
            }
            ip = new ByteProcessor(w, h, q, null);
            if (cm != null) {
                ip.setColorModel((ColorModel)cm);
            }
        } else if (pixels instanceof short[]) {
            short[] q = (short[])pixels;
            if (q.length != w * h) {
                short[] tmp = q;
                q = new short[w * h];
                System.arraycopy(tmp, 0, q, 0, Math.min(q.length, tmp.length));
            }
            if (isSigned) {
                q = DataTools.makeSigned((short[])q);
            }
            ip = new ShortProcessor(w, h, q, (ColorModel)cm);
        } else if (pixels instanceof int[]) {
            int[] q = (int[])pixels;
            if (q.length != w * h) {
                int[] tmp = q;
                q = new int[w * h];
                System.arraycopy(tmp, 0, q, 0, Math.min(q.length, tmp.length));
            }
            ip = new FloatProcessor(w, h, q);
        } else if (pixels instanceof float[]) {
            float[] q = (float[])pixels;
            if (q.length != w * h) {
                float[] tmp = q;
                q = new float[w * h];
                System.arraycopy(tmp, 0, q, 0, Math.min(q.length, tmp.length));
            }
            ip = new FloatProcessor(w, h, q, null);
        } else if (pixels instanceof double[]) {
            double[] q = (double[])pixels;
            if (q.length != w * h) {
                double[] tmp = q;
                q = new double[w * h];
                System.arraycopy(tmp, 0, q, 0, Math.min(q.length, tmp.length));
            }
            ip = new FloatProcessor(w, h, q);
        }
        return ip;
    }

    static ImageProcessor openProcessor(IFormatReader reader, int page, int channel) throws FormatException, IOException {
        return BioFormatsImageProcessor.openProcessor(reader, page, channel, 0, 0, reader.getSizeX(), reader.getSizeY());
    }

    private BioFormatsImageProcessor() {
    }
}

