/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.imagereaders.bioformats;

import ch.systemsx.cisd.imagereaders.IImageReader;
import ch.systemsx.cisd.imagereaders.ImageID;
import ch.systemsx.cisd.imagereaders.ImageReaderFactory;
import ch.systemsx.cisd.imagereaders.ImageReaderTestCase;
import ch.systemsx.cisd.imagereaders.ImageReadersTestHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.testng.annotations.Test;

public class BioFormatsMetaDataReadingTest
extends ImageReaderTestCase {
    @Test
    public void testMetaDataExtraction() throws Exception {
        File imageFile = this.getImageFileForLibrary("BioFormats", "demo.tif");
        IImageReader reader = this.getReaderFromFactory(imageFile);
        BioFormatsMetaDataReadingTest.assertTrue((String)"BioFormat readers shoud be meta-data aware", (boolean)reader.isMetaDataAware());
        Map metaData = reader.readMetaData(imageFile, ImageID.NULL, null);
        String metaDataAsString = this.getMetaDataAsString(metaData);
        BioFormatsMetaDataReadingTest.assertEquals((String)this.getExpectedMetaData(), (String)metaDataAsString);
    }

    private String getExpectedMetaData() {
        return "ApplicationName: MetaMorph\nApplicationVersion: 3.1.0.79\nBinning: 1 x 1\nBitsPerSample: 16\nCamera Bit Depth: 12\nCamera Shutter: Always Open\nClear Count: 2\nClear Mode: CLEAR PRE SEQUENCE\nCompression: Uncompressed\nDateTime: 20101121 16:52:52.986\nDigitizer: 20 MHz\nExperiment base name: ME20101116METADATA03\nExperiment set: ME20101116METADATA03\nExposure: 10 ms\nFrames to Average: 1\nGain: Gain 1 (1x)\nImageLength: 1040\nImageWidth: 1392\nImageXpress Micro Filter Cube: Texas Red\nImageXpress Micro Objective: 10X S Fluor\nImageXpress Micro Shutter: Closed\nLaser focus score: 36.4006\nMetaDataPhotometricInterpretation: Monochrome\nMetaDataVersion: 1\nNewSubfileType: 2\nNumberOfChannels: 1\nPhotometricInterpretation: BlackIsZero\nRegion: 1392 x 1040, offset at (0, 0)\nSamplesPerPixel: 1\nShading: Off\nSoftware: MetaSeries\nSubtract: Off\nTemperature: -29.95\nTrigger Mode: Normal (TIMED)\nX position for position #1: 73296.5\nY position for position #1: 25554.2\n_IllumSetting_: Cy3\n_MagNA_: 0.5\n_MagRI_: 1\n_MagSetting_: 10X S Fluor\nacquisition-time-local: 20101121 16:52:52.986\nautoscale-max-percent: 0\nautoscale-min-percent: 0\nautoscale-state: off\nbits-per-pixel: 16\ncamera-binning-x: 1\ncamera-binning-y: 1\ncamera-chip-offset-x: 0\ncamera-chip-offset-y: 0\nexposure time 0 (ms): 10.0\ngamma: 1\ngray-calibration-curve-fit-algorithm: 4\ngray-calibration-max: -1\ngray-calibration-min: -1\ngray-calibration-units: \ngray-calibration-values: \nimage-name: Cy3\nlook-up-table-name: Set By Wavelength\nlook-up-table-type: by-wavelength\nmodification-time-local: 20101121 16:52:53.50\nnumber-of-planes: 1\nphotonegative-mode: off\npixel-size-x: 1392\npixel-size-y: 1040\nplane-guid: {70EAFB69-A568-464E-9EE2-4479767F96EF}\nplane-type: plane\nscale-max: 1058\nscale-min: 96\nspatial-calibration-state: on\nspatial-calibration-units: um\nspatial-calibration-x: 0.645\nspatial-calibration-y: 0.645\nstage-label: F09 : Site 1\nstage-position-x: 73296.5\nstage-position-y: 25554.2\nthreshold-color: 4080ff\nthreshold-high: 65535\nthreshold-low: 0\nthreshold-state: ThresholdOff\ntimestamp 0: 1290354772986\nwavelength: 624\nz-position: 11145.7\nzoom-percent: 50\n";
    }

    private String getMetaDataAsString(Map<String, Object> metaData) {
        ArrayList<String> sortedKeys = new ArrayList<String>(metaData.keySet());
        Collections.sort(sortedKeys);
        StringBuilder output = new StringBuilder();
        for (String key : sortedKeys) {
            Object value = metaData.get(key);
            output.append(String.valueOf(key) + ": " + value);
            output.append("\n");
        }
        return output.toString();
    }

    private IImageReader getReaderFromFactory(File imageFile) throws Exception {
        ImageReadersTestHelper.setUpLibraries((String[])new String[]{"BioFormats"});
        IImageReader reader = ImageReaderFactory.tryGetReaderForFile((String)"BioFormats", (String)imageFile.getAbsolutePath());
        return reader;
    }
}

