/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5.io;

import ch.systemsx.cisd.base.io.AdapterIInputStreamToInputStream;
import ch.systemsx.cisd.base.io.AdapterIOutputStreamToOutputStream;
import ch.systemsx.cisd.base.io.IInputStream;
import ch.systemsx.cisd.base.io.IOutputStream;
import ch.systemsx.cisd.hdf5.HDF5GenericStorageFeatures;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import ch.systemsx.cisd.hdf5.io.HDF5DataSetRandomAccessFile;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;

public class HDF5IOAdapterFactory {
    private static final String OPAQUE_TAG_FILE = "FILE";
    private static final int BUFFER_SIZE = 0x100000;

    public static IOutputStream asIOutputStream(File hdf5File, String dataSetPath) {
        return new HDF5DataSetRandomAccessFile(hdf5File, dataSetPath, HDF5GenericStorageFeatures.GENERIC_CHUNKED, 0x100000, OPAQUE_TAG_FILE, false);
    }

    public static IOutputStream asIOutputStream(File hdf5File, String dataSetPath, HDF5GenericStorageFeatures creationStorageFeature, int chunkSize, String opaqueTagOrNull) {
        return new HDF5DataSetRandomAccessFile(hdf5File, dataSetPath, creationStorageFeature, chunkSize, opaqueTagOrNull, false);
    }

    public static HDF5DataSetRandomAccessFile asRandomAccessFileReadWrite(File hdf5File, String dataSetPath) {
        return new HDF5DataSetRandomAccessFile(hdf5File, dataSetPath, HDF5GenericStorageFeatures.GENERIC_CHUNKED, 0x100000, OPAQUE_TAG_FILE, false);
    }

    public static OutputStream asOutputStream(File hdf5File, String dataSetPath, HDF5GenericStorageFeatures creationStorageFeature, int chunkSize, String opaqueTagOrNull) {
        return new AdapterIOutputStreamToOutputStream(HDF5IOAdapterFactory.asIOutputStream(hdf5File, dataSetPath, creationStorageFeature, chunkSize, opaqueTagOrNull));
    }

    public static OutputStream asOutputStream(File hdf5File, String dataSetPath) {
        return new AdapterIOutputStreamToOutputStream(HDF5IOAdapterFactory.asIOutputStream(hdf5File, dataSetPath, HDF5GenericStorageFeatures.GENERIC_CHUNKED, 0x100000, OPAQUE_TAG_FILE));
    }

    public static HDF5DataSetRandomAccessFile asRandomAccessFile(File hdf5File, String dataSetPath, HDF5GenericStorageFeatures creationStorageFeature, int chunkSize, String opaqueTagOrNull) {
        return new HDF5DataSetRandomAccessFile(hdf5File, dataSetPath, creationStorageFeature, chunkSize, opaqueTagOrNull, false);
    }

    public static IInputStream asIInputStream(File hdf5File, String dataSetPath) {
        return new HDF5DataSetRandomAccessFile(hdf5File, dataSetPath, null, 0, null, true);
    }

    public static InputStream asInputStream(File hdf5File, String dataSetPath) {
        return new AdapterIInputStreamToInputStream(HDF5IOAdapterFactory.asIInputStream(hdf5File, dataSetPath));
    }

    public static HDF5DataSetRandomAccessFile asRandomAccessFileReadOnly(File hdf5File, String dataSetPath) {
        return new HDF5DataSetRandomAccessFile(hdf5File, dataSetPath, null, 0, null, true);
    }

    public static IOutputStream asIOutputStream(IHDF5Writer writer, String dataSetPath) {
        return new HDF5DataSetRandomAccessFile((IHDF5Reader)writer, dataSetPath, HDF5GenericStorageFeatures.GENERIC_CHUNKED, 0x100000, OPAQUE_TAG_FILE, false);
    }

    public static IOutputStream asIOutputStream(IHDF5Writer writer, String dataSetPath, HDF5GenericStorageFeatures creationStorageFeature, int chunkSize, String opaqueTagOrNull) {
        return new HDF5DataSetRandomAccessFile((IHDF5Reader)writer, dataSetPath, creationStorageFeature, chunkSize, opaqueTagOrNull, false);
    }

    public static OutputStream asOutputStream(IHDF5Writer writer, String dataSetPath) {
        return new AdapterIOutputStreamToOutputStream(HDF5IOAdapterFactory.asIOutputStream(writer, dataSetPath, HDF5GenericStorageFeatures.GENERIC_CHUNKED, 0x100000, OPAQUE_TAG_FILE));
    }

    public static OutputStream asOutputStream(IHDF5Writer writer, String dataSetPath, HDF5GenericStorageFeatures creationStorageFeature, int chunkSize, String opaqueTagOrNull) {
        return new AdapterIOutputStreamToOutputStream(HDF5IOAdapterFactory.asIOutputStream(writer, dataSetPath, creationStorageFeature, chunkSize, opaqueTagOrNull));
    }

    public static HDF5DataSetRandomAccessFile asRandomAccessFile(IHDF5Writer writer, String dataSetPath, HDF5GenericStorageFeatures creationStorageFeature, int chunkSize, String opaqueTagOrNull) {
        return new HDF5DataSetRandomAccessFile((IHDF5Reader)writer, dataSetPath, creationStorageFeature, chunkSize, opaqueTagOrNull, false);
    }

    public static HDF5DataSetRandomAccessFile asRandomAccessFile(IHDF5Writer writer, String dataSetPath) {
        return new HDF5DataSetRandomAccessFile((IHDF5Reader)writer, dataSetPath, HDF5GenericStorageFeatures.GENERIC_CHUNKED, 0x100000, OPAQUE_TAG_FILE, false);
    }

    public static IInputStream asIInputStream(IHDF5Reader reader, String dataSetPath) {
        return new HDF5DataSetRandomAccessFile(reader, dataSetPath, null, 0, null, false);
    }

    public static InputStream asInputStream(IHDF5Reader reader, String dataSetPath) {
        return new AdapterIInputStreamToInputStream(HDF5IOAdapterFactory.asIInputStream(reader, dataSetPath));
    }

    public static HDF5DataSetRandomAccessFile asRandomAccessFile(IHDF5Reader reader, String dataSetPath) {
        return new HDF5DataSetRandomAccessFile(reader, dataSetPath, null, 0, null, false);
    }
}

