/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.ColumnMatcher;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.SimpleColumnMatcher;
import com.healthmarketscience.jackcess.Table;
import java.io.IOException;

public class CaseInsensitiveColumnMatcher
implements ColumnMatcher {
    public static final CaseInsensitiveColumnMatcher INSTANCE = new CaseInsensitiveColumnMatcher();

    public boolean matches(Table table, String columnName, Object value1, Object value2) {
        if (!CaseInsensitiveColumnMatcher.isTextual(table.getColumn(columnName))) {
            return SimpleColumnMatcher.INSTANCE.matches(table, columnName, value1, value2);
        }
        try {
            CharSequence cs1 = Column.toCharSequence(value1);
            CharSequence cs2 = Column.toCharSequence(value2);
            return cs1 == cs2 || cs1 != null && cs2 != null && ((Object)cs1).toString().equalsIgnoreCase(((Object)cs2).toString());
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read column " + columnName + " value", e);
        }
    }

    private static boolean isTextual(Column col) {
        DataType type = col.getType();
        return type == DataType.TEXT || type == DataType.MEMO;
    }
}

