/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.Index;
import com.healthmarketscience.jackcess.Table;
import java.io.IOException;
import java.util.List;

public class SimpleIndex
extends Index {
    private SimpleDataPage _dataPage;

    public SimpleIndex(Table table, int uniqueEntryCount, int uniqueEntryCountOffset) {
        super(table, uniqueEntryCount, uniqueEntryCountOffset);
    }

    protected void updateImpl() throws IOException {
        this.writeDataPage(this._dataPage);
    }

    protected void readIndexEntries() throws IOException {
        int nextPageNumber = this.getRootPageNumber();
        SimpleDataPage indexPage = null;
        while (true) {
            indexPage = new SimpleDataPage(nextPageNumber);
            this.readDataPage(indexPage);
            if (indexPage.isLeaf()) break;
            this.setReadOnly();
            nextPageNumber = !indexPage.getEntries().isEmpty() ? indexPage.getEntries().get(0).getSubPageNumber().intValue() : indexPage.getChildTailPageNumber();
            indexPage = null;
        }
        this._dataPage = indexPage;
        nextPageNumber = indexPage.getNextPageNumber();
        this._dataPage.setNextPageNumber(0);
        indexPage = null;
        while (nextPageNumber != 0) {
            this.setReadOnly();
            indexPage = new SimpleDataPage(nextPageNumber);
            this.readDataPage(indexPage);
            this._dataPage.getEntries().addAll(indexPage.getEntries());
            int totalSize = this._dataPage.getTotalEntrySize() + indexPage.getTotalEntrySize();
            this._dataPage.setTotalEntrySize(totalSize);
            nextPageNumber = indexPage.getNextPageNumber();
        }
        List<Index.Entry> entries = this._dataPage.getEntries();
        for (int i = 0; i < entries.size() - 1; ++i) {
            Index.Entry e2;
            Index.Entry e1 = entries.get(i);
            if (e1.compareTo(e2 = entries.get(i + 1)) <= 0) continue;
            throw new IOException("Unexpected order in index entries, " + e1 + " is greater than " + e2);
        }
    }

    protected Index.DataPage findDataPage(Index.Entry entry) throws IOException {
        return this._dataPage;
    }

    protected Index.DataPage getDataPage(int pageNumber) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SimpleDataPage
    extends Index.DataPage {
        private final int _pageNumber;
        private boolean _leaf;
        private int _nextPageNumber;
        private int _totalEntrySize;
        private int _childTailPageNumber;
        private List<Index.Entry> _entries;

        private SimpleDataPage(int pageNumber) {
            this._pageNumber = pageNumber;
        }

        @Override
        public int getPageNumber() {
            return this._pageNumber;
        }

        @Override
        public boolean isLeaf() {
            return this._leaf;
        }

        @Override
        public void setLeaf(boolean isLeaf) {
            this._leaf = isLeaf;
        }

        @Override
        public int getPrevPageNumber() {
            return 0;
        }

        @Override
        public void setPrevPageNumber(int pageNumber) {
        }

        @Override
        public int getNextPageNumber() {
            return this._nextPageNumber;
        }

        @Override
        public void setNextPageNumber(int pageNumber) {
            this._nextPageNumber = pageNumber;
        }

        @Override
        public int getChildTailPageNumber() {
            return this._childTailPageNumber;
        }

        @Override
        public void setChildTailPageNumber(int pageNumber) {
            this._childTailPageNumber = pageNumber;
        }

        @Override
        public int getTotalEntrySize() {
            return this._totalEntrySize;
        }

        @Override
        public void setTotalEntrySize(int totalSize) {
            this._totalEntrySize = totalSize;
        }

        @Override
        public byte[] getEntryPrefix() {
            return Index.EMPTY_PREFIX;
        }

        @Override
        public void setEntryPrefix(byte[] entryPrefix) {
        }

        @Override
        public List<Index.Entry> getEntries() {
            return this._entries;
        }

        @Override
        public void setEntries(List<Index.Entry> entries) {
            this._entries = entries;
        }

        @Override
        public void addEntry(int idx, Index.Entry entry) {
            this._entries.add(idx, entry);
            this._totalEntrySize += entry.size();
        }

        @Override
        public void removeEntry(int idx) {
            Index.Entry oldEntry = this._entries.remove(idx);
            this._totalEntrySize -= oldEntry.size();
        }
    }
}

