/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.query;

import com.healthmarketscience.jackcess.query.AppendQuery;
import com.healthmarketscience.jackcess.query.CrossTabQuery;
import com.healthmarketscience.jackcess.query.DataDefinitionQuery;
import com.healthmarketscience.jackcess.query.DeleteQuery;
import com.healthmarketscience.jackcess.query.MakeTableQuery;
import com.healthmarketscience.jackcess.query.PassthroughQuery;
import com.healthmarketscience.jackcess.query.QueryFormat;
import com.healthmarketscience.jackcess.query.SelectQuery;
import com.healthmarketscience.jackcess.query.UnionQuery;
import com.healthmarketscience.jackcess.query.UpdateQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Query {
    protected static final Log LOG = LogFactory.getLog(Query.class);
    private static final Row EMPTY_ROW = new Row(Collections.<String, Object>emptyMap());
    private final String _name;
    private final List<Row> _rows;
    private final int _objectId;
    private final Type _type;

    protected Query(String name, List<Row> rows, int objectId, Type type) {
        short foundType;
        this._name = name;
        this._rows = rows;
        this._objectId = objectId;
        this._type = type;
        if (type != Type.UNKNOWN && (foundType = Query.getShortValue(Query.getQueryType(rows), this._type.getValue())) != this._type.getValue()) {
            throw new IllegalStateException("Unexpected query type " + foundType);
        }
    }

    public String getName() {
        return this._name;
    }

    public Type getType() {
        return this._type;
    }

    public int getObjectId() {
        return this._objectId;
    }

    public int getObjectFlag() {
        return this.getType().getObjectFlag();
    }

    public List<Row> getRows() {
        return this._rows;
    }

    protected List<Row> getRowsByAttribute(Byte attribute) {
        return Query.getRowsByAttribute(this.getRows(), attribute);
    }

    protected Row getRowByAttribute(Byte attribute) {
        return Query.getUniqueRow(Query.getRowsByAttribute(this.getRows(), attribute));
    }

    protected Row getTypeRow() {
        return this.getRowByAttribute(QueryFormat.TYPE_ATTRIBUTE);
    }

    protected List<Row> getParameterRows() {
        return this.getRowsByAttribute(QueryFormat.PARAMETER_ATTRIBUTE);
    }

    protected Row getFlagRow() {
        return this.getRowByAttribute(QueryFormat.FLAG_ATTRIBUTE);
    }

    protected Row getRemoteDatabaseRow() {
        return this.getRowByAttribute(QueryFormat.REMOTEDB_ATTRIBUTE);
    }

    protected List<Row> getTableRows() {
        return this.getRowsByAttribute(QueryFormat.TABLE_ATTRIBUTE);
    }

    protected List<Row> getColumnRows() {
        return this.getRowsByAttribute(QueryFormat.COLUMN_ATTRIBUTE);
    }

    protected List<Row> getJoinRows() {
        return this.getRowsByAttribute(QueryFormat.JOIN_ATTRIBUTE);
    }

    protected Row getWhereRow() {
        return this.getRowByAttribute(QueryFormat.WHERE_ATTRIBUTE);
    }

    protected List<Row> getGroupByRows() {
        return this.getRowsByAttribute(QueryFormat.GROUPBY_ATTRIBUTE);
    }

    protected Row getHavingRow() {
        return this.getRowByAttribute(QueryFormat.HAVING_ATTRIBUTE);
    }

    protected List<Row> getOrderByRows() {
        return this.getRowsByAttribute(QueryFormat.ORDERBY_ATTRIBUTE);
    }

    protected abstract void toSQLString(StringBuilder var1);

    protected void toSQLParameterString(StringBuilder builder) {
        List<String> params = this.getParameters();
        if (!params.isEmpty()) {
            builder.append("PARAMETERS ").append(params).append(';').append(QueryFormat.NEWLINE);
        }
    }

    public List<String> getParameters() {
        return new RowFormatter(this.getParameterRows()){

            protected void format(StringBuilder builder, Row row) {
                String typeName = QueryFormat.PARAM_TYPE_MAP.get(row.flag);
                if (typeName == null) {
                    throw new IllegalStateException("Unknown param type " + row.flag);
                }
                builder.append(row.name1).append(' ').append(typeName);
                if (QueryFormat.TEXT_FLAG.equals(row.flag) && Query.getIntValue(row.extra, 0) > 0) {
                    builder.append('(').append(row.extra).append(')');
                }
            }
        }.format();
    }

    protected List<String> getFromTables() {
        ArrayList<Join> joinExprs = new ArrayList<Join>();
        for (Row table : this.getTableRows()) {
            StringBuilder builder = new StringBuilder();
            if (table.expression != null) {
                Query.toQuotedExpr(builder, table.expression).append('.');
            }
            if (table.name1 != null) {
                Query.toOptionalQuotedExpr(builder, table.name1, true);
            }
            Query.toAlias(builder, table.name2);
            String key = table.name2 != null ? table.name2 : table.name1;
            joinExprs.add(new Join(key, builder.toString()));
        }
        List<Row> joins = this.getJoinRows();
        if (!joins.isEmpty()) {
            Collection<List<Row>> comboJoins = this.combineJoins(joins);
            for (List<Row> comboJoin : comboJoins) {
                Row join = comboJoin.get(0);
                String joinExpr = join.expression;
                if (comboJoin.size() > 1) {
                    AppendableList<String> comboExprs = new AppendableList<String>(){
                        private static final long serialVersionUID = 0L;

                        @Override
                        protected String getSeparator() {
                            return ") AND (";
                        }
                    };
                    for (Row tmpJoin : comboJoin) {
                        comboExprs.add(tmpJoin.expression);
                    }
                    joinExpr = "(" + comboExprs + ")";
                }
                String fromTable = join.name1;
                String toTable = join.name2;
                Join fromExpr = this.getJoinExpr(fromTable, joinExprs);
                Join toExpr = this.getJoinExpr(toTable, joinExprs);
                String joinType = QueryFormat.JOIN_TYPE_MAP.get(join.flag);
                if (joinType == null) {
                    throw new IllegalStateException("Unknown join type " + join.flag);
                }
                String expr = fromExpr + joinType + toExpr + " ON " + joinExpr;
                fromExpr.join(toExpr, expr);
                joinExprs.add(fromExpr);
            }
        }
        AppendableList<String> result = new AppendableList<String>();
        for (Join joinExpr : joinExprs) {
            result.add(joinExpr.expression);
        }
        return result;
    }

    private Join getJoinExpr(String table, List<Join> joinExprs) {
        Iterator<Join> iter = joinExprs.iterator();
        while (iter.hasNext()) {
            Join joinExpr = iter.next();
            if (!joinExpr.tables.contains(table)) continue;
            iter.remove();
            return joinExpr;
        }
        throw new IllegalStateException("Cannot find join table " + table);
    }

    private Collection<List<Row>> combineJoins(List<Row> joins) {
        LinkedHashMap comboJoinMap = new LinkedHashMap();
        for (Row join : joins) {
            List<String> key = Arrays.asList(join.name1, join.name2);
            ArrayList<Row> comboJoins = (ArrayList<Row>)comboJoinMap.get(key);
            if (comboJoins == null) {
                comboJoins = new ArrayList<Row>();
                comboJoinMap.put(key, comboJoins);
            } else if (((Row)comboJoins.get((int)0)).flag.shortValue() != join.flag.shortValue()) {
                throw new IllegalStateException("Mismatched join flags for combo joins");
            }
            comboJoins.add(join);
        }
        return comboJoinMap.values();
    }

    protected String getFromRemoteDbPath() {
        return this.getRemoteDatabaseRow().name1;
    }

    protected String getFromRemoteDbType() {
        return this.getRemoteDatabaseRow().expression;
    }

    protected String getWhereExpression() {
        return this.getWhereRow().expression;
    }

    protected List<String> getOrderings() {
        return new RowFormatter(this.getOrderByRows()){

            protected void format(StringBuilder builder, Row row) {
                builder.append(row.expression);
                if ("D".equalsIgnoreCase(row.name1)) {
                    builder.append(" DESC");
                }
            }
        }.format();
    }

    public String getOwnerAccessType() {
        return this.hasFlag(4) ? "WITH OWNERACCESS OPTION" : "";
    }

    protected boolean hasFlag(int flagMask) {
        return Query.hasFlag(this.getFlagRow(), flagMask);
    }

    protected boolean supportsStandardClauses() {
        return true;
    }

    public String toSQLString() {
        StringBuilder builder = new StringBuilder();
        if (this.supportsStandardClauses()) {
            this.toSQLParameterString(builder);
        }
        this.toSQLString(builder);
        if (this.supportsStandardClauses()) {
            String accessType = this.getOwnerAccessType();
            if (!"".equals(accessType)) {
                builder.append(QueryFormat.NEWLINE).append(accessType);
            }
            builder.append(';');
        }
        return builder.toString();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static Query create(int objectFlag, String name, List<Row> rows, int objectId) {
        try {
            switch (objectFlag) {
                case 0: {
                    return new SelectQuery(name, rows, objectId);
                }
                case 80: {
                    return new MakeTableQuery(name, rows, objectId);
                }
                case 64: {
                    return new AppendQuery(name, rows, objectId);
                }
                case 48: {
                    return new UpdateQuery(name, rows, objectId);
                }
                case 32: {
                    return new DeleteQuery(name, rows, objectId);
                }
                case 16: {
                    return new CrossTabQuery(name, rows, objectId);
                }
                case 96: {
                    return new DataDefinitionQuery(name, rows, objectId);
                }
                case 112: {
                    return new PassthroughQuery(name, rows, objectId);
                }
                case 128: {
                    return new UnionQuery(name, rows, objectId);
                }
            }
            throw new IllegalStateException("unknown query object flag " + objectFlag);
        }
        catch (IllegalStateException e) {
            LOG.warn((Object)"Failed parsing query", (Throwable)e);
            return new UnknownQuery(name, rows, objectId, objectFlag);
        }
    }

    private static Short getQueryType(List<Row> rows) {
        return Query.getUniqueRow(Query.getRowsByAttribute(rows, (Byte)QueryFormat.TYPE_ATTRIBUTE)).flag;
    }

    private static List<Row> getRowsByAttribute(List<Row> rows, Byte attribute) {
        ArrayList<Row> result = new ArrayList<Row>();
        for (Row row : rows) {
            if (!attribute.equals(row.attribute)) continue;
            result.add(row);
        }
        return result;
    }

    protected static Row getUniqueRow(List<Row> rows) {
        if (rows.size() == 1) {
            return rows.get(0);
        }
        if (rows.isEmpty()) {
            return EMPTY_ROW;
        }
        throw new IllegalStateException("Unexpected number of rows for" + rows);
    }

    protected static List<Row> filterRowsByFlag(List<Row> rows, final short flag) {
        return new RowFilter(){

            protected boolean keep(Row row) {
                return Query.hasFlag(row, flag);
            }
        }.filter(rows);
    }

    protected static List<Row> filterRowsByNotFlag(List<Row> rows, final short flag) {
        return new RowFilter(){

            protected boolean keep(Row row) {
                return !Query.hasFlag(row, flag);
            }
        }.filter(rows);
    }

    protected static boolean hasFlag(Row row, int flagMask) {
        return (Query.getShortValue(row.flag, 0) & flagMask) != 0;
    }

    protected static short getShortValue(Short s, int def) {
        return s != null ? s : (short)def;
    }

    protected static int getIntValue(Integer i, int def) {
        return i != null ? i : def;
    }

    protected static StringBuilder toOptionalQuotedExpr(StringBuilder builder, String fullExpr, boolean isIdentifier) {
        String[] stringArray;
        if (isIdentifier) {
            stringArray = QueryFormat.IDENTIFIER_SEP_PAT.split(fullExpr);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = fullExpr;
        }
        String[] exprs = stringArray;
        for (int i = 0; i < exprs.length; ++i) {
            String expr = exprs[i];
            if (QueryFormat.QUOTABLE_CHAR_PAT.matcher(expr).find()) {
                Query.toQuotedExpr(builder, expr);
            } else {
                builder.append(expr);
            }
            if (i >= exprs.length - 1) continue;
            builder.append('.');
        }
        return builder;
    }

    protected static StringBuilder toQuotedExpr(StringBuilder builder, String expr) {
        return builder.append('[').append(expr).append(']');
    }

    protected static StringBuilder toRemoteDb(StringBuilder builder, String remoteDbPath, String remoteDbType) {
        if (remoteDbPath != null || remoteDbType != null) {
            builder.append(" IN '");
            if (remoteDbPath != null) {
                builder.append(remoteDbPath);
            }
            builder.append('\'');
            if (remoteDbType != null) {
                builder.append(" [").append(remoteDbType).append(']');
            }
        }
        return builder;
    }

    protected static StringBuilder toAlias(StringBuilder builder, String alias) {
        if (alias != null) {
            Query.toOptionalQuotedExpr(builder.append(" AS "), alias, false);
        }
        return builder;
    }

    private static final class Join {
        public final List<String> tables = new ArrayList<String>();
        public boolean isJoin;
        public String expression;

        private Join(String table, String expr) {
            this.tables.add(table);
            this.expression = expr;
        }

        public void join(Join other, String newExpr) {
            this.tables.addAll(other.tables);
            this.isJoin = true;
            this.expression = newExpr;
        }

        public String toString() {
            return this.isJoin ? "(" + this.expression + ")" : this.expression;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AppendableList<E>
    extends ArrayList<E> {
        private static final long serialVersionUID = 0L;

        protected AppendableList() {
        }

        protected AppendableList(Collection<? extends E> c) {
            super(c);
        }

        protected String getSeparator() {
            return ", ";
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                builder.append(iter.next().toString());
                if (!iter.hasNext()) continue;
                builder.append(this.getSeparator());
            }
            return builder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class RowFilter {
        protected RowFilter() {
        }

        public List<Row> filter(List<Row> list) {
            Iterator<Row> iter = list.iterator();
            while (iter.hasNext()) {
                if (this.keep(iter.next())) continue;
                iter.remove();
            }
            return list;
        }

        protected abstract boolean keep(Row var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class RowFormatter {
        private final List<Row> _list;

        protected RowFormatter(List<Row> list) {
            this._list = list;
        }

        public List<String> format() {
            return this.format(new AppendableList<String>());
        }

        public List<String> format(List<String> strs) {
            for (Row row : this._list) {
                StringBuilder builder = new StringBuilder();
                this.format(builder, row);
                strs.add(builder.toString());
            }
            return strs;
        }

        protected abstract void format(StringBuilder var1, Row var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Row {
        public final Byte attribute;
        public final String expression;
        public final Short flag;
        public final Integer extra;
        public final String name1;
        public final String name2;
        public final Integer objectId;
        public final byte[] order;

        public Row(Map<String, Object> tableRow) {
            this((Byte)tableRow.get("Attribute"), (String)tableRow.get("Expression"), (Short)tableRow.get("Flag"), (Integer)tableRow.get("LvExtra"), (String)tableRow.get("Name1"), (String)tableRow.get("Name2"), (Integer)tableRow.get("ObjectId"), (byte[])tableRow.get("Order"));
        }

        public Row(Byte attribute, String expression, Short flag, Integer extra, String name1, String name2, Integer objectId, byte[] order) {
            this.attribute = attribute;
            this.expression = expression;
            this.flag = flag;
            this.extra = extra;
            this.name1 = name1;
            this.name2 = name2;
            this.objectId = objectId;
            this.order = order;
        }

        public Map<String, Object> toTableRow() {
            LinkedHashMap<String, Object> tableRow = new LinkedHashMap<String, Object>();
            tableRow.put("Attribute", this.attribute);
            tableRow.put("Expression", this.expression);
            tableRow.put("Flag", this.flag);
            tableRow.put("LvExtra", this.extra);
            tableRow.put("Name1", this.name1);
            tableRow.put("Name2", this.name2);
            tableRow.put("ObjectId", this.objectId);
            tableRow.put("Order", this.order);
            return tableRow;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnknownQuery
    extends Query {
        private final int _objectFlag;

        private UnknownQuery(String name, List<Row> rows, int objectId, int objectFlag) {
            super(name, rows, objectId, Type.UNKNOWN);
            this._objectFlag = objectFlag;
        }

        @Override
        public int getObjectFlag() {
            return this._objectFlag;
        }

        @Override
        protected void toSQLString(StringBuilder builder) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        SELECT(0, 1),
        MAKE_TABLE(80, 2),
        APPEND(64, 3),
        UPDATE(48, 4),
        DELETE(32, 5),
        CROSS_TAB(16, 6),
        DATA_DEFINITION(96, 7),
        PASSTHROUGH(112, 8),
        UNION(128, 9),
        UNKNOWN(-1, -1);

        private final int _objectFlag;
        private final short _value;

        private Type(int objectFlag, int value) {
            this._objectFlag = objectFlag;
            this._value = (short)value;
        }

        public int getObjectFlag() {
            return this._objectFlag;
        }

        public short getValue() {
            return this._value;
        }
    }
}

