/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

public class Region {
    public int x;
    public int y;
    public int width;
    public int height;

    public Region() {
    }

    public Region(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public boolean intersects(Region r) {
        int tw = this.width;
        int th = this.height;
        int rw = r.width;
        int rh = r.height;
        if (rw <= 0 || rh <= 0 || tw <= 0 || th <= 0) {
            return false;
        }
        int tx = this.x;
        int ty = this.y;
        int rx = r.x;
        int ry = r.y;
        rh += ry;
        tw += tx;
        th += ty;
        boolean rtn = !((rw += rx) >= rx && rw <= tx || rh >= ry && rh <= ty || tw >= tx && tw <= rx || th >= ty && th <= ry);
        return rtn;
    }

    public Region intersection(Region r) {
        int x = Math.max(this.x, r.x);
        int y = Math.max(this.y, r.y);
        int w = Math.min(this.x + this.width, r.x + r.width) - x;
        int h = Math.min(this.y + this.height, r.y + r.height) - y;
        if (w < 0) {
            w = 0;
        }
        if (h < 0) {
            h = 0;
        }
        return new Region(x, y, w, h);
    }

    public boolean containsPoint(int xc, int yc) {
        return this.intersects(new Region(xc, yc, 1, 1));
    }

    public String toString() {
        return "x=" + this.x + ", y=" + this.y + ", w=" + this.width + ", h=" + this.height;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Region)) {
            return false;
        }
        Region that = (Region)o;
        return this.x == that.x && this.y == that.y && this.width == that.width && this.height == that.height;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

