/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.awt.image.ColorModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import loci.common.Region;
import loci.formats.ClassList;
import loci.formats.FormatException;
import loci.formats.IFormatWriter;
import loci.formats.UnknownFormatException;
import loci.formats.codec.CodecOptions;
import loci.formats.meta.MetadataRetrieve;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageWriter
implements IFormatWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageWriter.class);
    private static ClassList<IFormatWriter> defaultClasses;
    protected IFormatWriter[] writers;
    private String[] suffixes;
    protected String[] compressionTypes;
    protected String currentId;
    protected int current;

    public static ClassList<IFormatWriter> getDefaultWriterClasses() {
        if (defaultClasses == null) {
            try {
                defaultClasses = new ClassList<IFormatWriter>("writers.txt", IFormatWriter.class);
            }
            catch (IOException exc) {
                defaultClasses = new ClassList<IFormatWriter>(IFormatWriter.class);
                LOGGER.info("Could not parse class list; using default classes", exc);
            }
        }
        return defaultClasses;
    }

    public ImageWriter() {
        this(ImageWriter.getDefaultWriterClasses());
    }

    public ImageWriter(ClassList<IFormatWriter> classList) {
        ArrayList<IFormatWriter> list = new ArrayList<IFormatWriter>();
        Class<IFormatWriter>[] c = classList.getClasses();
        for (int i = 0; i < c.length; ++i) {
            IFormatWriter writer = null;
            try {
                writer = c[i].newInstance();
            }
            catch (IllegalAccessException exc) {
            }
            catch (InstantiationException exc) {
                // empty catch block
            }
            if (writer == null) {
                LOGGER.error("{} cannot be instantiated.", (Object)c[i].getName());
                continue;
            }
            list.add(writer);
        }
        this.writers = new IFormatWriter[list.size()];
        list.toArray(this.writers);
    }

    public String getFormat(String id) throws FormatException, IOException {
        return this.getWriter(id).getFormat();
    }

    public IFormatWriter getWriter(String id) throws FormatException {
        if (!id.equals(this.currentId)) {
            boolean success = false;
            for (int i = 0; i < this.writers.length; ++i) {
                if (!this.writers[i].isThisType(id)) continue;
                this.current = i;
                this.currentId = id;
                success = true;
                break;
            }
            if (!success) {
                throw new UnknownFormatException("Unknown file format: " + id);
            }
        }
        return this.writers[this.current];
    }

    public IFormatWriter getWriter() {
        return this.writers[this.current];
    }

    public IFormatWriter getWriter(Class<? extends IFormatWriter> c) {
        for (int i = 0; i < this.writers.length; ++i) {
            if (!this.writers[i].getClass().equals(c)) continue;
            return this.writers[i];
        }
        return null;
    }

    public IFormatWriter[] getWriters() {
        IFormatWriter[] w = new IFormatWriter[this.writers.length];
        System.arraycopy(this.writers, 0, w, 0, this.writers.length);
        return w;
    }

    @Override
    public void changeOutputFile(String id) throws FormatException, IOException {
        this.getWriter().changeOutputFile(id);
    }

    @Override
    public void saveBytes(int no, byte[] buf) throws FormatException, IOException {
        this.getWriter().saveBytes(no, buf);
    }

    @Override
    public void saveBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        this.getWriter().saveBytes(no, buf, x, y, w, h);
    }

    @Override
    public void saveBytes(int no, byte[] buf, Region tile) throws FormatException, IOException {
        this.getWriter().saveBytes(no, buf, tile);
    }

    @Override
    public void savePlane(int no, Object plane) throws FormatException, IOException {
        this.getWriter().savePlane(no, plane);
    }

    @Override
    public void savePlane(int no, Object plane, int x, int y, int w, int h) throws FormatException, IOException {
        this.getWriter().savePlane(no, plane, x, y, w, h);
    }

    @Override
    public void savePlane(int no, Object plane, Region tile) throws FormatException, IOException {
        this.getWriter().savePlane(no, plane, tile);
    }

    @Override
    public void setSeries(int series) throws FormatException {
        this.getWriter().setSeries(series);
    }

    @Override
    public int getSeries() {
        return this.getWriter().getSeries();
    }

    @Override
    public void setInterleaved(boolean interleaved) {
        for (int i = 0; i < this.writers.length; ++i) {
            this.writers[i].setInterleaved(interleaved);
        }
    }

    @Override
    public boolean isInterleaved() {
        return this.writers[0].isInterleaved();
    }

    @Override
    public void setValidBitsPerPixel(int bits) {
        for (IFormatWriter writer : this.writers) {
            writer.setValidBitsPerPixel(bits);
        }
    }

    @Override
    public boolean canDoStacks() {
        return this.getWriter().canDoStacks();
    }

    @Override
    public void setMetadataRetrieve(MetadataRetrieve r) {
        for (int i = 0; i < this.writers.length; ++i) {
            this.writers[i].setMetadataRetrieve(r);
        }
    }

    @Override
    public MetadataRetrieve getMetadataRetrieve() {
        return this.getWriter().getMetadataRetrieve();
    }

    @Override
    public void setColorModel(ColorModel cm) {
        for (int i = 0; i < this.writers.length; ++i) {
            this.writers[i].setColorModel(cm);
        }
    }

    @Override
    public ColorModel getColorModel() {
        return this.writers[0].getColorModel();
    }

    @Override
    public void setFramesPerSecond(int rate) {
        for (int i = 0; i < this.writers.length; ++i) {
            this.writers[i].setFramesPerSecond(rate);
        }
    }

    @Override
    public int getFramesPerSecond() {
        return this.writers[0].getFramesPerSecond();
    }

    @Override
    public String[] getCompressionTypes() {
        if (this.compressionTypes == null) {
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < this.writers.length; ++i) {
                String[] s = this.writers[i].getCompressionTypes();
                if (s == null) continue;
                for (int j = 0; j < s.length; ++j) {
                    set.add(s[j]);
                }
            }
            this.compressionTypes = new String[set.size()];
            set.toArray(this.compressionTypes);
            Arrays.sort(this.compressionTypes);
        }
        return this.compressionTypes;
    }

    @Override
    public int[] getPixelTypes() {
        return this.getWriter().getPixelTypes();
    }

    @Override
    public int[] getPixelTypes(String codec) {
        return this.getWriter().getPixelTypes(codec);
    }

    @Override
    public boolean isSupportedType(int type) {
        return this.getWriter().isSupportedType(type);
    }

    @Override
    public void setCompression(String compress) throws FormatException {
        boolean ok = false;
        for (int i = 0; i < this.writers.length; ++i) {
            String[] s = this.writers[i].getCompressionTypes();
            if (s == null) continue;
            for (int j = 0; j < s.length; ++j) {
                if (!s[j].equals(compress)) continue;
                this.writers[i].setCompression(compress);
                ok = true;
            }
        }
        if (!ok) {
            throw new FormatException("Invalid compression type: " + compress);
        }
    }

    @Override
    public String getCompression() {
        return this.getWriter().getCompression();
    }

    @Override
    public void setWriteSequentially(boolean sequential) {
        for (IFormatWriter writer : this.writers) {
            writer.setWriteSequentially(sequential);
        }
    }

    @Override
    public void setCodecOptions(CodecOptions options) {
        this.getWriter().setCodecOptions(options);
    }

    @Override
    public void saveBytes(byte[] bytes, boolean last) throws FormatException, IOException {
        this.getWriter().saveBytes(bytes, last);
    }

    @Override
    public void saveBytes(byte[] bytes, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        this.getWriter().saveBytes(bytes, series, lastInSeries, last);
    }

    @Override
    public void savePlane(Object plane, boolean last) throws FormatException, IOException {
        this.getWriter().savePlane(plane, last);
    }

    @Override
    public void savePlane(Object plane, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        this.getWriter().savePlane(plane, series, lastInSeries, last);
    }

    @Override
    public boolean isThisType(String name) {
        for (int i = 0; i < this.writers.length; ++i) {
            if (!this.writers[i].isThisType(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getFormat() {
        return this.getWriter().getFormat();
    }

    @Override
    public String[] getSuffixes() {
        if (this.suffixes == null) {
            HashSet<String> suffixSet = new HashSet<String>();
            for (int i = 0; i < this.writers.length; ++i) {
                String[] suf = this.writers[i].getSuffixes();
                for (int j = 0; j < suf.length; ++j) {
                    suffixSet.add(suf[j]);
                }
            }
            this.suffixes = new String[suffixSet.size()];
            suffixSet.toArray(this.suffixes);
            Arrays.sort(this.suffixes);
        }
        return this.suffixes;
    }

    @Override
    public Class<?> getNativeDataType() {
        return this.getWriter().getNativeDataType();
    }

    @Override
    public void setId(String id) throws FormatException, IOException {
        this.getWriter(id).setId(id);
    }

    @Override
    public void close() throws IOException {
        this.getWriter().close();
    }
}

