/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import loci.formats.FormatTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeChecker {
    public static final String REGISTRY_IMAGEJ = "OMERO.imagej";
    public static final String REGISTRY_LIBRARY = "OMERO.bioformats";
    public static final String STABLE_VERSION = "4.4.10";
    public static final String CI_SERVER = "http://ci.openmicroscopy.org";
    public static final String TRUNK_BUILD = "http://ci.openmicroscopy.org/job/BIOFORMATS-trunk/lastSuccessfulBuild/artifact/artifacts/";
    public static final String DAILY_BUILD = "http://ci.openmicroscopy.org/job/BIOFORMATS-daily/lastSuccessfulBuild/artifact/artifacts/";
    public static final String STABLE_BUILD = "http://cvs.openmicroscopy.org.uk/snapshots/bioformats/4.4.10/";
    public static final String TOOLS = "loci_tools.jar";
    public static final String OME_TOOLS = "ome_tools.jar";
    public static final String[] INDIVIDUAL_JARS = new String[]{"bio-formats.jar", "jai_imageio.jar", "loci-common.jar", "mdbtools-java.jar", "metakit.jar", "ome-io.jar", "ome-xml.jar", "poi-loci.jar", "scifio.jar"};
    public static final String REGISTRY = "http://upgrade.openmicroscopy.org.uk";
    public static final String DEFAULT_CALLER = "Bio-Formats utilities";
    private static final String[] REGISTRY_PROPERTIES = new String[]{"version", "os.name", "os.version", "os.arch", "java.runtime.version", "java.vm.vendor", "bioformats.caller"};
    private static final String UPGRADE_CHECK_PROPERTY = "bioformats_upgrade_check";
    private static final String UPGRADE_CHECK_ALLOWED_PROPERTY = "bioformats_can_do_upgrade_check";
    private static final int CHUNK_SIZE = 8192;
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeChecker.class);

    public boolean alreadyChecked() {
        String checked = System.getProperty(UPGRADE_CHECK_PROPERTY);
        if (checked == null) {
            return false;
        }
        return Boolean.parseBoolean(checked);
    }

    public boolean canDoUpgradeCheck() {
        String checked = System.getProperty(UPGRADE_CHECK_ALLOWED_PROPERTY);
        if (checked == null) {
            return true;
        }
        return Boolean.parseBoolean(checked);
    }

    public void setCanDoUpgradeCheck(boolean canDo) {
        System.setProperty(UPGRADE_CHECK_ALLOWED_PROPERTY, String.valueOf(canDo));
    }

    public boolean newVersionAvailable(String caller) {
        return this.newVersionAvailable(REGISTRY_LIBRARY, caller);
    }

    public boolean newVersionAvailable(String registryID, String caller) {
        if (!this.canDoUpgradeCheck()) {
            return false;
        }
        System.setProperty("bioformats.caller", caller);
        StringBuffer query = new StringBuffer(REGISTRY);
        for (int i = 0; i < REGISTRY_PROPERTIES.length; ++i) {
            if (i == 0) {
                query.append("?");
            } else {
                query.append(";");
            }
            query.append(REGISTRY_PROPERTIES[i]);
            query.append("=");
            if (i == 0) {
                query.append(FormatTools.VERSION);
                continue;
            }
            try {
                query.append(URLEncoder.encode(System.getProperty(REGISTRY_PROPERTIES[i]), "UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.warn("Failed to append query argument: " + REGISTRY_PROPERTIES[i], e);
            }
        }
        System.setProperty(UPGRADE_CHECK_PROPERTY, "true");
        try {
            int data;
            URLConnection conn = new URL(query.toString()).openConnection();
            conn.setConnectTimeout(5000);
            conn.setUseCaches(false);
            conn.addRequestProperty("User-Agent", registryID);
            conn.connect();
            InputStream in = conn.getInputStream();
            StringBuffer latestVersion = new StringBuffer();
            while ((data = in.read()) != -1) {
                latestVersion.append((char)data);
            }
            in.close();
            String[] version = latestVersion.toString().split("\\.");
            String[] thisVersion = FormatTools.VERSION.split("\\.");
            for (int i = 0; i < thisVersion.length; ++i) {
                try {
                    int subVersion = Integer.parseInt(thisVersion[i]);
                    int registrySubVersion = Integer.parseInt(version[i]);
                    if (registrySubVersion == subVersion) continue;
                    return registrySubVersion > subVersion;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to compare version numbers", e);
        }
        return false;
    }

    public boolean installIndividualJars(String urlDir, String downloadDir) {
        boolean overallSuccess = true;
        for (String jar : INDIVIDUAL_JARS) {
            boolean success = this.install(urlDir + File.separator + jar, downloadDir + File.separator + jar);
            if (!overallSuccess) continue;
            success = overallSuccess;
        }
        return overallSuccess;
    }

    public boolean install(String urlPath, String downloadPath) {
        File jar = new File(downloadPath + ".tmp");
        if (jar.exists() && !jar.delete()) {
            LOGGER.warn("Failed to delete '{}'", (Object)jar.getAbsolutePath());
            return false;
        }
        try {
            int r;
            URL url = new URL(urlPath);
            URLConnection urlConn = url.openConnection();
            int total = urlConn.getContentLength();
            byte[] buf = new byte[total];
            DataInputStream in = new DataInputStream(new BufferedInputStream(urlConn.getInputStream()));
            for (int off = 0; off < total; off += r) {
                int len = 8192;
                if (off + len > total) {
                    len = total - off;
                }
                if ((r = in.read(buf, off, len)) > 0) continue;
                LOGGER.warn("Truncated JAR file");
                return false;
            }
            in.close();
            FileOutputStream out = new FileOutputStream(jar);
            out.write(buf);
            out.close();
            boolean success = jar.renameTo(new File(downloadPath));
            if (!success) {
                LOGGER.warn("Failed to rename '{}' to '{}'", (Object)jar.getAbsolutePath(), (Object)downloadPath);
            }
            return success;
        }
        catch (IOException e) {
            LOGGER.warn("Failed to download from " + urlPath, e);
            return false;
        }
    }
}

