/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.color.CMMException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import loci.common.ByteArrayHandle;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.DelegateReader;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.in.ImageIOReader;
import loci.formats.in.TileJPEGReader;

public class JPEGReader
extends DelegateReader {
    private static final int MAX_SIZE = 8192;

    public JPEGReader() {
        super("JPEG", new String[]{"jpg", "jpeg", "jpe"});
        this.nativeReader = new DefaultJPEGReader();
        this.legacyReader = new TileJPEGReader();
        this.nativeReaderInitialized = false;
        this.legacyReaderInitialized = false;
        this.domains = new String[]{"Graphics"};
        this.suffixNecessary = false;
    }

    @Override
    public void setId(String id) throws FormatException, IOException {
        try {
            super.setId(id);
        }
        catch (CMMException e) {
            this.in = new RandomAccessInputStream(id);
            ByteArrayOutputStream v = new ByteArrayOutputStream();
            byte[] tag = new byte[2];
            this.in.read(tag);
            v.write(tag);
            this.in.read(tag);
            int tagValue = DataTools.bytesToShort(tag, false) & 0xFFFF;
            boolean appNoteFound = false;
            while (tagValue != 65499) {
                int len;
                if (!appNoteFound || tagValue < 65504 && tagValue >= 65520) {
                    v.write(tag);
                    this.in.read(tag);
                    len = DataTools.bytesToShort(tag, false) & 0xFFFF;
                    byte[] tagContents = new byte[len - 2];
                    this.in.read(tagContents);
                    v.write(tag);
                    v.write(tagContents);
                } else {
                    this.in.read(tag);
                    len = DataTools.bytesToShort(tag, false) & 0xFFFF;
                    this.in.skipBytes(len - 2);
                }
                if (tagValue >= 65504 && tagValue < 65520 && !appNoteFound) {
                    appNoteFound = true;
                }
                this.in.read(tag);
                tagValue = DataTools.bytesToShort(tag, false) & 0xFFFF;
            }
            v.write(tag);
            byte[] remainder = new byte[(int)(this.in.length() - this.in.getFilePointer())];
            this.in.read(remainder);
            v.write(remainder);
            ByteArrayHandle bytes = new ByteArrayHandle(v.toByteArray());
            Location.mapFile(this.currentId + ".fixed", bytes);
            super.setId(this.currentId + ".fixed");
        }
        if (this.getSizeX() > 8192 && this.getSizeY() > 8192 && !this.legacyReaderInitialized) {
            this.close();
            this.useLegacy = true;
            super.setId(id);
        }
        this.currentId = id;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        Location.mapId(this.currentId, null);
    }

    class DefaultJPEGReader
    extends ImageIOReader {
        public DefaultJPEGReader() {
            super("JPEG", new String[]{"jpg", "jpeg", "jpe"});
            this.suffixNecessary = false;
            this.suffixSufficient = false;
        }

        @Override
        public boolean isThisType(String name, boolean open) {
            if (open) {
                return super.isThisType(name, open);
            }
            return DefaultJPEGReader.checkSuffix(name, this.getSuffixes());
        }

        @Override
        public boolean isThisType(RandomAccessInputStream stream) throws IOException {
            int blockLen = 4;
            if (!FormatTools.validStream(stream, 4, false)) {
                return false;
            }
            byte[] signature = new byte[4];
            stream.read(signature);
            return signature[0] == -1 && signature[1] == -40 && signature[2] == -1 && (signature[3] & 0xF0) != 0;
        }
    }
}

