/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.PhotoInterp;

public class JPKReader
extends BaseTiffReader {
    public JPKReader() {
        super("JPK Instruments", "jpk");
        this.domains = new String[]{"Scanning Electron Microscopy (SEM)"};
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        return JPKReader.checkSuffix(name, "jpk");
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        if (this.getSeriesCount() == 1) {
            return super.openBytes(no, buf, x, y, w, h);
        }
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int ifd = this.series == 0 ? 0 : no + 1;
        this.tiffParser.fillInIFD((IFD)this.ifds.get(ifd));
        this.tiffParser.getSamples((IFD)this.ifds.get(ifd), buf, x, y, w, h);
        return buf;
    }

    @Override
    protected void initStandardMetadata() throws FormatException, IOException {
        super.initStandardMetadata();
        this.ifds = this.tiffParser.getIFDs();
        this.core = new CoreMetadata[this.ifds.size() > 1 ? 2 : 1];
        for (int s = 0; s < this.core.length; ++s) {
            this.core[s] = new CoreMetadata();
            IFD ifd = (IFD)this.ifds.get(s);
            this.tiffParser.fillInIFD(ifd);
            PhotoInterp p = ifd.getPhotometricInterpretation();
            int samples = ifd.getSamplesPerPixel();
            this.core[s].rgb = samples > 1 || p == PhotoInterp.RGB;
            this.core[s].sizeX = (int)ifd.getImageWidth();
            this.core[s].sizeY = (int)ifd.getImageLength();
            this.core[s].sizeZ = 1;
            this.core[s].sizeT = s == 0 ? 1 : this.ifds.size() - 1;
            this.core[s].sizeC = this.core[s].rgb ? samples : 1;
            this.core[s].littleEndian = ifd.isLittleEndian();
            this.core[s].indexed = p == PhotoInterp.RGB_PALETTE && (this.get8BitLookupTable() != null || this.get16BitLookupTable() != null);
            this.core[s].imageCount = s == 0 ? 1 : this.ifds.size() - 1;
            this.core[s].pixelType = ifd.getPixelType();
            this.core[s].metadataComplete = true;
            this.core[s].interleaved = false;
            this.core[s].falseColor = false;
            this.core[s].dimensionOrder = "XYCZT";
            if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) continue;
            this.setSeries(s);
            for (Integer key : ((IFD)this.ifds.get(s)).keySet()) {
                if (key < 32848) continue;
                this.addSeriesMeta("Tag " + key, ((IFD)this.ifds.get(s)).get(key));
            }
        }
        this.setSeries(0);
    }

    @Override
    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            store.setImageName("Series " + (i + 1), i);
        }
    }
}

