/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.util.Hashtable;
import java.util.Vector;
import loci.common.xml.BaseHandler;
import org.xml.sax.Attributes;

public class MetamorphHandler
extends BaseHandler {
    private Hashtable metadata;
    private Vector<String> timestamps;
    private String imageName;
    private String date;
    private Vector<Integer> wavelengths;
    private Vector<Double> zPositions;
    private double pixelSizeX;
    private double pixelSizeY;
    private double temperature;
    private String binning;
    private double readOutRate;
    private double zoom;
    private double positionX;
    private double positionY;
    private Vector<Double> exposures;
    private String channelName;
    private String stageLabel;
    private Double gain;

    public MetamorphHandler() {
        this(null);
    }

    public MetamorphHandler(Hashtable metadata) {
        this.metadata = metadata;
        this.timestamps = new Vector();
        this.wavelengths = new Vector();
        this.zPositions = new Vector();
        this.exposures = new Vector();
    }

    public Double getGain() {
        return this.gain;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public String getStageLabel() {
        return this.stageLabel;
    }

    public Vector<String> getTimestamps() {
        return this.timestamps;
    }

    public Vector<Integer> getWavelengths() {
        return this.wavelengths;
    }

    public Vector<Double> getZPositions() {
        return this.zPositions;
    }

    public String getDate() {
        return this.date;
    }

    public String getImageName() {
        return this.imageName;
    }

    public double getPixelSizeX() {
        return this.pixelSizeX;
    }

    public double getPixelSizeY() {
        return this.pixelSizeY;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public String getBinning() {
        return this.binning;
    }

    public double getReadOutRate() {
        return this.readOutRate;
    }

    public double getZoom() {
        return this.zoom;
    }

    public double getStagePositionX() {
        return this.positionX;
    }

    public double getStagePositionY() {
        return this.positionY;
    }

    public Vector<Double> getExposures() {
        return this.exposures;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        String id = attributes.getValue("id");
        String value = attributes.getValue("value");
        String delim = "&#13;&#10;";
        if (id != null && value != null) {
            if (id.equals("Description")) {
                if (this.metadata != null) {
                    this.metadata.remove("Comment");
                }
                String k = null;
                String v = null;
                if (value.indexOf(delim) != -1) {
                    int currentIndex = -delim.length();
                    while (currentIndex != -1) {
                        int nextIndex = value.indexOf(delim, currentIndex += delim.length());
                        String line = null;
                        line = nextIndex == -1 ? value.substring(currentIndex, value.length()) : value.substring(currentIndex, nextIndex);
                        currentIndex = nextIndex;
                        int colon = line.indexOf(":");
                        if (colon == -1) continue;
                        k = line.substring(0, colon).trim();
                        v = line.substring(colon + 1).trim();
                        if (this.metadata != null) {
                            this.metadata.put(k, v);
                        }
                        this.checkKey(k, v);
                    }
                } else {
                    int colon = value.indexOf(":");
                    while (colon != -1) {
                        k = value.substring(0, colon);
                        int space = value.lastIndexOf(" ", value.indexOf(":", colon + 1));
                        if (space == -1) {
                            space = value.length();
                        }
                        v = value.substring(colon + 1, space).trim();
                        if (this.metadata != null) {
                            this.metadata.put(k, v);
                        }
                        value = value.substring(space).trim();
                        colon = value.indexOf(":");
                        this.checkKey(k, v);
                    }
                }
            } else {
                if (this.metadata != null) {
                    this.metadata.put(id, value);
                }
                this.checkKey(id, value);
            }
        }
    }

    private void checkKey(String key, String value) {
        if (key.equals("Temperature")) {
            this.temperature = Double.parseDouble(value);
        } else if (key.equals("spatial-calibration-x")) {
            this.pixelSizeX = Double.parseDouble(value);
        } else if (key.equals("spatial-calibration-y")) {
            this.pixelSizeY = Double.parseDouble(value);
        } else if (key.equals("z-position")) {
            this.zPositions.add(new Double(value));
        } else if (key.equals("wavelength")) {
            this.wavelengths.add(new Integer(value));
        } else if (key.equals("acquisition-time-local")) {
            this.date = value;
            this.timestamps.add(this.date);
        } else if (key.equals("image-name")) {
            this.imageName = value;
        } else if (key.equals("Binning")) {
            this.binning = value;
        } else if (key.equals("Readout Frequency")) {
            this.readOutRate = Double.parseDouble(value);
        } else if (key.equals("zoom-percent")) {
            this.zoom = Double.parseDouble(value);
        } else if (key.equals("stage-position-x")) {
            this.positionX = Double.parseDouble(value);
            if (this.metadata != null) {
                this.metadata.put("X position for position #1", this.positionX);
            }
        } else if (key.equals("stage-position-y")) {
            this.positionY = Double.parseDouble(value);
            if (this.metadata != null) {
                this.metadata.put("Y position for position #1", this.positionY);
            }
        } else if (key.equals("Speed")) {
            int space = value.indexOf(" ");
            if (space > 0) {
                value = value.substring(0, space);
            }
            try {
                this.readOutRate = Double.parseDouble(value.trim());
            }
            catch (NumberFormatException e) {}
        } else if (key.equals("Exposure")) {
            if (value.indexOf(" ") != -1) {
                value = value.substring(0, value.indexOf(" "));
            }
            try {
                this.exposures.add(new Double(Double.parseDouble(value) / 1000.0));
            }
            catch (NumberFormatException e) {}
        } else if (key.equals("_IllumSetting_")) {
            this.channelName = value;
        } else if (key.equals("stage-label")) {
            this.stageLabel = value;
        } else if (key.endsWith("Gain") && this.gain == null) {
            try {
                this.gain = new Double(value.replaceAll("[xX]", ""));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

