/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.FileNotFoundException;
import java.io.IOException;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.PositiveFloat;

public class NiftiReader
extends FormatReader {
    private static final int UNITS_METER = 1;
    private static final int UNITS_MM = 2;
    private static final int UNITS_MSEC = 16;
    private static final int UNITS_USEC = 24;
    private int pixelOffset;
    private RandomAccessInputStream pixelFile;
    private String pixelsFilename;
    private short nDimensions;
    private String description;
    private double voxelWidth;
    private double voxelHeight;
    private double sliceThickness;
    private double deltaT;

    public NiftiReader() {
        super("NIfTI", new String[]{"nii", "img", "hdr"});
        this.suffixSufficient = false;
        this.domains = new String[]{"Medical Imaging", "Unknown"};
        this.hasCompanionFiles = true;
        this.datasetDescription = "A single .nii file or one .img file and a similarly-named .hdr file";
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return NiftiReader.checkSuffix(id, "nii");
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        if (NiftiReader.checkSuffix(name, "nii")) {
            return true;
        }
        int dot = name.lastIndexOf(".");
        if (dot == 0) {
            dot = name.length() - 1;
        }
        if (dot < 0) {
            return false;
        }
        if (!open) {
            return false;
        }
        String headerFile = name.substring(0, dot) + ".hdr";
        try {
            RandomAccessInputStream header = new RandomAccessInputStream(headerFile);
            boolean isValid = this.isThisType(header);
            header.close();
            return isValid;
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            LOGGER.debug("", e);
        }
        return false;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 348;
        if (!FormatTools.validStream(stream, 348, false)) {
            return false;
        }
        stream.seek(344L);
        String magic = stream.readString(3);
        return magic.equals("ni1") || magic.equals("n+1");
    }

    @Override
    public String[] getDomains() {
        FormatTools.assertId(this.currentId, true, 1);
        String[] domain = new String[]{this.nDimensions <= 3 ? "Unknown" : "Medical Imaging"};
        return domain;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int planeSize = FormatTools.getPlaneSize(this);
        this.pixelFile.seek(this.pixelOffset + no * planeSize);
        this.readPlane(this.pixelFile, x, y, w, h, buf);
        return buf;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.pixelsFilename.equals(this.currentId) && noPixels) {
            return null;
        }
        if (!noPixels && !this.pixelsFilename.equals(this.currentId)) {
            return new String[]{this.currentId, this.pixelsFilename};
        }
        return new String[]{this.currentId};
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.pixelFile != null) {
            this.pixelFile.close();
        }
        if (!fileOnly) {
            this.pixelOffset = 0;
            this.pixelFile = null;
            this.pixelsFilename = null;
            this.nDimensions = 0;
            this.description = null;
            this.deltaT = 0.0;
            this.sliceThickness = 0.0;
            this.voxelHeight = 0.0;
            this.voxelWidth = 0.0;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        if (id.endsWith(".img")) {
            LOGGER.info("Looking for header file");
            String header = id.substring(0, id.lastIndexOf(".")) + ".hdr";
            if (new Location(header).exists()) {
                this.setId(header);
                return;
            }
            throw new FormatException("Header file not found.");
        }
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.in.seek(40L);
        short check = this.in.readShort();
        boolean little = check < 1 || check > 7;
        this.in.seek(40L);
        if (id.endsWith(".hdr")) {
            this.pixelsFilename = id.substring(0, id.lastIndexOf(".")) + ".img";
            this.pixelFile = new RandomAccessInputStream(this.pixelsFilename);
        } else if (id.endsWith(".nii")) {
            this.pixelsFilename = id;
            this.pixelFile = this.in;
        }
        this.in.order(little);
        this.pixelFile.order(little);
        this.core[0].littleEndian = little;
        LOGGER.info("Reading header");
        this.nDimensions = this.in.readShort();
        this.core[0].sizeX = this.in.readShort();
        this.core[0].sizeY = this.in.readShort();
        this.core[0].sizeZ = this.in.readShort();
        this.core[0].sizeT = this.in.readShort();
        this.in.skipBytes(20);
        short dataType = this.in.readShort();
        this.in.skipBytes(36);
        this.pixelOffset = (int)this.in.readFloat();
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            this.populateExtendedMetadata();
        }
        LOGGER.info("Populating core metadata");
        this.core[0].sizeC = 1;
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        if (this.getSizeT() == 0) {
            this.core[0].sizeT = 1;
        }
        this.core[0].imageCount = this.getSizeZ() * this.getSizeT();
        this.core[0].indexed = false;
        this.core[0].dimensionOrder = "XYCZT";
        this.populatePixelType(dataType);
        this.core[0].rgb = this.getSizeC() > 1;
        this.core[0].interleaved = this.isRGB();
        LOGGER.info("Populating MetadataStore");
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            store.setImageDescription(this.description, 0);
            PositiveFloat sizeX = FormatTools.getPhysicalSizeX(new Double(this.voxelWidth));
            PositiveFloat sizeY = FormatTools.getPhysicalSizeY(new Double(this.voxelHeight));
            PositiveFloat sizeZ = FormatTools.getPhysicalSizeZ(new Double(this.sliceThickness));
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, 0);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, 0);
            }
            if (sizeZ != null) {
                store.setPixelsPhysicalSizeZ(sizeZ, 0);
            }
            store.setPixelsTimeIncrement(new Double(this.deltaT), 0);
        }
    }

    private void populatePixelType(int dataType) throws FormatException {
        switch (dataType) {
            case 1: 
            case 2: {
                this.core[0].pixelType = 1;
                break;
            }
            case 4: {
                this.core[0].pixelType = 2;
                break;
            }
            case 8: {
                this.core[0].pixelType = 4;
                break;
            }
            case 16: {
                this.core[0].pixelType = 6;
                break;
            }
            case 64: {
                this.core[0].pixelType = 7;
                break;
            }
            case 128: {
                this.core[0].pixelType = 1;
                this.core[0].sizeC = 3;
            }
            case 256: {
                this.core[0].pixelType = 0;
                break;
            }
            case 512: {
                this.core[0].pixelType = 3;
                break;
            }
            case 768: {
                this.core[0].pixelType = 5;
                break;
            }
            case 2304: {
                this.core[0].pixelType = 1;
                this.core[0].sizeC = 4;
            }
            default: {
                throw new FormatException("Unsupported data type: " + dataType);
            }
        }
    }

    private void populateExtendedMetadata() throws IOException {
        this.in.seek(40L);
        char sliceOrdering = this.in.readChar();
        this.in.skipBytes(8);
        short dim5 = this.in.readShort();
        short dim6 = this.in.readShort();
        short dim7 = this.in.readShort();
        float intent1 = this.in.readFloat();
        float intent2 = this.in.readFloat();
        float intent3 = this.in.readFloat();
        short intentCode = this.in.readShort();
        short dataType = this.in.readShort();
        short bitpix = this.in.readShort();
        short sliceStart = this.in.readShort();
        this.in.skipBytes(4);
        this.voxelWidth = this.in.readFloat();
        this.voxelHeight = this.in.readFloat();
        this.sliceThickness = this.in.readFloat();
        this.deltaT = this.in.readFloat();
        this.in.skipBytes(16);
        float scaleSlope = this.in.readFloat();
        float scaleIntercept = this.in.readFloat();
        short sliceEnd = this.in.readShort();
        char sliceCode = this.in.readChar();
        char units = this.in.readChar();
        int spatialUnits = units & 7;
        int timeUnits = units & 0x38;
        int spatialCorrection = 1;
        switch (spatialUnits) {
            case 1: {
                spatialCorrection = 1000000;
                break;
            }
            case 2: {
                spatialCorrection = 1000;
            }
        }
        this.voxelWidth *= (double)spatialCorrection;
        this.voxelHeight *= (double)spatialCorrection;
        this.sliceThickness *= (double)spatialCorrection;
        int timeCorrection = 1;
        switch (timeUnits) {
            case 16: {
                timeCorrection = 1000;
                break;
            }
            case 24: {
                timeCorrection = 1000000;
            }
        }
        this.deltaT /= (double)timeCorrection;
        float calMax = this.in.readFloat();
        float calMin = this.in.readFloat();
        float sliceDuration = this.in.readFloat();
        float toffset = this.in.readFloat();
        this.in.skipBytes(8);
        this.description = this.in.readString(80);
        this.in.skipBytes(24);
        short qformCode = this.in.readShort();
        short sformCode = this.in.readShort();
        float quaternionB = this.in.readFloat();
        float quaternionC = this.in.readFloat();
        float quaternionD = this.in.readFloat();
        float quaternionX = this.in.readFloat();
        float quaternionY = this.in.readFloat();
        float quaternionZ = this.in.readFloat();
        float[][] transform = new float[3][4];
        for (int i = 0; i < transform.length; ++i) {
            for (int j = 0; j < transform[i].length; ++j) {
                transform[i][j] = this.in.readFloat();
            }
        }
        String intentName = this.in.readString(16);
        if (this.in.getFilePointer() + 4L < this.in.length()) {
            this.in.skipBytes(4);
            byte extension = this.in.readByte();
            this.in.skipBytes(3);
            if (extension != 0) {
                long max;
                long l = max = this.in.equals(this.pixelFile) ? (long)this.pixelOffset : this.in.length();
                while (this.in.getFilePointer() < max) {
                    long fp = this.in.getFilePointer();
                    int esize = this.in.readInt();
                    int ecode = this.in.readInt();
                    if (ecode == 2 || ecode == 4) {
                        // empty if block
                    }
                    this.in.seek(fp + (long)esize);
                }
            }
        }
        LOGGER.info("Populating metadata table");
        for (int i = 0; i < transform.length; ++i) {
            String axis = i == 0 ? "X" : (i == 1 ? "Y" : "Z");
            for (int j = 0; j < transform[i].length; ++j) {
                this.addGlobalMeta("Affine transform " + axis + "[" + j + "]", transform[i][j]);
            }
        }
        this.addGlobalMeta("Intent name", intentName);
        this.addGlobalMeta("Slice Ordering", sliceOrdering);
        this.addGlobalMeta("Number of dimensions", this.nDimensions);
        this.addGlobalMeta("Width", this.getSizeX());
        this.addGlobalMeta("Height", this.getSizeY());
        this.addGlobalMeta("Number of Z slices", this.getSizeZ());
        this.addGlobalMeta("Number of time points", this.getSizeT());
        this.addGlobalMeta("Dimension 5", dim5);
        this.addGlobalMeta("Dimension 6", dim6);
        this.addGlobalMeta("Dimension 7", dim7);
        this.addGlobalMeta("Intent #1", intent1);
        this.addGlobalMeta("Intent #2", intent2);
        this.addGlobalMeta("Intent #3", intent3);
        this.addGlobalMeta("Intent code", intentCode);
        this.addGlobalMeta("Data type", dataType);
        this.addGlobalMeta("Bits per pixel", bitpix);
        this.addGlobalMeta("Slice start", sliceStart);
        this.addGlobalMeta("Voxel width", this.voxelWidth);
        this.addGlobalMeta("Voxel height", this.voxelHeight);
        this.addGlobalMeta("Slice thickness", this.sliceThickness);
        this.addGlobalMeta("Time increment", this.deltaT);
        this.addGlobalMeta("Scale slope", scaleSlope);
        this.addGlobalMeta("Scale intercept", scaleIntercept);
        this.addGlobalMeta("Slice end", sliceEnd);
        this.addGlobalMeta("Calibrated maximum", calMax);
        this.addGlobalMeta("Calibrated minimum", calMin);
        this.addGlobalMeta("Slice duration", sliceDuration);
        this.addGlobalMeta("Time offset", toffset);
        this.addGlobalMeta("Description", this.description);
        this.addGlobalMeta("Q-form Code", qformCode);
        this.addGlobalMeta("S-form Code", sformCode);
        this.addGlobalMeta("Quaternion b parameter", quaternionB);
        this.addGlobalMeta("Quaternion c parameter", quaternionC);
        this.addGlobalMeta("Quaternion d parameter", quaternionD);
        this.addGlobalMeta("Quaternion x parameter", quaternionX);
        this.addGlobalMeta("Quaternion y parameter", quaternionY);
        this.addGlobalMeta("Quaternion z parameter", quaternionZ);
    }
}

