/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.MissingLibraryException;
import loci.formats.in.MinimalTiffReader;
import loci.formats.in.TiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffIFDEntry;
import loci.formats.tiff.TiffParser;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PrimitiveType;
import ome.xml.model.primitives.Timestamp;

public class OMETiffReader
extends FormatReader {
    protected OMETiffPlane[][] info;
    protected String[] used;
    private int lastPlane = 0;
    private boolean hasSPW;
    private int[] tileWidth;
    private int[] tileHeight;
    private OMEXMLService service;

    public OMETiffReader() {
        super("OME-TIFF", new String[]{"ome.tif", "ome.tiff"});
        this.suffixNecessary = false;
        this.suffixSufficient = false;
        this.domains = FormatTools.NON_GRAPHICS_DOMAINS;
        this.hasCompanionFiles = true;
        this.datasetDescription = "One or more .ome.tiff files";
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        OMEXMLMetadata meta;
        String fileName = new Location(id).getAbsoluteFile().getAbsolutePath();
        RandomAccessInputStream ras = new RandomAccessInputStream(fileName);
        TiffParser tp = new TiffParser(ras);
        IFD ifd = tp.getFirstIFD();
        long[] ifdOffsets = tp.getIFDOffsets();
        ras.close();
        String xml = ifd.getComment();
        if (this.service == null) {
            this.setupService();
        }
        try {
            meta = this.service.createOMEXMLMetadata(xml);
        }
        catch (ServiceException se) {
            throw new FormatException(se);
        }
        if (meta.getRoot() == null) {
            throw new FormatException("Could not parse OME-XML from TIFF comment");
        }
        int nImages = 0;
        for (int i = 0; i < meta.getImageCount(); ++i) {
            int nChannels = meta.getChannelCount(i);
            if (nChannels == 0) {
                nChannels = 1;
            }
            int z = (Integer)meta.getPixelsSizeZ(i).getValue();
            int t = (Integer)meta.getPixelsSizeT(i).getValue();
            nImages += z * t * nChannels;
        }
        return nImages <= ifdOffsets.length;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tp = new TiffParser(stream);
        tp.setDoCaching(false);
        boolean validHeader = tp.isValidHeader();
        if (!validHeader) {
            return false;
        }
        IFD ifd = tp.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        Object description = ifd.get(270);
        if (description == null) {
            return false;
        }
        String comment = null;
        if (description instanceof TiffIFDEntry) {
            Object value = tp.getIFDValue((TiffIFDEntry)description);
            if (value != null) {
                comment = value.toString();
            }
        } else if (description instanceof String) {
            comment = (String)description;
        }
        if (comment == null || comment.trim().length() == 0) {
            return false;
        }
        if (!(comment = comment.trim()).startsWith("<") || !comment.endsWith(">")) {
            return false;
        }
        try {
            if (this.service == null) {
                this.setupService();
            }
            OMEXMLMetadata meta = this.service.createOMEXMLMetadata(comment);
            for (int i = 0; i < meta.getImageCount(); ++i) {
                meta.setPixelsBinDataBigEndian(Boolean.TRUE, i, 0);
                MetadataTools.verifyMinimumPopulated(meta, i);
            }
            return meta.getImageCount() > 0;
        }
        catch (ServiceException se) {
            LOGGER.debug("OME-XML parsing failed", se);
        }
        catch (NullPointerException e) {
            LOGGER.debug("OME-XML parsing failed", e);
        }
        catch (FormatException e) {
            LOGGER.debug("OME-XML parsing failed", e);
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.debug("OME-XML parsing failed", e);
        }
        return false;
    }

    @Override
    public String[] getDomains() {
        String[] stringArray;
        FormatTools.assertId(this.currentId, true, 1);
        if (this.hasSPW) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "High-Content Screening (HCS)";
        } else {
            stringArray = FormatTools.NON_SPECIAL_DOMAINS;
        }
        return stringArray;
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        if (this.info[this.series][this.lastPlane] == null || this.info[this.series][this.lastPlane].reader == null || this.info[this.series][this.lastPlane].id == null) {
            return null;
        }
        this.info[this.series][this.lastPlane].reader.setId(this.info[this.series][this.lastPlane].id);
        return this.info[this.series][this.lastPlane].reader.get8BitLookupTable();
    }

    @Override
    public short[][] get16BitLookupTable() throws FormatException, IOException {
        if (this.info[this.series][this.lastPlane] == null || this.info[this.series][this.lastPlane].reader == null || this.info[this.series][this.lastPlane].id == null) {
            return null;
        }
        this.info[this.series][this.lastPlane].reader.setId(this.info[this.series][this.lastPlane].id);
        return this.info[this.series][this.lastPlane].reader.get16BitLookupTable();
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        IFDList ifdList;
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.lastPlane = no;
        int i = this.info[this.series][no].ifd;
        MinimalTiffReader r = (MinimalTiffReader)this.info[this.series][no].reader;
        if (r.getCurrentFile() == null) {
            r.setId(this.info[this.series][no].id);
        }
        if (i >= (ifdList = r.getIFDs()).size()) {
            LOGGER.warn("Error untangling IFDs; the OME-TIFF file may be malformed.");
            return buf;
        }
        IFD ifd = (IFD)ifdList.get(i);
        RandomAccessInputStream s = new RandomAccessInputStream(this.info[this.series][no].id);
        TiffParser p = new TiffParser(s);
        p.getSamples(ifd, buf, x, y, w, h);
        s.close();
        return buf;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            return null;
        }
        Vector<String> usedFiles = new Vector<String>();
        for (int i = 0; i < this.info[this.series].length; ++i) {
            if (usedFiles.contains(this.info[this.series][i].id)) continue;
            usedFiles.add(this.info[this.series][i].id);
        }
        return usedFiles.toArray(new String[usedFiles.size()]);
    }

    @Override
    public int fileGroupOption(String id) {
        try {
            boolean single = this.isSingleFile(id);
            return single ? 1 : 0;
        }
        catch (FormatException e) {
            LOGGER.debug("", e);
        }
        catch (IOException e) {
            LOGGER.debug("", e);
        }
        return 1;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.info != null) {
            OMETiffPlane[][] arr$ = this.info;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                OMETiffPlane[] dimension;
                for (OMETiffPlane plane : dimension = arr$[i$]) {
                    if (plane.reader == null) continue;
                    try {
                        plane.reader.close();
                    }
                    catch (Exception e) {
                        LOGGER.error("Plane closure failure!", e);
                    }
                }
            }
        }
        if (!fileOnly) {
            this.info = null;
            this.used = null;
            this.lastPlane = 0;
            this.tileWidth = null;
            this.tileHeight = null;
        }
    }

    @Override
    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.tileWidth[this.getSeries()];
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.tileHeight[this.getSeries()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initFile(String id) throws FormatException, IOException {
        int i;
        OMEXMLMetadata meta;
        String xml;
        IFD firstIFD;
        super.initFile(this.normalizeFilename(null, id));
        id = this.currentId;
        String dir = new File(id).getParent();
        String fileName = new Location(id).getAbsoluteFile().getAbsolutePath();
        if (!new File(fileName).exists()) {
            fileName = this.currentId;
        }
        RandomAccessInputStream ras = new RandomAccessInputStream(fileName);
        try {
            TiffParser tp = new TiffParser(ras);
            firstIFD = tp.getFirstIFD();
            xml = firstIFD.getComment();
        }
        finally {
            ras.close();
        }
        if (this.service == null) {
            this.setupService();
        }
        try {
            meta = this.service.createOMEXMLMetadata(xml);
        }
        catch (ServiceException se) {
            throw new FormatException(se);
        }
        this.hasSPW = meta.getPlateCount() > 0;
        for (int i2 = 0; i2 < meta.getImageCount(); ++i2) {
            int sizeC = (Integer)meta.getPixelsSizeC(i2).getValue();
            this.service.removeChannels(meta, i2, sizeC);
        }
        Hashtable originalMetadata = this.service.getOriginalMetadata(meta);
        if (originalMetadata != null) {
            this.metadata = originalMetadata;
        }
        LOGGER.trace(xml);
        if (meta.getRoot() == null) {
            throw new FormatException("Could not parse OME-XML from TIFF comment");
        }
        String[] acquiredDates = new String[meta.getImageCount()];
        for (int i3 = 0; i3 < acquiredDates.length; ++i3) {
            Timestamp acquisitionDate = meta.getImageAcquisitionDate(i3);
            if (acquisitionDate == null) continue;
            acquiredDates[i3] = (String)acquisitionDate.getValue();
        }
        String currentUUID = meta.getUUID();
        this.service.convertMetadata(meta, this.metadataStore);
        int seriesCount = meta.getImageCount();
        this.core = new CoreMetadata[seriesCount];
        for (int i4 = 0; i4 < seriesCount; ++i4) {
            this.core[i4] = new CoreMetadata();
        }
        this.info = new OMETiffPlane[seriesCount][];
        this.tileWidth = new int[seriesCount];
        this.tileHeight = new int[seriesCount];
        Hashtable<String, String> files = new Hashtable<String, String>();
        boolean needSearch = false;
        for (int i5 = 0; i5 < seriesCount; ++i5) {
            int tiffDataCount = meta.getTiffDataCount(i5);
            for (int td = 0; td < tiffDataCount; ++td) {
                String uuid = null;
                try {
                    uuid = meta.getUUIDValue(i5, td);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                String filename = null;
                if (uuid == null) {
                    uuid = "";
                    filename = id;
                } else {
                    filename = meta.getUUIDFileName(i5, td);
                    if (!new Location(dir, filename).exists()) {
                        filename = null;
                    }
                    if (filename == null) {
                        if (uuid.equals(currentUUID) || currentUUID == null) {
                            filename = id;
                        } else {
                            filename = "";
                            needSearch = true;
                        }
                    } else {
                        filename = this.normalizeFilename(dir, filename);
                    }
                }
                String existing = (String)files.get(uuid);
                if (existing == null) {
                    files.put(uuid, filename);
                    continue;
                }
                if (existing.equals(filename)) continue;
                throw new FormatException("Inconsistent UUID filenames");
            }
        }
        if (needSearch) {
            Enumeration en = files.keys();
            while (en.hasMoreElements()) {
                String uuid = (String)en.nextElement();
                String filename = (String)files.get(uuid);
                if (!filename.equals("")) continue;
                throw new FormatException("Unmatched UUID: " + uuid);
            }
        }
        Enumeration en = files.keys();
        int numUUIDs = files.size();
        HashSet<String> fileSet = new HashSet<String>();
        for (int i6 = 0; i6 < numUUIDs; ++i6) {
            String uuid = (String)en.nextElement();
            String filename = (String)files.get(uuid);
            fileSet.add(filename);
        }
        this.used = new String[fileSet.size()];
        Iterator iter = fileSet.iterator();
        for (int i7 = 0; i7 < this.used.length; ++i7) {
            this.used[i7] = (String)iter.next();
        }
        Hashtable<String, IFormatReader> readers = new Hashtable<String, IFormatReader>();
        boolean adjustedSamples = false;
        for (int i8 = 0; i8 < seriesCount; ++i8) {
            int td;
            int s = i8;
            LOGGER.debug("Image[{}] {", i8);
            LOGGER.debug("  id = {}", (Object)meta.getImageID(i8));
            String order = meta.getPixelsDimensionOrder(i8).toString();
            PrimitiveType samplesPerPixel = null;
            if (meta.getChannelCount(i8) > 0) {
                samplesPerPixel = meta.getChannelSamplesPerPixel(i8, 0);
            }
            int samples = samplesPerPixel == null ? -1 : (Integer)samplesPerPixel.getValue();
            int tiffSamples = firstIFD.getSamplesPerPixel();
            if (adjustedSamples || samples != tiffSamples && (i8 == 0 || samples < 0)) {
                LOGGER.warn("SamplesPerPixel mismatch: OME={}, TIFF={}", samples, (Object)tiffSamples);
                samples = tiffSamples;
                adjustedSamples = true;
            } else {
                adjustedSamples = false;
            }
            if (adjustedSamples && meta.getChannelCount(i8) <= 1) {
                adjustedSamples = false;
            }
            int effSizeC = (Integer)meta.getPixelsSizeC(i8).getValue();
            if (!adjustedSamples) {
                effSizeC /= samples;
            }
            if (effSizeC == 0) {
                effSizeC = 1;
            }
            if (effSizeC * samples != (Integer)meta.getPixelsSizeC(i8).getValue()) {
                effSizeC = (Integer)meta.getPixelsSizeC(i8).getValue();
            }
            int sizeT = (Integer)meta.getPixelsSizeT(i8).getValue();
            int sizeZ = (Integer)meta.getPixelsSizeZ(i8).getValue();
            int num = effSizeC * sizeT * sizeZ;
            OMETiffPlane[] planes = new OMETiffPlane[num];
            for (int no = 0; no < num; ++no) {
                planes[no] = new OMETiffPlane();
            }
            int tiffDataCount = meta.getTiffDataCount(i8);
            Boolean zOneIndexed = null;
            Boolean cOneIndexed = null;
            Boolean tOneIndexed = null;
            for (td = 0; td < tiffDataCount; ++td) {
                int z;
                NonNegativeInteger firstC = meta.getTiffDataFirstC(i8, td);
                NonNegativeInteger firstT = meta.getTiffDataFirstT(i8, td);
                NonNegativeInteger firstZ = meta.getTiffDataFirstZ(i8, td);
                int c = firstC == null ? 0 : (Integer)firstC.getValue();
                int t = firstT == null ? 0 : (Integer)firstT.getValue();
                int n = z = firstZ == null ? 0 : (Integer)firstZ.getValue();
                if (c >= effSizeC && cOneIndexed == null) {
                    cOneIndexed = true;
                } else if (c == 0) {
                    cOneIndexed = false;
                }
                if (z >= sizeZ && zOneIndexed == null) {
                    zOneIndexed = true;
                } else if (z == 0) {
                    zOneIndexed = false;
                }
                if (t >= sizeT && tOneIndexed == null) {
                    tOneIndexed = true;
                    continue;
                }
                if (t != 0) continue;
                tOneIndexed = false;
            }
            for (td = 0; td < tiffDataCount; ++td) {
                int no;
                Location file2;
                int count;
                int z;
                LOGGER.debug("    TiffData[{}] {", td);
                String filename = null;
                String uuid = null;
                try {
                    filename = meta.getUUIDFileName(i8, td);
                }
                catch (NullPointerException e) {
                    LOGGER.debug("Ignoring null UUID object when retrieving filename.");
                }
                try {
                    uuid = meta.getUUIDValue(i8, td);
                }
                catch (NullPointerException e) {
                    LOGGER.debug("Ignoring null UUID object when retrieving value.");
                }
                NonNegativeInteger tdIFD = meta.getTiffDataIFD(i8, td);
                int ifd = tdIFD == null ? 0 : (Integer)tdIFD.getValue();
                NonNegativeInteger numPlanes = meta.getTiffDataPlaneCount(i8, td);
                NonNegativeInteger firstC = meta.getTiffDataFirstC(i8, td);
                NonNegativeInteger firstT = meta.getTiffDataFirstT(i8, td);
                NonNegativeInteger firstZ = meta.getTiffDataFirstZ(i8, td);
                int c = firstC == null ? 0 : (Integer)firstC.getValue();
                int t = firstT == null ? 0 : (Integer)firstT.getValue();
                int n = z = firstZ == null ? 0 : (Integer)firstZ.getValue();
                if (cOneIndexed != null && cOneIndexed.booleanValue()) {
                    --c;
                }
                if (zOneIndexed != null && zOneIndexed.booleanValue()) {
                    --z;
                }
                if (tOneIndexed != null && tOneIndexed.booleanValue()) {
                    --t;
                }
                if (z >= sizeZ || c >= effSizeC || t >= sizeT) {
                    LOGGER.warn("Found invalid TiffData: Z={}, C={}, T={}", new Object[]{z, c, t});
                    break;
                }
                int index = FormatTools.getIndex(order, sizeZ, effSizeC, sizeT, num, z, c, t);
                int n2 = count = numPlanes == null ? 1 : (Integer)numPlanes.getValue();
                if (count == 0) {
                    this.core[s] = null;
                    break;
                }
                filename = filename == null ? (uuid == null ? id : (String)files.get(uuid)) : this.normalizeFilename(dir, filename);
                IFormatReader r = (IFormatReader)readers.get(filename);
                if (r == null) {
                    r = new MinimalTiffReader();
                    readers.put(filename, r);
                }
                if (!(file2 = new Location(filename)).exists()) {
                    filename = filename.substring(filename.lastIndexOf(File.separator) + 1);
                    filename = dir + File.separator + filename;
                    if (!new Location(filename).exists()) {
                        filename = this.currentId;
                    }
                }
                for (int q = 0; q < count; ++q) {
                    int no2 = index + q;
                    planes[no2].reader = r;
                    planes[no2].id = filename;
                    planes[no2].ifd = ifd + q;
                    planes[no2].certain = true;
                    LOGGER.debug("      Plane[{}]: file={}, IFD={}", new Object[]{no2, planes[no2].id, planes[no2].ifd});
                }
                if (numPlanes == null) {
                    for (no = index + 1; no < num && !planes[no].certain; ++no) {
                        planes[no].reader = r;
                        planes[no].id = filename;
                        planes[no].ifd = planes[no - 1].ifd + 1;
                        LOGGER.debug("      Plane[{}]: FILLED", no);
                    }
                } else {
                    for (no = index + count; no < num && !planes[no].certain; ++no) {
                        planes[no].reader = null;
                        planes[no].id = null;
                        planes[no].ifd = -1;
                        LOGGER.debug("      Plane[{}]: CLEARED", no);
                    }
                }
                LOGGER.debug("    }");
            }
            if (this.core[s] == null) continue;
            LOGGER.debug("    --------------------------------");
            for (int no = 0; no < num; ++no) {
                LOGGER.debug("    Plane[{}]: file={}, IFD={}", new Object[]{no, planes[no].id, planes[no].ifd});
                if (planes[no].reader != null) continue;
                LOGGER.warn("Image ID '{}': missing plane #{}.  Using TiffReader to determine the number of planes.", (Object)meta.getImageID(i8), (Object)no);
                TiffReader r = new TiffReader();
                r.setId(this.currentId);
                try {
                    planes = new OMETiffPlane[r.getImageCount()];
                    for (int plane = 0; plane < planes.length; ++plane) {
                        planes[plane] = new OMETiffPlane();
                        planes[plane].id = this.currentId;
                        planes[plane].reader = r;
                        planes[plane].ifd = plane;
                    }
                    num = planes.length;
                    continue;
                }
                finally {
                    r.close();
                }
            }
            LOGGER.debug("  }");
            this.info[s] = planes;
            try {
                if (!this.info[s][0].reader.isThisType(this.info[s][0].id)) {
                    this.info[s][0].id = this.currentId;
                }
                for (int plane = 0; plane < this.info[s].length; ++plane) {
                    if (this.info[s][plane].reader.isThisType(this.info[s][plane].id)) continue;
                    this.info[s][plane].id = this.info[s][0].id;
                }
                this.info[s][0].reader.setId(this.info[s][0].id);
                this.tileWidth[s] = this.info[s][0].reader.getOptimalTileWidth();
                this.tileHeight[s] = this.info[s][0].reader.getOptimalTileHeight();
                this.core[s].sizeX = (Integer)meta.getPixelsSizeX(i8).getValue();
                int tiffWidth = (int)firstIFD.getImageWidth();
                if (this.core[s].sizeX != tiffWidth && s == 0) {
                    LOGGER.warn("SizeX mismatch: OME={}, TIFF={}", this.core[s].sizeX, (Object)tiffWidth);
                }
                this.core[s].sizeY = (Integer)meta.getPixelsSizeY(i8).getValue();
                int tiffHeight = (int)firstIFD.getImageLength();
                if (this.core[s].sizeY != tiffHeight && s == 0) {
                    LOGGER.warn("SizeY mismatch: OME={}, TIFF={}", this.core[s].sizeY, (Object)tiffHeight);
                }
                this.core[s].sizeZ = (Integer)meta.getPixelsSizeZ(i8).getValue();
                this.core[s].sizeC = (Integer)meta.getPixelsSizeC(i8).getValue();
                this.core[s].sizeT = (Integer)meta.getPixelsSizeT(i8).getValue();
                this.core[s].pixelType = FormatTools.pixelTypeFromString(meta.getPixelsType(i8).toString());
                int tiffPixelType = firstIFD.getPixelType();
                if (this.core[s].pixelType != tiffPixelType && (s == 0 || adjustedSamples)) {
                    LOGGER.warn("PixelType mismatch: OME={}, TIFF={}", this.core[s].pixelType, (Object)tiffPixelType);
                    this.core[s].pixelType = tiffPixelType;
                }
                this.core[s].imageCount = num;
                this.core[s].dimensionOrder = meta.getPixelsDimensionOrder(i8).toString();
                String uuidFileName = "";
                try {
                    if (meta.getTiffDataCount(i8) > 0) {
                        uuidFileName = meta.getUUIDFileName(i8, 0);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                if (meta.getChannelCount(i8) > 0 && meta.getChannelName(i8, 0) == null && meta.getTiffDataCount(i8) > 0 && uuidFileName.indexOf("__omero_export") != -1) {
                    this.core[s].dimensionOrder = "XYZCT";
                }
                this.core[s].orderCertain = true;
                PhotoInterp photo = firstIFD.getPhotometricInterpretation();
                boolean bl = this.core[s].rgb = samples > 1 || photo == PhotoInterp.RGB;
                if (samples != this.core[s].sizeC && samples % this.core[s].sizeC != 0 && this.core[s].sizeC % samples != 0 || this.core[s].sizeC == 1 || adjustedSamples) {
                    this.core[s].sizeC *= samples;
                }
                if (this.core[s].sizeZ * this.core[s].sizeT * this.core[s].sizeC > this.core[s].imageCount && !this.core[s].rgb) {
                    if (this.core[s].sizeZ == this.core[s].imageCount) {
                        this.core[s].sizeT = 1;
                        this.core[s].sizeC = 1;
                    } else if (this.core[s].sizeT == this.core[s].imageCount) {
                        this.core[s].sizeZ = 1;
                        this.core[s].sizeC = 1;
                    } else if (this.core[s].sizeC == this.core[s].imageCount) {
                        this.core[s].sizeT = 1;
                        this.core[s].sizeZ = 1;
                    }
                }
                if (meta.getPixelsBinDataCount(i8) > 1) {
                    LOGGER.warn("OME-TIFF Pixels element contains BinData elements! Ignoring.");
                }
                this.core[s].littleEndian = firstIFD.isLittleEndian();
                this.core[s].interleaved = false;
                boolean bl2 = this.core[s].indexed = photo == PhotoInterp.RGB_PALETTE && firstIFD.getIFDValue(320) != null;
                if (this.core[s].indexed) {
                    this.core[s].rgb = false;
                }
                this.core[s].falseColor = true;
                this.core[s].metadataComplete = true;
                continue;
            }
            catch (NullPointerException exc) {
                throw new FormatException("Incomplete Pixels metadata", exc);
            }
        }
        Vector<CoreMetadata> series = new Vector<CoreMetadata>();
        Vector<OMETiffPlane[]> planeInfo = new Vector<OMETiffPlane[]>();
        for (i = 0; i < this.core.length; ++i) {
            if (this.core[i] == null) continue;
            series.add(this.core[i]);
            planeInfo.add(this.info[i]);
        }
        this.core = series.toArray(new CoreMetadata[series.size()]);
        this.info = (OMETiffPlane[][])planeInfo.toArray((T[])new OMETiffPlane[0][0]);
        if (this.getImageCount() == 1) {
            this.core[0].sizeZ = 1;
            if (!this.core[0].rgb) {
                this.core[0].sizeC = 1;
            }
            this.core[0].sizeT = 1;
        }
        MetadataTools.populatePixels(this.metadataStore, this, false, false);
        for (i = 0; i < acquiredDates.length; ++i) {
            if (acquiredDates[i] == null) continue;
            this.metadataStore.setImageAcquisitionDate(new Timestamp(acquiredDates[i]), i);
        }
        this.metadataStore = this.getMetadataStoreForConversion();
    }

    public MetadataStore getMetadataStoreForDisplay() {
        MetadataStore store = this.getMetadataStore();
        if (this.service.isOMEXMLMetadata(store)) {
            this.service.removeBinData((OMEXMLMetadata)store);
            for (int i = 0; i < this.getSeriesCount(); ++i) {
                if (((OMEXMLMetadata)store).getTiffDataCount(i) != 0) continue;
                this.service.addMetadataOnly((OMEXMLMetadata)store, i);
            }
        }
        return store;
    }

    public MetadataStore getMetadataStoreForConversion() {
        MetadataStore store = this.getMetadataStore();
        int realSeries = this.getSeries();
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            this.setSeries(i);
            store.setPixelsBinDataBigEndian(new Boolean(!this.isLittleEndian()), i, 0);
        }
        this.setSeries(realSeries);
        return store;
    }

    private String normalizeFilename(String dir, String name) {
        File file2 = new File(dir, name);
        if (file2.exists()) {
            return file2.getAbsolutePath();
        }
        return name;
    }

    private void setupService() throws FormatException {
        try {
            ServiceFactory factory = new ServiceFactory();
            this.service = factory.getInstance(OMEXMLService.class);
        }
        catch (DependencyException de) {
            throw new MissingLibraryException("ome-xml.jar is required to read OME-TIFF files.  Please download it from http://www.openmicroscopy.org/site/support/bio-formats/developers/java-library.html", de);
        }
    }

    private class OMETiffPlane {
        public IFormatReader reader;
        public String id;
        public int ifd = -1;
        public boolean certain = false;

        private OMETiffPlane() {
        }
    }
}

