/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;

public class SIFReader
extends FormatReader {
    private static final String MAGIC_STRING = "Andor Technology";
    private long pixelOffset;

    public SIFReader() {
        super("Andor SIF", "sif");
        this.domains = new String[]{"Light Microscopy"};
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 16;
        if (!FormatTools.validStream(stream, 16, false)) {
            return false;
        }
        return stream.readString(16).equals(MAGIC_STRING);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek(this.pixelOffset + (long)(no * FormatTools.getPlaneSize(this)));
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelOffset = 0L;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        double[] timestamp = null;
        int lineNumber = 1;
        String line = this.in.readLine();
        int endLine = -1;
        while (endLine < 0 || lineNumber < endLine) {
            ++lineNumber;
            if (line.startsWith("Pixel number")) {
                String[] tokens = line.split(" ");
                if (tokens.length > 2) {
                    this.core[0].sizeC = Integer.parseInt(tokens[2]);
                    this.core[0].sizeX = Integer.parseInt(tokens[3]);
                    this.core[0].sizeY = Integer.parseInt(tokens[4]);
                    this.core[0].sizeZ = Integer.parseInt(tokens[5]);
                    this.core[0].sizeT = Integer.parseInt(tokens[6]);
                    this.core[0].imageCount = this.getSizeZ() * this.getSizeT() * this.getSizeC();
                    timestamp = new double[this.getImageCount()];
                    endLine = lineNumber + this.getImageCount();
                }
            } else if (lineNumber < endLine) {
                int index = lineNumber - (endLine - this.getImageCount()) - 1;
                if (index >= 0) {
                    try {
                        timestamp[index] = Double.parseDouble(line.trim());
                    }
                    catch (NumberFormatException e) {
                        LOGGER.debug("Could not parse timestamp #" + index, e);
                    }
                }
            } else {
                this.addGlobalMeta("Line #" + (lineNumber - 1), line.trim());
            }
            line = this.in.readLine();
        }
        this.pixelOffset = this.in.getFilePointer();
        this.core[0].pixelType = 6;
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].littleEndian = true;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            for (int i = 0; i < this.getImageCount(); ++i) {
                store.setPlaneDeltaT((double)timestamp[i], 0, i);
            }
        }
    }
}

