/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.ClassList;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.MetadataTools;
import loci.formats.MissingLibraryException;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.ome.OMEXMLMetadataImpl;
import loci.formats.services.OMEXMLService;
import ome.xml.model.Image;
import ome.xml.model.OME;
import ome.xml.model.enums.NamingConvention;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveInteger;

public class ScreenReader
extends FormatReader {
    private String[] plateMetadataFiles;
    private ImageReader[] readers;
    private boolean[][] plateMaps;
    private ClassList<IFormatReader> validReaders;

    public ScreenReader() {
        super("Screen", "");
        this.suffixSufficient = false;
        this.domains = new String[]{"High-Content Screening (HCS)"};
        ClassList<IFormatReader> classes = ImageReader.getDefaultReaderClasses();
        Class<IFormatReader>[] classArray = classes.getClasses();
        this.validReaders = new ClassList<IFormatReader>(IFormatReader.class);
        for (Class<IFormatReader> c : classArray) {
            if (c.equals(ScreenReader.class)) continue;
            this.validReaders.addClass(c);
        }
        this.hasCompanionFiles = true;
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    @Override
    public boolean isThisType(String filename, boolean open) {
        if (!open) {
            return super.isThisType(filename, open);
        }
        Location file2 = new Location(filename).getAbsoluteFile();
        String parent = file2.getParent();
        boolean validNames = this.isValidWellName(file2.getAbsolutePath()) && this.isValidPlateName(parent);
        ImageReader r = new ImageReader(this.validReaders);
        boolean validFormat = r.isThisType(filename);
        boolean singleFiles = false;
        try {
            singleFiles = r.isSingleFile(filename);
        }
        catch (FormatException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return validNames && validFormat && singleFiles;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return false;
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.readers == null || this.readers[0].getCurrentFile() == null) {
            return null;
        }
        return this.readers[0].get8BitLookupTable();
    }

    @Override
    public short[][] get16BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.readers == null || this.readers[0].getCurrentFile() == null) {
            return null;
        }
        return this.readers[0].get16BitLookupTable();
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int[] spwIndexes = this.getSPWIndexes(this.getSeries());
        int well = spwIndexes[0];
        int field = spwIndexes[1];
        this.readers[well].setSeries(field);
        return this.readers[well].openBytes(no, buf, x, y, w, h);
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        String[] readerFiles;
        FormatTools.assertId(this.currentId, true, 1);
        int[] spwIndexes = this.getSPWIndexes(this.getSeries());
        int well = spwIndexes[0];
        Vector<String> files = new Vector<String>();
        if (this.plateMetadataFiles != null) {
            for (String f : this.plateMetadataFiles) {
                files.add(f);
            }
        }
        if ((readerFiles = this.readers[well].getSeriesUsedFiles(noPixels)) != null) {
            for (String f : readerFiles) {
                files.add(f);
            }
        }
        return files.toArray(new String[files.size()]);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.readers != null) {
            for (ImageReader well : this.readers) {
                well.close(fileOnly);
            }
        }
        if (!fileOnly) {
            this.readers = null;
            this.plateMaps = null;
            this.plateMetadataFiles = null;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        OMEXMLMetadata omexmlMeta;
        OMEXMLService service;
        super.initFile(id);
        Location file2 = new Location(id).getAbsoluteFile();
        Location plate = null;
        Location screen = null;
        if (!this.isValidWellName(file2.getAbsolutePath())) {
            throw new FormatException(id + " is not a valid well name.");
        }
        plate = file2.getParentFile();
        screen = plate.getParentFile();
        Vector<String> metadataFiles = new Vector<String>();
        Comparator<String> c = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                int row2;
                int row1 = ScreenReader.this.getRow(s1).charAt(0) - 65;
                if (row1 != (row2 = ScreenReader.this.getRow(s2).charAt(0) - 65)) {
                    return row1 - row2;
                }
                int col1 = Integer.parseInt(ScreenReader.this.getColumn(s1)) - 1;
                int col2 = Integer.parseInt(ScreenReader.this.getColumn(s2)) - 1;
                return col1 - col2;
            }
        };
        Vector<String> tmpWells = new Vector<String>();
        String[] plateList = plate.list(true);
        int maxRow = 0;
        int maxCol = 0;
        for (String well : plateList) {
            Location wellFile = new Location(plate, well);
            if (this.isValidWellName(wellFile.getAbsolutePath())) {
                String row = this.getRow(well);
                String col = this.getColumn(well);
                boolean canAdd = true;
                for (String tmpWell : tmpWells) {
                    String tmpRow = this.getRow(tmpWell);
                    String tmpCol = this.getColumn(tmpWell);
                    if (!tmpRow.equals(row) || !tmpCol.equals(col)) continue;
                    canAdd = false;
                    break;
                }
                if (!canAdd) continue;
                tmpWells.add(wellFile.getAbsolutePath());
                if (row.charAt(0) - 65 > maxRow) {
                    maxRow = row.charAt(0) - 65;
                }
                if (Integer.parseInt(col) - 1 <= maxCol) continue;
                maxCol = Integer.parseInt(col) - 1;
                continue;
            }
            if (wellFile.isDirectory()) continue;
            metadataFiles.add(wellFile.getAbsolutePath());
        }
        String[] files = tmpWells.toArray(new String[tmpWells.size()]);
        Arrays.sort(files, c);
        this.readers = new ImageReader[files.length];
        int coreLength = files.length;
        this.plateMaps = new boolean[maxRow + 1][maxCol + 1];
        this.plateMetadataFiles = metadataFiles.toArray(new String[metadataFiles.size()]);
        tmpWells.clear();
        metadataFiles.clear();
        try {
            ServiceFactory factory = new ServiceFactory();
            service = factory.getInstance(OMEXMLService.class);
            omexmlMeta = service.createOMEXMLMetadata();
        }
        catch (DependencyException de) {
            throw new MissingLibraryException("ome-xml.jar is required to read OME-TIFF files.  Please download it from http://www.openmicroscopy.org/site/support/bio-formats/developers/java-library.html", de);
        }
        catch (ServiceException se) {
            throw new FormatException(se);
        }
        Vector<CoreMetadata> coreMetadata = new Vector<CoreMetadata>();
        int lastCount = 0;
        int[] seriesCounts = new int[files.length];
        for (int well = 0; well < files.length; ++well) {
            this.readers[well] = new ImageReader(this.validReaders);
            this.readers[well].setMetadataStore(omexmlMeta);
            this.readers[well].setId(files[well]);
            CoreMetadata[] core = this.readers[well].getCoreMetadata();
            for (int field = 0; field < core.length; ++field) {
                coreMetadata.add(core[field]);
            }
            seriesCounts[well] = this.readers[well].getSeriesCount();
            lastCount = seriesCounts[well];
            String row = this.getRow(files[well]);
            String col = this.getColumn(files[well]);
            int rowIndex = row.charAt(0) - 65;
            int colIndex = Integer.parseInt(col) - 1;
            this.plateMaps[rowIndex][colIndex] = true;
        }
        this.core = coreMetadata.toArray(new CoreMetadata[coreMetadata.size()]);
        OME root = (OME)omexmlMeta.getRoot();
        Image img = root.getImage(0);
        for (int i = lastCount; i < this.core.length; ++i) {
            root.addImage(img);
        }
        ((OMEXMLMetadataImpl)omexmlMeta).resolveReferences();
        omexmlMeta.setRoot(root);
        MetadataStore store = this.makeFilterMetadata();
        service.convertMetadata(omexmlMeta, store);
        MetadataTools.populatePixels(store, this);
        String screenID = MetadataTools.createLSID("Screen", 0);
        store.setScreenID(screenID, 0);
        store.setScreenName(screen.getName(), 0);
        String plateID = MetadataTools.createLSID("Plate", 0);
        store.setPlateID(plateID, 0);
        store.setScreenPlateRef(plateID, 0, 0);
        store.setPlateName(plate.getName(), 0);
        store.setPlateRows(new PositiveInteger(this.plateMaps.length), 0);
        store.setPlateColumns(new PositiveInteger(this.plateMaps[0].length), 0);
        store.setPlateRowNamingConvention(NamingConvention.LETTER, 0);
        store.setPlateColumnNamingConvention(NamingConvention.NUMBER, 0);
        int realWell = 0;
        for (int row = 0; row < this.plateMaps.length; ++row) {
            for (int col = 0; col < this.plateMaps[row].length; ++col) {
                int well = row * this.plateMaps[row].length + col;
                String wellID = MetadataTools.createLSID("Well", 0, well);
                store.setWellID(wellID, 0, well);
                store.setWellColumn(new NonNegativeInteger(col), 0, well);
                store.setWellRow(new NonNegativeInteger(row), 0, well);
                if (!this.plateMaps[row][col]) continue;
                for (int field = 0; field < seriesCounts[realWell]; ++field) {
                    int seriesIndex = this.getSeriesIndex(realWell, field);
                    String imageID = MetadataTools.createLSID("Image", seriesIndex);
                    store.setImageID(imageID, seriesIndex);
                    store.setImageName("Well " + (char)(row + 65) + (col + 1) + ", Field " + (field + 1), seriesIndex);
                    String wellSampleID = MetadataTools.createLSID("WellSample", 0, well, field);
                    store.setWellSampleID(wellSampleID, 0, well, field);
                    store.setWellSampleImageRef(imageID, 0, well, field);
                    store.setWellSampleIndex(new NonNegativeInteger(seriesIndex), 0, well, field);
                }
                ++realWell;
            }
        }
    }

    private boolean isValidWellName(String filename) {
        if (new Location(filename).getAbsoluteFile().isDirectory()) {
            return false;
        }
        String row = this.getRow(filename);
        String col = this.getColumn(filename);
        try {
            Integer.parseInt(col);
            return col.length() <= 2 && Character.isLetter(row.charAt(0));
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isValidPlateName(String filename) {
        return new Location(filename).isDirectory();
    }

    private int getSeriesIndex(int well, int field) {
        int fieldCount = this.readers[well].getSeriesCount();
        int seriesIndex = 0;
        int validWells = -1;
        for (int row = 0; row < this.plateMaps.length; ++row) {
            for (int col = 0; col < this.plateMaps[row].length; ++col) {
                if (!this.plateMaps[row][col]) continue;
                if (++validWells == well) {
                    return seriesIndex + field;
                }
                seriesIndex += this.readers[validWells].getSeriesCount();
            }
        }
        return -1;
    }

    private int[] getSPWIndexes(int seriesIndex) {
        int s = 0;
        int wellIndex = 0;
        for (int row = 0; row < this.plateMaps.length; ++row) {
            for (int col = 0; col < this.plateMaps[row].length; ++col) {
                if (!this.plateMaps[row][col]) continue;
                for (int i = 0; i < this.readers[wellIndex].getSeriesCount(); ++i) {
                    if (++s != seriesIndex + 1) continue;
                    return new int[]{wellIndex, i};
                }
                ++wellIndex;
            }
        }
        return new int[]{-1, -1};
    }

    private int[] getRowAndColumn(int well) {
        int validWells = 0;
        for (int row = 0; row < this.plateMaps.length; ++row) {
            for (int col = 0; col < this.plateMaps[row].length; ++col) {
                if (!this.plateMaps[row][col] || ++validWells != well + 1) continue;
                return new int[]{row, col};
            }
        }
        return new int[]{-1, -1};
    }

    private boolean hasValidWells(Location plate) {
        String[] wells;
        if (!plate.isDirectory()) {
            return false;
        }
        for (String well : wells = plate.list(true)) {
            if (!this.isValidWellName(new Location(plate, well).getAbsolutePath())) continue;
            return true;
        }
        return false;
    }

    private String getRow(String well) {
        String wellName = well.substring(well.lastIndexOf(File.separator) + 1);
        char firstChar = Character.toUpperCase(wellName.charAt(0));
        while (wellName.indexOf("_") > 0 && (firstChar < 'A' || firstChar > 'P')) {
            wellName = wellName.substring(wellName.indexOf("_") + 1);
            firstChar = Character.toUpperCase(wellName.charAt(0));
        }
        return wellName.substring(0, 1).toUpperCase();
    }

    private String getColumn(String well) {
        String wellName = well.substring(well.lastIndexOf(File.separator) + 1);
        char firstChar = Character.toUpperCase(wellName.charAt(0));
        while (wellName.indexOf("_") > 0 && (firstChar < 'A' || firstChar > 'P')) {
            wellName = wellName.substring(wellName.indexOf("_") + 1);
            firstChar = Character.toUpperCase(wellName.charAt(0));
        }
        int end = wellName.lastIndexOf("_");
        if (end < 0) {
            end = wellName.lastIndexOf(".");
        }
        if (end < 0) {
            end = wellName.length();
        }
        if (end <= 1) {
            return null;
        }
        return wellName.substring(1, end);
    }
}

