/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.codec.JPEGTileDecoder;
import loci.formats.meta.MetadataStore;

public class TileJPEGReader
extends FormatReader {
    private JPEGTileDecoder decoder;

    public TileJPEGReader() {
        super("Tile JPEG", new String[]{"jpg", "jpeg"});
        this.domains = new String[]{"Graphics"};
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int c = this.getRGBChannelCount();
        for (int ty = y; ty < y + h; ++ty) {
            byte[] scanline = this.decoder.getScanline(ty);
            if (scanline == null) {
                this.decoder.initialize(this.currentId, 0);
                scanline = this.decoder.getScanline(ty);
            }
            System.arraycopy(scanline, c * x, buf, (ty - y) * c * w, c * w);
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.decoder != null) {
                this.decoder.close();
            }
            this.decoder = null;
        }
    }

    @Override
    public void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.decoder = new JPEGTileDecoder();
        this.decoder.initialize(this.in, 0, 1, 0);
        this.core[0].interleaved = true;
        this.core[0].littleEndian = false;
        this.core[0].sizeX = this.decoder.getWidth();
        this.core[0].sizeY = this.decoder.getHeight();
        this.core[0].sizeZ = 1;
        this.core[0].sizeT = 1;
        this.core[0].sizeC = this.decoder.getScanline(0).length / this.getSizeX();
        this.core[0].rgb = this.getSizeC() > 1;
        this.core[0].imageCount = 1;
        this.core[0].pixelType = 1;
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].metadataComplete = true;
        this.core[0].indexed = false;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }
}

