/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.meta;

import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import ome.xml.model.AffineTransform;
import ome.xml.model.enums.AcquisitionMode;
import ome.xml.model.enums.ArcType;
import ome.xml.model.enums.Binning;
import ome.xml.model.enums.ContrastMethod;
import ome.xml.model.enums.Correction;
import ome.xml.model.enums.DetectorType;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.ExperimentType;
import ome.xml.model.enums.FilamentType;
import ome.xml.model.enums.FillRule;
import ome.xml.model.enums.FilterType;
import ome.xml.model.enums.FontFamily;
import ome.xml.model.enums.FontStyle;
import ome.xml.model.enums.IlluminationType;
import ome.xml.model.enums.Immersion;
import ome.xml.model.enums.LaserMedium;
import ome.xml.model.enums.LaserType;
import ome.xml.model.enums.LineCap;
import ome.xml.model.enums.Marker;
import ome.xml.model.enums.Medium;
import ome.xml.model.enums.MicrobeamManipulationType;
import ome.xml.model.enums.MicroscopeType;
import ome.xml.model.enums.NamingConvention;
import ome.xml.model.enums.PixelType;
import ome.xml.model.enums.Pulse;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.NonNegativeLong;
import ome.xml.model.primitives.PercentFraction;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;

public final class MetadataConverter {
    private MetadataConverter() {
    }

    public static void convertMetadata(MetadataRetrieve src, MetadataStore dest) {
        MetadataConverter.convertBooleanAnnotations(src, dest);
        MetadataConverter.convertCommentAnnotations(src, dest);
        MetadataConverter.convertDoubleAnnotations(src, dest);
        MetadataConverter.convertFileAnnotations(src, dest);
        MetadataConverter.convertListAnnotations(src, dest);
        MetadataConverter.convertLongAnnotations(src, dest);
        MetadataConverter.convertTagAnnotations(src, dest);
        MetadataConverter.convertTermAnnotations(src, dest);
        MetadataConverter.convertTimestampAnnotations(src, dest);
        MetadataConverter.convertXMLAnnotations(src, dest);
        MetadataConverter.convertROIs(src, dest);
        MetadataConverter.convertInstruments(src, dest);
        MetadataConverter.convertExperimenters(src, dest);
        MetadataConverter.convertExperimenterGroups(src, dest);
        MetadataConverter.convertExperiments(src, dest);
        MetadataConverter.convertImages(src, dest);
        MetadataConverter.convertPlates(src, dest);
        MetadataConverter.convertScreens(src, dest);
        MetadataConverter.convertDatasets(src, dest);
        MetadataConverter.convertProjects(src, dest);
    }

    private static void convertBooleanAnnotations(MetadataRetrieve src, MetadataStore dest) {
        int booleanAnnotationCount = 0;
        try {
            booleanAnnotationCount = src.getBooleanAnnotationCount();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        for (int i = 0; i < booleanAnnotationCount; ++i) {
            try {
                String id = src.getBooleanAnnotationID(i);
                dest.setBooleanAnnotationID(id, i);
            }
            catch (NullPointerException e) {
                continue;
            }
            try {
                String description = src.getBooleanAnnotationDescription(i);
                dest.setBooleanAnnotationDescription(description, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String namespace = src.getBooleanAnnotationNamespace(i);
                dest.setBooleanAnnotationNamespace(namespace, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                Boolean value = src.getBooleanAnnotationValue(i);
                dest.setBooleanAnnotationValue(value, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            int annotationRefCount = 0;
            try {
                annotationRefCount = src.getBooleanAnnotationAnnotationCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int a = 0; a < annotationRefCount; ++a) {
                try {
                    String id = src.getBooleanAnnotationAnnotationRef(i, a);
                    dest.setBooleanAnnotationAnnotationRef(id, i, a);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
    }

    private static void convertCommentAnnotations(MetadataRetrieve src, MetadataStore dest) {
        int commentAnnotationCount = 0;
        try {
            commentAnnotationCount = src.getCommentAnnotationCount();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        for (int i = 0; i < commentAnnotationCount; ++i) {
            try {
                String id = src.getCommentAnnotationID(i);
                dest.setCommentAnnotationID(id, i);
            }
            catch (NullPointerException e) {
                continue;
            }
            try {
                String description = src.getCommentAnnotationDescription(i);
                dest.setCommentAnnotationDescription(description, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String namespace = src.getCommentAnnotationNamespace(i);
                dest.setCommentAnnotationNamespace(namespace, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String value = src.getCommentAnnotationValue(i);
                dest.setCommentAnnotationValue(value, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            int annotationRefCount = 0;
            try {
                annotationRefCount = src.getCommentAnnotationAnnotationCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int a = 0; a < annotationRefCount; ++a) {
                try {
                    String id = src.getCommentAnnotationAnnotationRef(i, a);
                    dest.setCommentAnnotationAnnotationRef(id, i, a);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
    }

    private static void convertDatasets(MetadataRetrieve src, MetadataStore dest) {
        int datasets = 0;
        try {
            datasets = src.getDatasetCount();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        for (int i = 0; i < datasets; ++i) {
            int q;
            try {
                String id = src.getDatasetID(i);
                dest.setDatasetID(id, i);
            }
            catch (NullPointerException e) {
                continue;
            }
            try {
                String description = src.getDatasetDescription(i);
                dest.setDatasetDescription(description, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String experimenterGroupRef = src.getDatasetExperimenterGroupRef(i);
                dest.setDatasetExperimenterGroupRef(experimenterGroupRef, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String experimenterRef = src.getDatasetExperimenterRef(i);
                dest.setDatasetExperimenterRef(experimenterRef, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String name = src.getDatasetName(i);
                dest.setDatasetName(name, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                int imageRefCount = src.getDatasetImageRefCount(i);
                for (q = 0; q < imageRefCount; ++q) {
                    try {
                        String imageRef = src.getDatasetImageRef(i, q);
                        dest.setDatasetImageRef(imageRef, i, q);
                        continue;
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                }
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                int annotationRefCount = src.getDatasetAnnotationRefCount(i);
                for (q = 0; q < annotationRefCount; ++q) {
                    try {
                        String annotationRef = src.getDatasetAnnotationRef(i, q);
                        dest.setDatasetAnnotationRef(annotationRef, i, q);
                        continue;
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                }
                continue;
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
    }

    private static void convertDoubleAnnotations(MetadataRetrieve src, MetadataStore dest) {
        int doubleAnnotationCount = 0;
        try {
            doubleAnnotationCount = src.getDoubleAnnotationCount();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        for (int i = 0; i < doubleAnnotationCount; ++i) {
            try {
                String id = src.getDoubleAnnotationID(i);
                dest.setDoubleAnnotationID(id, i);
            }
            catch (NullPointerException e) {
                continue;
            }
            try {
                String description = src.getDoubleAnnotationDescription(i);
                dest.setDoubleAnnotationDescription(description, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String namespace = src.getDoubleAnnotationNamespace(i);
                dest.setDoubleAnnotationNamespace(namespace, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                Double value = src.getDoubleAnnotationValue(i);
                dest.setDoubleAnnotationValue(value, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            int annotationRefCount = 0;
            try {
                annotationRefCount = src.getDoubleAnnotationAnnotationCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int a = 0; a < annotationRefCount; ++a) {
                try {
                    String id = src.getDoubleAnnotationAnnotationRef(i, a);
                    dest.setDoubleAnnotationAnnotationRef(id, i, a);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
    }

    private static void convertExperiments(MetadataRetrieve src, MetadataStore dest) {
        int experimentCount = 0;
        try {
            experimentCount = src.getExperimentCount();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        for (int i = 0; i < experimentCount; ++i) {
            try {
                String id = src.getExperimentID(i);
                dest.setExperimentID(id, i);
            }
            catch (NullPointerException e) {
                continue;
            }
            try {
                String description = src.getExperimentDescription(i);
                dest.setExperimentDescription(description, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String experimenterRef = src.getExperimentExperimenterRef(i);
                dest.setExperimentExperimenterRef(experimenterRef, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                ExperimentType type = src.getExperimentType(i);
                dest.setExperimentType(type, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            int microbeamCount = 0;
            try {
                microbeamCount = src.getMicrobeamManipulationCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int q = 0; q < microbeamCount; ++q) {
                try {
                    String microbeamID = src.getMicrobeamManipulationID(i, q);
                    dest.setMicrobeamManipulationID(microbeamID, i, q);
                }
                catch (NullPointerException e) {
                    continue;
                }
                try {
                    String microbeamDescription = src.getMicrobeamManipulationDescription(i, q);
                    dest.setMicrobeamManipulationDescription(microbeamDescription, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String microbeamExperimenterRef = src.getMicrobeamManipulationExperimenterRef(i, q);
                    dest.setMicrobeamManipulationExperimenterRef(microbeamExperimenterRef, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    MicrobeamManipulationType microbeamType = src.getMicrobeamManipulationType(i, q);
                    dest.setMicrobeamManipulationType(microbeamType, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                int lightSourceCount = 0;
                try {
                    lightSourceCount = src.getMicrobeamManipulationLightSourceSettingsCount(i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                for (int p = 0; p < lightSourceCount; ++p) {
                    String lightSourceID = src.getMicrobeamManipulationLightSourceSettingsID(i, q, p);
                    if (lightSourceID == null) continue;
                    dest.setMicrobeamManipulationLightSourceSettingsID(lightSourceID, i, q, p);
                    try {
                        PercentFraction attenuation = src.getMicrobeamManipulationLightSourceSettingsAttenuation(i, q, p);
                        dest.setMicrobeamManipulationLightSourceSettingsAttenuation(attenuation, i, q, p);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        PositiveInteger wavelength = src.getMicrobeamManipulationLightSourceSettingsWavelength(i, q, p);
                        dest.setMicrobeamManipulationLightSourceSettingsWavelength(wavelength, i, q, p);
                        continue;
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                }
                int roiRefCount = 0;
                try {
                    roiRefCount = src.getMicrobeamManipulationROIRefCount(i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                for (int p = 0; p < roiRefCount; ++p) {
                    try {
                        String roiRef = src.getMicrobeamManipulationROIRef(i, q, p);
                        dest.setMicrobeamManipulationROIRef(roiRef, i, q, p);
                        continue;
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static void convertExperimenters(MetadataRetrieve src, MetadataStore dest) {
        int experimenterCount = 0;
        try {
            experimenterCount = src.getExperimenterCount();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        for (int i = 0; i < experimenterCount; ++i) {
            try {
                String id = src.getExperimenterID(i);
                dest.setExperimenterID(id, i);
            }
            catch (NullPointerException e) {
                continue;
            }
            try {
                String email = src.getExperimenterEmail(i);
                dest.setExperimenterEmail(email, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String firstName = src.getExperimenterFirstName(i);
                dest.setExperimenterFirstName(firstName, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String institution = src.getExperimenterInstitution(i);
                dest.setExperimenterInstitution(institution, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String lastName = src.getExperimenterLastName(i);
                dest.setExperimenterLastName(lastName, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String middleName = src.getExperimenterMiddleName(i);
                dest.setExperimenterMiddleName(middleName, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String userName = src.getExperimenterUserName(i);
                dest.setExperimenterUserName(userName, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            int annotationRefCount = 0;
            try {
                annotationRefCount = src.getExperimenterAnnotationRefCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int q = 0; q < annotationRefCount; ++q) {
                try {
                    String annotationRef = src.getExperimenterAnnotationRef(i, q);
                    dest.setExperimenterAnnotationRef(annotationRef, i, q);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
    }

    private static void convertExperimenterGroups(MetadataRetrieve src, MetadataStore dest) {
        int experimenterGroupCount = 0;
        try {
            experimenterGroupCount = src.getExperimenterGroupCount();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        for (int i = 0; i < experimenterGroupCount; ++i) {
            try {
                String id = src.getExperimenterGroupID(i);
                dest.setExperimenterGroupID(id, i);
            }
            catch (NullPointerException e) {
                continue;
            }
            try {
                String description = src.getExperimenterGroupDescription(i);
                dest.setExperimenterGroupDescription(description, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String name = src.getExperimenterGroupName(i);
                dest.setExperimenterGroupName(name, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            int annotationRefCount = 0;
            try {
                annotationRefCount = src.getExperimenterGroupAnnotationRefCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int q = 0; q < annotationRefCount; ++q) {
                try {
                    String annotationRef = src.getExperimenterGroupAnnotationRef(i, q);
                    dest.setExperimenterGroupAnnotationRef(annotationRef, i, q);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
            int experimenterRefCount = 0;
            try {
                experimenterRefCount = src.getExperimenterGroupExperimenterRefCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int q = 0; q < experimenterRefCount; ++q) {
                try {
                    String experimenterRef = src.getExperimenterGroupExperimenterRef(i, q);
                    dest.setExperimenterGroupExperimenterRef(experimenterRef, i, q);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
            int leaderCount = 0;
            try {
                leaderCount = src.getLeaderCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int q = 0; q < leaderCount; ++q) {
                try {
                    String leader = src.getExperimenterGroupLeader(i, q);
                    dest.setExperimenterGroupLeader(leader, i, q);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
    }

    private static void convertFileAnnotations(MetadataRetrieve src, MetadataStore dest) {
        int fileAnnotationCount = 0;
        try {
            fileAnnotationCount = src.getFileAnnotationCount();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        for (int i = 0; i < fileAnnotationCount; ++i) {
            try {
                String id = src.getFileAnnotationID(i);
                dest.setFileAnnotationID(id, i);
            }
            catch (NullPointerException e) {
                continue;
            }
            try {
                String description = src.getFileAnnotationDescription(i);
                dest.setFileAnnotationDescription(description, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String namespace = src.getFileAnnotationNamespace(i);
                dest.setFileAnnotationNamespace(namespace, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String fileName = src.getBinaryFileFileName(i);
                dest.setBinaryFileFileName(fileName, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String mimeType = src.getBinaryFileMIMEType(i);
                dest.setBinaryFileMIMEType(mimeType, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                NonNegativeLong fileSize = src.getBinaryFileSize(i);
                dest.setBinaryFileSize(fileSize, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            int annotationRefCount = 0;
            try {
                annotationRefCount = src.getFileAnnotationAnnotationCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int a = 0; a < annotationRefCount; ++a) {
                try {
                    String id = src.getFileAnnotationAnnotationRef(i, a);
                    dest.setFileAnnotationAnnotationRef(id, i, a);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
    }

    private static void convertImages(MetadataRetrieve src, MetadataStore dest) {
        int imageCount = 0;
        try {
            imageCount = src.getImageCount();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        for (int i = 0; i < imageCount; ++i) {
            int q;
            int q2;
            int q3;
            int q4;
            block202: {
                block201: {
                    try {
                        String id = src.getImageID(i);
                        dest.setImageID(id, i);
                    }
                    catch (NullPointerException e) {
                        continue;
                    }
                    try {
                        Timestamp date = src.getImageAcquisitionDate(i);
                        dest.setImageAcquisitionDate(date, i);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        String description = src.getImageDescription(i);
                        dest.setImageDescription(description, i);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        String experimentRef = src.getImageExperimentRef(i);
                        dest.setImageExperimentRef(experimentRef, i);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        String experimenterGroupRef = src.getImageExperimenterGroupRef(i);
                        dest.setImageExperimenterGroupRef(experimenterGroupRef, i);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        String experimenterRef = src.getImageExperimenterRef(i);
                        dest.setImageExperimenterRef(experimenterRef, i);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        String instrumentRef = src.getImageInstrumentRef(i);
                        dest.setImageInstrumentRef(instrumentRef, i);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        String name = src.getImageName(i);
                        dest.setImageName(name, i);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        Double airPressure = src.getImagingEnvironmentAirPressure(i);
                        dest.setImagingEnvironmentAirPressure(airPressure, i);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        PercentFraction co2 = src.getImagingEnvironmentCO2Percent(i);
                        dest.setImagingEnvironmentCO2Percent(co2, i);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        PercentFraction humidity = src.getImagingEnvironmentHumidity(i);
                        dest.setImagingEnvironmentHumidity(humidity, i);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        Double temperature = src.getImagingEnvironmentTemperature(i);
                        dest.setImagingEnvironmentTemperature(temperature, i);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        String objectiveID = src.getObjectiveSettingsID(i);
                        if (objectiveID == null) break block201;
                        dest.setObjectiveSettingsID(objectiveID, i);
                        try {
                            Double correction = src.getObjectiveSettingsCorrectionCollar(i);
                            dest.setObjectiveSettingsCorrectionCollar(correction, i);
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            Medium medium = src.getObjectiveSettingsMedium(i);
                            dest.setObjectiveSettingsMedium(medium, i);
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            Double refractiveIndex = src.getObjectiveSettingsRefractiveIndex(i);
                            dest.setObjectiveSettingsRefractiveIndex(refractiveIndex, i);
                        }
                        catch (NullPointerException e) {}
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                }
                try {
                    String stageLabelName = src.getStageLabelName(i);
                    if (stageLabelName == null) break block202;
                    dest.setStageLabelName(stageLabelName, i);
                    try {
                        Double stageLabelX = src.getStageLabelX(i);
                        dest.setStageLabelX(stageLabelX, i);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        Double stageLabelY = src.getStageLabelY(i);
                        dest.setStageLabelY(stageLabelY, i);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        Double stageLabelZ = src.getStageLabelZ(i);
                        dest.setStageLabelZ(stageLabelZ, i);
                    }
                    catch (NullPointerException e) {}
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
            try {
                String pixelsID = src.getPixelsID(i);
                dest.setPixelsID(pixelsID, i);
                try {
                    DimensionOrder order = src.getPixelsDimensionOrder(i);
                    dest.setPixelsDimensionOrder(order, i);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    PositiveFloat physicalSizeX = src.getPixelsPhysicalSizeX(i);
                    dest.setPixelsPhysicalSizeX(physicalSizeX, i);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    PositiveFloat physicalSizeY = src.getPixelsPhysicalSizeY(i);
                    dest.setPixelsPhysicalSizeY(physicalSizeY, i);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    PositiveFloat physicalSizeZ = src.getPixelsPhysicalSizeZ(i);
                    dest.setPixelsPhysicalSizeZ(physicalSizeZ, i);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    PositiveInteger sizeC = src.getPixelsSizeC(i);
                    dest.setPixelsSizeC(sizeC, i);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    PositiveInteger sizeT = src.getPixelsSizeT(i);
                    dest.setPixelsSizeT(sizeT, i);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    PositiveInteger sizeX = src.getPixelsSizeX(i);
                    dest.setPixelsSizeX(sizeX, i);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    PositiveInteger sizeY = src.getPixelsSizeY(i);
                    dest.setPixelsSizeY(sizeY, i);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    PositiveInteger sizeZ = src.getPixelsSizeZ(i);
                    dest.setPixelsSizeZ(sizeZ, i);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Double timeIncrement = src.getPixelsTimeIncrement(i);
                    dest.setPixelsTimeIncrement(timeIncrement, i);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    PixelType type = src.getPixelsType(i);
                    dest.setPixelsType(type, i);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                int binDataCount = 0;
                try {
                    binDataCount = src.getPixelsBinDataCount(i);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                for (q4 = 0; q4 < binDataCount; ++q4) {
                    try {
                        Boolean bigEndian = src.getPixelsBinDataBigEndian(i, q4);
                        dest.setPixelsBinDataBigEndian(bigEndian, i, q4);
                        continue;
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                }
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            int annotationRefCount = 0;
            try {
                annotationRefCount = src.getImageAnnotationRefCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int q5 = 0; q5 < annotationRefCount; ++q5) {
                try {
                    String annotationRef = src.getImageAnnotationRef(i, q5);
                    dest.setImageAnnotationRef(annotationRef, i, q5);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
            int pixelsAnnotationRefCount = 0;
            try {
                pixelsAnnotationRefCount = src.getPixelsAnnotationRefCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (q4 = 0; q4 < pixelsAnnotationRefCount; ++q4) {
                try {
                    String pixelsAnnotationRef = src.getPixelsAnnotationRef(i, q4);
                    dest.setPixelsAnnotationRef(pixelsAnnotationRef, i, q4);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
            int channelCount = 0;
            try {
                channelCount = src.getChannelCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int c = 0; c < channelCount; ++c) {
                block204: {
                    block203: {
                        try {
                            String channelID = src.getChannelID(i, c);
                            dest.setChannelID(channelID, i, c);
                        }
                        catch (NullPointerException e) {
                            continue;
                        }
                        try {
                            AcquisitionMode mode = src.getChannelAcquisitionMode(i, c);
                            dest.setChannelAcquisitionMode(mode, i, c);
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            Color color = src.getChannelColor(i, c);
                            dest.setChannelColor(color, i, c);
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            ContrastMethod method = src.getChannelContrastMethod(i, c);
                            dest.setChannelContrastMethod(method, i, c);
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            PositiveInteger emWave = src.getChannelEmissionWavelength(i, c);
                            dest.setChannelEmissionWavelength(emWave, i, c);
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            PositiveInteger exWave = src.getChannelExcitationWavelength(i, c);
                            dest.setChannelExcitationWavelength(exWave, i, c);
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String filterSetRef = src.getChannelFilterSetRef(i, c);
                            dest.setChannelFilterSetRef(filterSetRef, i, c);
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String fluor = src.getChannelFluor(i, c);
                            dest.setChannelFluor(fluor, i, c);
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            IlluminationType illumType = src.getChannelIlluminationType(i, c);
                            dest.setChannelIlluminationType(illumType, i, c);
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            Double ndFilter = src.getChannelNDFilter(i, c);
                            dest.setChannelNDFilter(ndFilter, i, c);
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String channelName = src.getChannelName(i, c);
                            dest.setChannelName(channelName, i, c);
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            Double pinholeSize = src.getChannelPinholeSize(i, c);
                            dest.setChannelPinholeSize(pinholeSize, i, c);
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            Integer pockelCell = src.getChannelPockelCellSetting(i, c);
                            dest.setChannelPockelCellSetting(pockelCell, i, c);
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            PositiveInteger samplesPerPixel = src.getChannelSamplesPerPixel(i, c);
                            dest.setChannelSamplesPerPixel(samplesPerPixel, i, c);
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String detectorSettingsID = src.getDetectorSettingsID(i, c);
                            if (detectorSettingsID == null) break block203;
                            dest.setDetectorSettingsID(detectorSettingsID, i, c);
                            try {
                                Binning binning = src.getDetectorSettingsBinning(i, c);
                                dest.setDetectorSettingsBinning(binning, i, c);
                            }
                            catch (NullPointerException e) {
                                // empty catch block
                            }
                            try {
                                Double gain = src.getDetectorSettingsGain(i, c);
                                dest.setDetectorSettingsGain(gain, i, c);
                            }
                            catch (NullPointerException e) {
                                // empty catch block
                            }
                            try {
                                Double offset = src.getDetectorSettingsOffset(i, c);
                                dest.setDetectorSettingsOffset(offset, i, c);
                            }
                            catch (NullPointerException e) {
                                // empty catch block
                            }
                            try {
                                Double readOutRate = src.getDetectorSettingsReadOutRate(i, c);
                                dest.setDetectorSettingsReadOutRate(readOutRate, i, c);
                            }
                            catch (NullPointerException e) {
                                // empty catch block
                            }
                            try {
                                Double voltage = src.getDetectorSettingsVoltage(i, c);
                                dest.setDetectorSettingsVoltage(voltage, i, c);
                            }
                            catch (NullPointerException e) {}
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                    }
                    try {
                        String dichroicRef = src.getLightPathDichroicRef(i, c);
                        dest.setLightPathDichroicRef(dichroicRef, i, c);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        String lightSourceID = src.getChannelLightSourceSettingsID(i, c);
                        if (lightSourceID == null) break block204;
                        dest.setChannelLightSourceSettingsID(lightSourceID, i, c);
                        try {
                            PercentFraction attenuation = src.getChannelLightSourceSettingsAttenuation(i, c);
                            dest.setChannelLightSourceSettingsAttenuation(attenuation, i, c);
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            PositiveInteger wavelength = src.getChannelLightSourceSettingsWavelength(i, c);
                            dest.setChannelLightSourceSettingsWavelength(wavelength, i, c);
                        }
                        catch (NullPointerException e) {}
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                }
                int channelAnnotationRefCount = 0;
                try {
                    channelAnnotationRefCount = src.getChannelAnnotationRefCount(i, c);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                for (q3 = 0; q3 < channelAnnotationRefCount; ++q3) {
                    try {
                        String channelAnnotationRef = src.getChannelAnnotationRef(i, c, q3);
                        dest.setChannelAnnotationRef(channelAnnotationRef, i, c, q3);
                        continue;
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                }
                int emFilterRefCount = 0;
                try {
                    emFilterRefCount = src.getLightPathEmissionFilterRefCount(i, c);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                for (q2 = 0; q2 < emFilterRefCount; ++q2) {
                    try {
                        String emFilterRef = src.getLightPathEmissionFilterRef(i, c, q2);
                        dest.setLightPathEmissionFilterRef(emFilterRef, i, c, q2);
                        continue;
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                }
                int exFilterRefCount = 0;
                try {
                    exFilterRefCount = src.getLightPathExcitationFilterRefCount(i, c);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                for (q = 0; q < exFilterRefCount; ++q) {
                    try {
                        String exFilterRef = src.getLightPathExcitationFilterRef(i, c, q);
                        dest.setLightPathExcitationFilterRef(exFilterRef, i, c, q);
                        continue;
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                }
            }
            int planeCount = 0;
            try {
                planeCount = src.getPlaneCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int p = 0; p < planeCount; ++p) {
                try {
                    Double deltaT = src.getPlaneDeltaT(i, p);
                    dest.setPlaneDeltaT(deltaT, i, p);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Double exposureTime = src.getPlaneExposureTime(i, p);
                    dest.setPlaneExposureTime(exposureTime, i, p);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String sha1 = src.getPlaneHashSHA1(i, p);
                    dest.setPlaneHashSHA1(sha1, i, p);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Double positionX = src.getPlanePositionX(i, p);
                    dest.setPlanePositionX(positionX, i, p);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Double positionY = src.getPlanePositionY(i, p);
                    dest.setPlanePositionY(positionY, i, p);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Double positionZ = src.getPlanePositionZ(i, p);
                    dest.setPlanePositionZ(positionZ, i, p);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    NonNegativeInteger theC = src.getPlaneTheC(i, p);
                    dest.setPlaneTheC(theC, i, p);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    NonNegativeInteger theT = src.getPlaneTheT(i, p);
                    dest.setPlaneTheT(theT, i, p);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    NonNegativeInteger theZ = src.getPlaneTheZ(i, p);
                    dest.setPlaneTheZ(theZ, i, p);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                int planeAnnotationRefCount = 0;
                try {
                    planeAnnotationRefCount = src.getPlaneAnnotationRefCount(i, p);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                for (q2 = 0; q2 < planeAnnotationRefCount; ++q2) {
                    try {
                        String planeAnnotationRef = src.getPlaneAnnotationRef(i, p, q2);
                        dest.setPlaneAnnotationRef(planeAnnotationRef, i, p, q2);
                        continue;
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                }
            }
            int microbeamCount = 0;
            try {
                microbeamCount = src.getMicrobeamManipulationRefCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (q3 = 0; q3 < microbeamCount; ++q3) {
                try {
                    String microbeamRef = src.getImageMicrobeamManipulationRef(i, q3);
                    dest.setImageMicrobeamManipulationRef(microbeamRef, i, q3);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
            int roiRefCount = 0;
            try {
                roiRefCount = src.getImageROIRefCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (q2 = 0; q2 < roiRefCount; ++q2) {
                try {
                    String roiRef = src.getImageROIRef(i, q2);
                    dest.setImageROIRef(roiRef, i, q2);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
            int tiffDataCount = 0;
            try {
                tiffDataCount = src.getTiffDataCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (q = 0; q < tiffDataCount; ++q) {
                try {
                    String uuid = src.getUUIDValue(i, q);
                    dest.setUUIDValue(uuid, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String filename = src.getUUIDFileName(i, q);
                    dest.setUUIDFileName(filename, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    NonNegativeInteger firstC = src.getTiffDataFirstC(i, q);
                    dest.setTiffDataFirstC(firstC, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    NonNegativeInteger firstT = src.getTiffDataFirstT(i, q);
                    dest.setTiffDataFirstT(firstT, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    NonNegativeInteger firstZ = src.getTiffDataFirstZ(i, q);
                    dest.setTiffDataFirstZ(firstZ, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    NonNegativeInteger ifd = src.getTiffDataIFD(i, q);
                    dest.setTiffDataIFD(ifd, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    NonNegativeInteger tiffDataPlaneCount = src.getTiffDataPlaneCount(i, q);
                    dest.setTiffDataPlaneCount(tiffDataPlaneCount, i, q);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
    }

    private static void convertInstruments(MetadataRetrieve src, MetadataStore dest) {
        int instrumentCount = 0;
        try {
            instrumentCount = src.getInstrumentCount();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        for (int i = 0; i < instrumentCount; ++i) {
            try {
                String id = src.getInstrumentID(i);
                dest.setInstrumentID(id, i);
            }
            catch (NullPointerException e) {
                continue;
            }
            try {
                String microscopeLotNumber = src.getMicroscopeLotNumber(i);
                dest.setMicroscopeLotNumber(microscopeLotNumber, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String microscopeManufacturer = src.getMicroscopeManufacturer(i);
                dest.setMicroscopeManufacturer(microscopeManufacturer, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String microscopeModel = src.getMicroscopeModel(i);
                dest.setMicroscopeModel(microscopeModel, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String microscopeSerialNumber = src.getMicroscopeSerialNumber(i);
                dest.setMicroscopeSerialNumber(microscopeSerialNumber, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                MicroscopeType microscopeType = src.getMicroscopeType(i);
                dest.setMicroscopeType(microscopeType, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            int detectorCount = 0;
            try {
                detectorCount = src.getDetectorCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int q = 0; q < detectorCount; ++q) {
                try {
                    String detectorID = src.getDetectorID(i, q);
                    dest.setDetectorID(detectorID, i, q);
                }
                catch (NullPointerException e) {
                    continue;
                }
                try {
                    Double amplificationGain = src.getDetectorAmplificationGain(i, q);
                    dest.setDetectorAmplificationGain(amplificationGain, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Double gain = src.getDetectorGain(i, q);
                    dest.setDetectorGain(gain, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String lotNumber = src.getDetectorLotNumber(i, q);
                    dest.setDetectorLotNumber(lotNumber, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String manufacturer = src.getDetectorManufacturer(i, q);
                    dest.setDetectorManufacturer(manufacturer, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String model = src.getDetectorModel(i, q);
                    dest.setDetectorModel(model, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Double offset = src.getDetectorOffset(i, q);
                    dest.setDetectorOffset(offset, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String serialNumber = src.getDetectorSerialNumber(i, q);
                    dest.setDetectorSerialNumber(serialNumber, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    DetectorType detectorType = src.getDetectorType(i, q);
                    dest.setDetectorType(detectorType, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Double voltage = src.getDetectorVoltage(i, q);
                    dest.setDetectorVoltage(voltage, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Double zoom = src.getDetectorZoom(i, q);
                    dest.setDetectorZoom(zoom, i, q);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
            int dichroicCount = 0;
            try {
                dichroicCount = src.getDichroicCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int q = 0; q < dichroicCount; ++q) {
                try {
                    String dichroicID = src.getDichroicID(i, q);
                    dest.setDichroicID(dichroicID, i, q);
                }
                catch (NullPointerException e) {
                    continue;
                }
                try {
                    String lotNumber = src.getDichroicLotNumber(i, q);
                    dest.setDichroicLotNumber(lotNumber, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String manufacturer = src.getDichroicManufacturer(i, q);
                    dest.setDichroicManufacturer(manufacturer, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String model = src.getDichroicModel(i, q);
                    dest.setDichroicModel(model, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String serialNumber = src.getDichroicSerialNumber(i, q);
                    dest.setDichroicSerialNumber(serialNumber, i, q);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
            int filterCount = 0;
            try {
                filterCount = src.getFilterCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int q = 0; q < filterCount; ++q) {
                try {
                    String filterID = src.getFilterID(i, q);
                    dest.setFilterID(filterID, i, q);
                }
                catch (NullPointerException e) {
                    continue;
                }
                try {
                    String filterWheel = src.getFilterFilterWheel(i, q);
                    dest.setFilterFilterWheel(filterWheel, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String lotNumber = src.getFilterLotNumber(i, q);
                    dest.setFilterLotNumber(lotNumber, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String manufacturer = src.getFilterManufacturer(i, q);
                    dest.setFilterManufacturer(manufacturer, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String model = src.getFilterModel(i, q);
                    dest.setFilterModel(model, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String serialNumber = src.getFilterSerialNumber(i, q);
                    dest.setFilterSerialNumber(serialNumber, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    FilterType filterType = src.getFilterType(i, q);
                    dest.setFilterType(filterType, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    PositiveInteger cutIn = src.getTransmittanceRangeCutIn(i, q);
                    dest.setTransmittanceRangeCutIn(cutIn, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    NonNegativeInteger cutInTolerance = src.getTransmittanceRangeCutInTolerance(i, q);
                    dest.setTransmittanceRangeCutInTolerance(cutInTolerance, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    PositiveInteger cutOut = src.getTransmittanceRangeCutOut(i, q);
                    dest.setTransmittanceRangeCutOut(cutOut, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    NonNegativeInteger cutOutTolerance = src.getTransmittanceRangeCutOutTolerance(i, q);
                    dest.setTransmittanceRangeCutOutTolerance(cutOutTolerance, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    PercentFraction transmittance = src.getTransmittanceRangeTransmittance(i, q);
                    dest.setTransmittanceRangeTransmittance(transmittance, i, q);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
            int objectiveCount = 0;
            try {
                objectiveCount = src.getObjectiveCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int q = 0; q < objectiveCount; ++q) {
                try {
                    String objectiveID = src.getObjectiveID(i, q);
                    dest.setObjectiveID(objectiveID, i, q);
                }
                catch (NullPointerException e) {
                    continue;
                }
                try {
                    Double calibratedMag = src.getObjectiveCalibratedMagnification(i, q);
                    dest.setObjectiveCalibratedMagnification(calibratedMag, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Correction correction = src.getObjectiveCorrection(i, q);
                    dest.setObjectiveCorrection(correction, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Immersion immersion = src.getObjectiveImmersion(i, q);
                    dest.setObjectiveImmersion(immersion, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Boolean iris = src.getObjectiveIris(i, q);
                    dest.setObjectiveIris(iris, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Double lensNA = src.getObjectiveLensNA(i, q);
                    dest.setObjectiveLensNA(lensNA, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String lotNumber = src.getObjectiveLotNumber(i, q);
                    dest.setObjectiveLotNumber(lotNumber, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String manufacturer = src.getObjectiveManufacturer(i, q);
                    dest.setObjectiveManufacturer(manufacturer, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String model = src.getObjectiveModel(i, q);
                    dest.setObjectiveModel(model, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    PositiveInteger nominalMag = src.getObjectiveNominalMagnification(i, q);
                    dest.setObjectiveNominalMagnification(nominalMag, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String serialNumber = src.getObjectiveSerialNumber(i, q);
                    dest.setObjectiveSerialNumber(serialNumber, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Double workingDistance = src.getObjectiveWorkingDistance(i, q);
                    dest.setObjectiveWorkingDistance(workingDistance, i, q);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
            int filterSetCount = 0;
            try {
                filterSetCount = src.getFilterSetCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int q = 0; q < filterSetCount; ++q) {
                try {
                    String filterSetID = src.getFilterSetID(i, q);
                    dest.setFilterSetID(filterSetID, i, q);
                }
                catch (NullPointerException e) {
                    continue;
                }
                try {
                    String dichroicRef = src.getFilterSetDichroicRef(i, q);
                    dest.setFilterSetDichroicRef(dichroicRef, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String lotNumber = src.getFilterSetLotNumber(i, q);
                    dest.setFilterSetLotNumber(lotNumber, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String manufacturer = src.getFilterSetManufacturer(i, q);
                    dest.setFilterSetManufacturer(manufacturer, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String model = src.getFilterSetModel(i, q);
                    dest.setFilterSetModel(model, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String serialNumber = src.getFilterSetSerialNumber(i, q);
                    dest.setFilterSetSerialNumber(serialNumber, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                int emFilterCount = 0;
                try {
                    emFilterCount = src.getFilterSetEmissionFilterRefCount(i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                for (int f = 0; f < emFilterCount; ++f) {
                    try {
                        String emFilterRef = src.getFilterSetEmissionFilterRef(i, q, f);
                        dest.setFilterSetEmissionFilterRef(emFilterRef, i, q, f);
                        continue;
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                }
                int exFilterCount = 0;
                try {
                    exFilterCount = src.getFilterSetExcitationFilterRefCount(i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                for (int f = 0; f < exFilterCount; ++f) {
                    try {
                        String exFilterRef = src.getFilterSetExcitationFilterRef(i, q, f);
                        dest.setFilterSetExcitationFilterRef(exFilterRef, i, q, f);
                        continue;
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                }
            }
            MetadataConverter.convertLightSources(src, dest, i);
        }
    }

    private static void convertListAnnotations(MetadataRetrieve src, MetadataStore dest) {
        int listAnnotationCount = 0;
        try {
            listAnnotationCount = src.getListAnnotationCount();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        for (int i = 0; i < listAnnotationCount; ++i) {
            try {
                String id = src.getListAnnotationID(i);
                dest.setListAnnotationID(id, i);
            }
            catch (NullPointerException e) {
                continue;
            }
            try {
                String description = src.getListAnnotationDescription(i);
                dest.setListAnnotationDescription(description, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String namespace = src.getListAnnotationNamespace(i);
                dest.setListAnnotationNamespace(namespace, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            int annotationRefCount = 0;
            try {
                annotationRefCount = src.getListAnnotationAnnotationCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int a = 0; a < annotationRefCount; ++a) {
                try {
                    String id = src.getListAnnotationAnnotationRef(i, a);
                    dest.setListAnnotationAnnotationRef(id, i, a);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
    }

    private static void convertLongAnnotations(MetadataRetrieve src, MetadataStore dest) {
        int longAnnotationCount = 0;
        try {
            longAnnotationCount = src.getLongAnnotationCount();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        for (int i = 0; i < longAnnotationCount; ++i) {
            try {
                String id = src.getLongAnnotationID(i);
                dest.setLongAnnotationID(id, i);
            }
            catch (NullPointerException e) {
                continue;
            }
            try {
                String description = src.getLongAnnotationDescription(i);
                dest.setLongAnnotationDescription(description, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String namespace = src.getLongAnnotationNamespace(i);
                dest.setLongAnnotationNamespace(namespace, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                Long value = src.getLongAnnotationValue(i);
                dest.setLongAnnotationValue(value, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            int annotationRefCount = 0;
            try {
                annotationRefCount = src.getLongAnnotationAnnotationCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int a = 0; a < annotationRefCount; ++a) {
                try {
                    String id = src.getLongAnnotationAnnotationRef(i, a);
                    dest.setLongAnnotationAnnotationRef(id, i, a);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
    }

    private static void convertPlates(MetadataRetrieve src, MetadataStore dest) {
        int plateCount = 0;
        try {
            plateCount = src.getPlateCount();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        for (int i = 0; i < plateCount; ++i) {
            try {
                String id = src.getPlateID(i);
                dest.setPlateID(id, i);
            }
            catch (NullPointerException e) {
                continue;
            }
            try {
                NamingConvention columnConvention = src.getPlateColumnNamingConvention(i);
                dest.setPlateColumnNamingConvention(columnConvention, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                PositiveInteger columns = src.getPlateColumns(i);
                dest.setPlateColumns(columns, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String description = src.getPlateDescription(i);
                dest.setPlateDescription(description, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String externalID = src.getPlateExternalIdentifier(i);
                dest.setPlateExternalIdentifier(externalID, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                NonNegativeInteger fieldIndex = src.getPlateFieldIndex(i);
                dest.setPlateFieldIndex(fieldIndex, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String name = src.getPlateName(i);
                if (name == null) {
                    name = "";
                }
                dest.setPlateName(name, i);
            }
            catch (NullPointerException e) {
                dest.setPlateName("", i);
            }
            try {
                NamingConvention rowConvention = src.getPlateRowNamingConvention(i);
                dest.setPlateRowNamingConvention(rowConvention, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                PositiveInteger rows = src.getPlateRows(i);
                dest.setPlateRows(rows, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String status = src.getPlateStatus(i);
                dest.setPlateStatus(status, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                Double wellOriginX = src.getPlateWellOriginX(i);
                dest.setPlateWellOriginX(wellOriginX, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                Double wellOriginY = src.getPlateWellOriginY(i);
                dest.setPlateWellOriginY(wellOriginY, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            int wellCount = 0;
            try {
                wellCount = src.getWellCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int q = 0; q < wellCount; ++q) {
                try {
                    String wellID = src.getWellID(i, q);
                    dest.setWellID(wellID, i, q);
                }
                catch (NullPointerException e) {
                    continue;
                }
                try {
                    Color color = src.getWellColor(i, q);
                    dest.setWellColor(color, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    NonNegativeInteger column = src.getWellColumn(i, q);
                    dest.setWellColumn(column, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String externalDescription = src.getWellExternalDescription(i, q);
                    dest.setWellExternalDescription(externalDescription, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String wellExternalID = src.getWellExternalIdentifier(i, q);
                    dest.setWellExternalIdentifier(wellExternalID, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String reagentRef = src.getWellReagentRef(i, q);
                    dest.setWellReagentRef(reagentRef, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    NonNegativeInteger row = src.getWellRow(i, q);
                    dest.setWellRow(row, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String type = src.getWellType(i, q);
                    dest.setWellType(type, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                int wellAnnotationRefCount = 0;
                try {
                    src.getWellAnnotationRefCount(i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                for (int a = 0; a < wellAnnotationRefCount; ++a) {
                    try {
                        String wellAnnotationRef = src.getWellAnnotationRef(i, q, a);
                        dest.setWellAnnotationRef(wellAnnotationRef, i, q, a);
                        continue;
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                }
                int wellSampleCount = 0;
                try {
                    wellSampleCount = src.getWellSampleCount(i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                for (int w = 0; w < wellSampleCount; ++w) {
                    try {
                        String wellSampleID = src.getWellSampleID(i, q, w);
                        dest.setWellSampleID(wellSampleID, i, q, w);
                    }
                    catch (NullPointerException e) {
                        continue;
                    }
                    try {
                        String imageRef = src.getWellSampleImageRef(i, q, w);
                        dest.setWellSampleImageRef(imageRef, i, q, w);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        Double positionX = src.getWellSamplePositionX(i, q, w);
                        dest.setWellSamplePositionX(positionX, i, q, w);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        Double positionY = src.getWellSamplePositionY(i, q, w);
                        dest.setWellSamplePositionY(positionY, i, q, w);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        Timestamp timepoint = src.getWellSampleTimepoint(i, q, w);
                        dest.setWellSampleTimepoint(timepoint, i, q, w);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    int wellSampleAnnotationRefCount = 0;
                    try {
                        wellSampleAnnotationRefCount = src.getWellSampleAnnotationRefCount(i, q, w);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    for (int a = 0; a < wellSampleAnnotationRefCount; ++a) {
                        try {
                            String wellSampleAnnotationRef = src.getWellSampleAnnotationRef(i, q, w, a);
                            dest.setWellSampleAnnotationRef(wellSampleAnnotationRef, i, q, w, a);
                            continue;
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                    }
                }
            }
            int plateAcquisitionCount = 0;
            try {
                plateAcquisitionCount = src.getPlateAcquisitionCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int q = 0; q < plateAcquisitionCount; ++q) {
                try {
                    String plateAcquisitionID = src.getPlateAcquisitionID(i, q);
                    dest.setPlateAcquisitionID(plateAcquisitionID, i, q);
                }
                catch (NullPointerException e) {
                    continue;
                }
                try {
                    String acquisitionDescription = src.getPlateAcquisitionDescription(i, q);
                    dest.setPlateAcquisitionDescription(acquisitionDescription, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Timestamp endTime = src.getPlateAcquisitionEndTime(i, q);
                    dest.setPlateAcquisitionEndTime(endTime, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    PositiveInteger maximumFields = src.getPlateAcquisitionMaximumFieldCount(i, q);
                    dest.setPlateAcquisitionMaximumFieldCount(maximumFields, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String acquisitionName = src.getPlateAcquisitionName(i, q);
                    dest.setPlateAcquisitionName(acquisitionName, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Timestamp startTime = src.getPlateAcquisitionStartTime(i, q);
                    dest.setPlateAcquisitionStartTime(startTime, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                int plateAcquisitionAnnotationRefCount = 0;
                try {
                    plateAcquisitionAnnotationRefCount = src.getPlateAcquisitionAnnotationRefCount(i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                for (int a = 0; a < plateAcquisitionAnnotationRefCount; ++a) {
                    try {
                        String plateAcquisitionAnnotationRef = src.getPlateAcquisitionAnnotationRef(i, q, a);
                        dest.setPlateAcquisitionAnnotationRef(plateAcquisitionAnnotationRef, i, q, a);
                        continue;
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                }
                int wellSampleRefCount = 0;
                try {
                    wellSampleRefCount = src.getWellSampleRefCount(i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                for (int w = 0; w < wellSampleRefCount; ++w) {
                    try {
                        String wellSampleRef = src.getPlateAcquisitionWellSampleRef(i, q, w);
                        dest.setPlateAcquisitionWellSampleRef(wellSampleRef, i, q, w);
                        continue;
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                }
            }
            int plateAnnotationRefCount = 0;
            try {
                plateAnnotationRefCount = src.getPlateAnnotationRefCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int q = 0; q < plateAnnotationRefCount; ++q) {
                try {
                    String annotationRef = src.getPlateAnnotationRef(i, q);
                    dest.setPlateAnnotationRef(annotationRef, i, q);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
    }

    private static void convertProjects(MetadataRetrieve src, MetadataStore dest) {
        int projectCount = 0;
        try {
            projectCount = src.getProjectCount();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        for (int i = 0; i < projectCount; ++i) {
            try {
                String projectID = src.getProjectID(i);
                dest.setProjectID(projectID, i);
            }
            catch (NullPointerException e) {
                continue;
            }
            try {
                String description = src.getProjectDescription(i);
                dest.setProjectDescription(description, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String experimenterGroupRef = src.getProjectExperimenterGroupRef(i);
                dest.setProjectExperimenterGroupRef(experimenterGroupRef, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String experimenterRef = src.getProjectExperimenterRef(i);
                dest.setProjectExperimenterRef(experimenterRef, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String name = src.getProjectName(i);
                dest.setProjectName(name, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            int annotationRefCount = 0;
            try {
                annotationRefCount = src.getProjectAnnotationRefCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int q = 0; q < annotationRefCount; ++q) {
                try {
                    String annotationRef = src.getProjectAnnotationRef(i, q);
                    dest.setProjectAnnotationRef(annotationRef, i, q);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
            int datasetRefCount = 0;
            try {
                datasetRefCount = src.getDatasetRefCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int q = 0; q < datasetRefCount; ++q) {
                try {
                    String datasetRef = src.getProjectDatasetRef(i, q);
                    dest.setProjectDatasetRef(datasetRef, i, q);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
    }

    private static void convertROIs(MetadataRetrieve src, MetadataStore dest) {
        int roiCount = 0;
        try {
            roiCount = src.getROICount();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        for (int i = 0; i < roiCount; ++i) {
            try {
                String id = src.getROIID(i);
                dest.setROIID(id, i);
            }
            catch (NullPointerException e) {
                continue;
            }
            try {
                String name = src.getROIName(i);
                dest.setROIName(name, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String description = src.getROIDescription(i);
                dest.setROIDescription(description, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String namespace = src.getROINamespace(i);
                dest.setROINamespace(namespace, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            int shapeCount = 0;
            try {
                shapeCount = src.getShapeCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int q = 0; q < shapeCount; ++q) {
                String points;
                Double width;
                Double height;
                Marker start;
                Marker end;
                Double y;
                Double x;
                Boolean visible;
                AffineTransform transform;
                NonNegativeInteger theZ;
                NonNegativeInteger theT;
                NonNegativeInteger theC;
                String text;
                Double strokeWidth;
                String dashArray;
                Color strokeColor;
                Boolean locked;
                LineCap lineCap;
                FontStyle fontStyle;
                NonNegativeInteger fontSize;
                FontFamily fontFamily;
                FillRule fillRule;
                Color fillColor;
                String shapeID;
                String type = src.getShapeType(i, q);
                if (type.equals("Ellipse")) {
                    try {
                        shapeID = src.getEllipseID(i, q);
                        dest.setEllipseID(shapeID, i, q);
                    }
                    catch (NullPointerException e) {
                        continue;
                    }
                    try {
                        fillColor = src.getEllipseFillColor(i, q);
                        dest.setEllipseFillColor(fillColor, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        fillRule = src.getEllipseFillRule(i, q);
                        dest.setEllipseFillRule(fillRule, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        fontFamily = src.getEllipseFontFamily(i, q);
                        dest.setEllipseFontFamily(fontFamily, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        fontSize = src.getEllipseFontSize(i, q);
                        dest.setEllipseFontSize(fontSize, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        fontStyle = src.getEllipseFontStyle(i, q);
                        dest.setEllipseFontStyle(fontStyle, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        lineCap = src.getEllipseLineCap(i, q);
                        dest.setEllipseLineCap(lineCap, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        locked = src.getEllipseLocked(i, q);
                        dest.setEllipseLocked(locked, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        strokeColor = src.getEllipseStrokeColor(i, q);
                        dest.setEllipseStrokeColor(strokeColor, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        dashArray = src.getEllipseStrokeDashArray(i, q);
                        dest.setEllipseStrokeDashArray(dashArray, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        strokeWidth = src.getEllipseStrokeWidth(i, q);
                        dest.setEllipseStrokeWidth(strokeWidth, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        text = src.getEllipseText(i, q);
                        dest.setEllipseText(text, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        theC = src.getEllipseTheC(i, q);
                        dest.setEllipseTheC(theC, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        theT = src.getEllipseTheT(i, q);
                        dest.setEllipseTheT(theT, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        theZ = src.getEllipseTheZ(i, q);
                        dest.setEllipseTheZ(theZ, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        transform = src.getEllipseTransform(i, q);
                        dest.setEllipseTransform(transform, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        visible = src.getEllipseVisible(i, q);
                        dest.setEllipseVisible(visible, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        Double radiusX = src.getEllipseRadiusX(i, q);
                        dest.setEllipseRadiusX(radiusX, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        Double radiusY = src.getEllipseRadiusY(i, q);
                        dest.setEllipseRadiusY(radiusY, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        x = src.getEllipseX(i, q);
                        dest.setEllipseX(x, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        y = src.getEllipseY(i, q);
                        dest.setEllipseY(y, i, q);
                    }
                    catch (NullPointerException e) {}
                    continue;
                }
                if (type.equals("Label")) {
                    try {
                        shapeID = src.getLabelID(i, q);
                        dest.setLabelID(shapeID, i, q);
                    }
                    catch (NullPointerException e) {
                        continue;
                    }
                    try {
                        fillColor = src.getLabelFillColor(i, q);
                        dest.setLabelFillColor(fillColor, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        fillRule = src.getLabelFillRule(i, q);
                        dest.setLabelFillRule(fillRule, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        fontFamily = src.getLabelFontFamily(i, q);
                        dest.setLabelFontFamily(fontFamily, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        fontSize = src.getLabelFontSize(i, q);
                        dest.setLabelFontSize(fontSize, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        fontStyle = src.getLabelFontStyle(i, q);
                        dest.setLabelFontStyle(fontStyle, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        lineCap = src.getLabelLineCap(i, q);
                        dest.setLabelLineCap(lineCap, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        locked = src.getLabelLocked(i, q);
                        dest.setLabelLocked(locked, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        strokeColor = src.getLabelStrokeColor(i, q);
                        dest.setLabelStrokeColor(strokeColor, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        dashArray = src.getLabelStrokeDashArray(i, q);
                        dest.setLabelStrokeDashArray(dashArray, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        strokeWidth = src.getLabelStrokeWidth(i, q);
                        dest.setLabelStrokeWidth(strokeWidth, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        text = src.getLabelText(i, q);
                        dest.setLabelText(text, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        theC = src.getLabelTheC(i, q);
                        dest.setLabelTheC(theC, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        theT = src.getLabelTheT(i, q);
                        dest.setLabelTheT(theT, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        theZ = src.getLabelTheZ(i, q);
                        dest.setLabelTheZ(theZ, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        transform = src.getLabelTransform(i, q);
                        dest.setLabelTransform(transform, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        visible = src.getLabelVisible(i, q);
                        dest.setLabelVisible(visible, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        x = src.getLabelX(i, q);
                        dest.setLabelX(x, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        y = src.getLabelY(i, q);
                        dest.setLabelY(y, i, q);
                    }
                    catch (NullPointerException e) {}
                    continue;
                }
                if (type.equals("Line")) {
                    try {
                        shapeID = src.getLineID(i, q);
                        dest.setLineID(shapeID, i, q);
                    }
                    catch (NullPointerException e) {
                        continue;
                    }
                    try {
                        fillColor = src.getLineFillColor(i, q);
                        dest.setLineFillColor(fillColor, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        fillRule = src.getLineFillRule(i, q);
                        dest.setLineFillRule(fillRule, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        fontFamily = src.getLineFontFamily(i, q);
                        dest.setLineFontFamily(fontFamily, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        fontSize = src.getLineFontSize(i, q);
                        dest.setLineFontSize(fontSize, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        fontStyle = src.getLineFontStyle(i, q);
                        dest.setLineFontStyle(fontStyle, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        lineCap = src.getLineLineCap(i, q);
                        dest.setLineLineCap(lineCap, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        locked = src.getLineLocked(i, q);
                        dest.setLineLocked(locked, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        strokeColor = src.getLineStrokeColor(i, q);
                        dest.setLineStrokeColor(strokeColor, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        dashArray = src.getLineStrokeDashArray(i, q);
                        dest.setLineStrokeDashArray(dashArray, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        strokeWidth = src.getLineStrokeWidth(i, q);
                        dest.setLineStrokeWidth(strokeWidth, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        text = src.getLineText(i, q);
                        dest.setLineText(text, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        theC = src.getLineTheC(i, q);
                        dest.setLineTheC(theC, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        theT = src.getLineTheT(i, q);
                        dest.setLineTheT(theT, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        theZ = src.getLineTheZ(i, q);
                        dest.setLineTheZ(theZ, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        transform = src.getLineTransform(i, q);
                        dest.setLineTransform(transform, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        visible = src.getLineVisible(i, q);
                        dest.setLineVisible(visible, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        end = src.getLineMarkerEnd(i, q);
                        dest.setLineMarkerEnd(end, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        start = src.getLineMarkerStart(i, q);
                        dest.setLineMarkerStart(start, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        Double x1 = src.getLineX1(i, q);
                        dest.setLineX1(x1, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        Double x2 = src.getLineX2(i, q);
                        dest.setLineX2(x2, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        Double y1 = src.getLineY1(i, q);
                        dest.setLineY1(y1, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        Double y2 = src.getLineY2(i, q);
                        dest.setLineY2(y2, i, q);
                    }
                    catch (NullPointerException e) {}
                    continue;
                }
                if (type.equals("Mask")) {
                    try {
                        shapeID = src.getMaskID(i, q);
                        dest.setMaskID(shapeID, i, q);
                    }
                    catch (NullPointerException e) {
                        continue;
                    }
                    try {
                        fillColor = src.getMaskFillColor(i, q);
                        dest.setMaskFillColor(fillColor, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        fillRule = src.getMaskFillRule(i, q);
                        dest.setMaskFillRule(fillRule, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        fontFamily = src.getMaskFontFamily(i, q);
                        dest.setMaskFontFamily(fontFamily, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        fontSize = src.getMaskFontSize(i, q);
                        dest.setMaskFontSize(fontSize, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        fontStyle = src.getMaskFontStyle(i, q);
                        dest.setMaskFontStyle(fontStyle, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        lineCap = src.getMaskLineCap(i, q);
                        dest.setMaskLineCap(lineCap, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        locked = src.getMaskLocked(i, q);
                        dest.setMaskLocked(locked, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        strokeColor = src.getMaskStrokeColor(i, q);
                        dest.setMaskStrokeColor(strokeColor, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        dashArray = src.getMaskStrokeDashArray(i, q);
                        dest.setMaskStrokeDashArray(dashArray, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        strokeWidth = src.getMaskStrokeWidth(i, q);
                        dest.setMaskStrokeWidth(strokeWidth, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        text = src.getMaskText(i, q);
                        dest.setMaskText(text, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        theC = src.getMaskTheC(i, q);
                        dest.setMaskTheC(theC, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        theT = src.getMaskTheT(i, q);
                        dest.setMaskTheT(theT, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        theZ = src.getMaskTheZ(i, q);
                        dest.setMaskTheZ(theZ, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        transform = src.getMaskTransform(i, q);
                        dest.setMaskTransform(transform, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        visible = src.getMaskVisible(i, q);
                        dest.setMaskVisible(visible, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        height = src.getMaskHeight(i, q);
                        dest.setMaskHeight(height, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        width = src.getMaskWidth(i, q);
                        dest.setMaskWidth(width, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        x = src.getMaskX(i, q);
                        dest.setMaskX(x, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        y = src.getMaskY(i, q);
                        dest.setMaskY(y, i, q);
                    }
                    catch (NullPointerException e) {}
                    continue;
                }
                if (type.equals("Point")) {
                    try {
                        shapeID = src.getPointID(i, q);
                        dest.setPointID(shapeID, i, q);
                    }
                    catch (NullPointerException e) {
                        continue;
                    }
                    try {
                        fillColor = src.getPointFillColor(i, q);
                        dest.setPointFillColor(fillColor, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        fillRule = src.getPointFillRule(i, q);
                        dest.setPointFillRule(fillRule, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        fontFamily = src.getPointFontFamily(i, q);
                        dest.setPointFontFamily(fontFamily, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        fontSize = src.getPointFontSize(i, q);
                        dest.setPointFontSize(fontSize, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        fontStyle = src.getPointFontStyle(i, q);
                        dest.setPointFontStyle(fontStyle, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        lineCap = src.getPointLineCap(i, q);
                        dest.setPointLineCap(lineCap, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        locked = src.getPointLocked(i, q);
                        dest.setPointLocked(locked, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        strokeColor = src.getPointStrokeColor(i, q);
                        dest.setPointStrokeColor(strokeColor, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        dashArray = src.getPointStrokeDashArray(i, q);
                        dest.setPointStrokeDashArray(dashArray, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        strokeWidth = src.getPointStrokeWidth(i, q);
                        dest.setPointStrokeWidth(strokeWidth, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        text = src.getPointText(i, q);
                        dest.setPointText(text, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        theC = src.getPointTheC(i, q);
                        dest.setPointTheC(theC, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        theT = src.getPointTheT(i, q);
                        dest.setPointTheT(theT, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        theZ = src.getPointTheZ(i, q);
                        dest.setPointTheZ(theZ, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        transform = src.getPointTransform(i, q);
                        dest.setPointTransform(transform, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        visible = src.getPointVisible(i, q);
                        dest.setPointVisible(visible, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        x = src.getPointX(i, q);
                        dest.setPointX(x, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        y = src.getPointY(i, q);
                        dest.setPointY(y, i, q);
                    }
                    catch (NullPointerException e) {}
                    continue;
                }
                if (type.equals("Polygon")) {
                    try {
                        shapeID = src.getPolygonID(i, q);
                        dest.setPolygonID(shapeID, i, q);
                    }
                    catch (NullPointerException e) {
                        continue;
                    }
                    try {
                        fillColor = src.getPolygonFillColor(i, q);
                        dest.setPolygonFillColor(fillColor, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        fillRule = src.getPolygonFillRule(i, q);
                        dest.setPolygonFillRule(fillRule, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        fontFamily = src.getPolygonFontFamily(i, q);
                        dest.setPolygonFontFamily(fontFamily, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        fontSize = src.getPolygonFontSize(i, q);
                        dest.setPolygonFontSize(fontSize, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        fontStyle = src.getPolygonFontStyle(i, q);
                        dest.setPolygonFontStyle(fontStyle, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        lineCap = src.getPolygonLineCap(i, q);
                        dest.setPolygonLineCap(lineCap, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        locked = src.getPolygonLocked(i, q);
                        dest.setPolygonLocked(locked, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        strokeColor = src.getPolygonStrokeColor(i, q);
                        dest.setPolygonStrokeColor(strokeColor, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        dashArray = src.getPolygonStrokeDashArray(i, q);
                        dest.setPolygonStrokeDashArray(dashArray, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        strokeWidth = src.getPolygonStrokeWidth(i, q);
                        dest.setPolygonStrokeWidth(strokeWidth, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        text = src.getPolygonText(i, q);
                        dest.setPolygonText(text, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        theC = src.getPolygonTheC(i, q);
                        dest.setPolygonTheC(theC, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        theT = src.getPolygonTheT(i, q);
                        dest.setPolygonTheT(theT, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        theZ = src.getPolygonTheZ(i, q);
                        dest.setPolygonTheZ(theZ, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        transform = src.getPolygonTransform(i, q);
                        dest.setPolygonTransform(transform, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        visible = src.getPolygonVisible(i, q);
                        dest.setPolygonVisible(visible, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        points = src.getPolygonPoints(i, q);
                        dest.setPolygonPoints(points, i, q);
                    }
                    catch (NullPointerException e) {}
                    continue;
                }
                if (type.equals("Polyline")) {
                    try {
                        shapeID = src.getPolylineID(i, q);
                        dest.setPolylineID(shapeID, i, q);
                    }
                    catch (NullPointerException e) {
                        continue;
                    }
                    try {
                        fillColor = src.getPolylineFillColor(i, q);
                        dest.setPolylineFillColor(fillColor, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        fillRule = src.getPolylineFillRule(i, q);
                        dest.setPolylineFillRule(fillRule, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        fontFamily = src.getPolylineFontFamily(i, q);
                        dest.setPolylineFontFamily(fontFamily, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        fontSize = src.getPolylineFontSize(i, q);
                        dest.setPolylineFontSize(fontSize, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        fontStyle = src.getPolylineFontStyle(i, q);
                        dest.setPolylineFontStyle(fontStyle, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        lineCap = src.getPolylineLineCap(i, q);
                        dest.setPolylineLineCap(lineCap, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        locked = src.getPolylineLocked(i, q);
                        dest.setPolylineLocked(locked, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        strokeColor = src.getPolylineStrokeColor(i, q);
                        dest.setPolylineStrokeColor(strokeColor, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        dashArray = src.getPolylineStrokeDashArray(i, q);
                        dest.setPolylineStrokeDashArray(dashArray, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        strokeWidth = src.getPolylineStrokeWidth(i, q);
                        dest.setPolylineStrokeWidth(strokeWidth, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        text = src.getPolylineText(i, q);
                        dest.setPolylineText(text, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        theC = src.getPolylineTheC(i, q);
                        dest.setPolylineTheC(theC, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        theT = src.getPolylineTheT(i, q);
                        dest.setPolylineTheT(theT, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        theZ = src.getPolylineTheZ(i, q);
                        dest.setPolylineTheZ(theZ, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        transform = src.getPolylineTransform(i, q);
                        dest.setPolylineTransform(transform, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        visible = src.getPolylineVisible(i, q);
                        dest.setPolylineVisible(visible, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        end = src.getPolylineMarkerEnd(i, q);
                        dest.setPolylineMarkerEnd(end, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        start = src.getPolylineMarkerStart(i, q);
                        dest.setPolylineMarkerStart(start, i, q);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        points = src.getPolylinePoints(i, q);
                        dest.setPolylinePoints(points, i, q);
                    }
                    catch (NullPointerException e) {}
                    continue;
                }
                if (!type.equals("Rectangle")) continue;
                try {
                    shapeID = src.getRectangleID(i, q);
                    dest.setRectangleID(shapeID, i, q);
                }
                catch (NullPointerException e) {
                    continue;
                }
                try {
                    fillColor = src.getRectangleFillColor(i, q);
                    dest.setRectangleFillColor(fillColor, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    fillRule = src.getRectangleFillRule(i, q);
                    dest.setRectangleFillRule(fillRule, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    fontFamily = src.getRectangleFontFamily(i, q);
                    dest.setRectangleFontFamily(fontFamily, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    fontSize = src.getRectangleFontSize(i, q);
                    dest.setRectangleFontSize(fontSize, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    fontStyle = src.getRectangleFontStyle(i, q);
                    dest.setRectangleFontStyle(fontStyle, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    lineCap = src.getRectangleLineCap(i, q);
                    dest.setRectangleLineCap(lineCap, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    locked = src.getRectangleLocked(i, q);
                    dest.setRectangleLocked(locked, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    strokeColor = src.getRectangleStrokeColor(i, q);
                    dest.setRectangleStrokeColor(strokeColor, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    dashArray = src.getRectangleStrokeDashArray(i, q);
                    dest.setRectangleStrokeDashArray(dashArray, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    strokeWidth = src.getRectangleStrokeWidth(i, q);
                    dest.setRectangleStrokeWidth(strokeWidth, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    text = src.getRectangleText(i, q);
                    dest.setRectangleText(text, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    theC = src.getRectangleTheC(i, q);
                    dest.setRectangleTheC(theC, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    theT = src.getRectangleTheT(i, q);
                    dest.setRectangleTheT(theT, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    theZ = src.getRectangleTheZ(i, q);
                    dest.setRectangleTheZ(theZ, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    transform = src.getRectangleTransform(i, q);
                    dest.setRectangleTransform(transform, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    visible = src.getRectangleVisible(i, q);
                    dest.setRectangleVisible(visible, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    height = src.getRectangleHeight(i, q);
                    dest.setRectangleHeight(height, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    width = src.getRectangleWidth(i, q);
                    dest.setRectangleWidth(width, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    x = src.getRectangleX(i, q);
                    dest.setRectangleX(x, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    y = src.getRectangleY(i, q);
                    dest.setRectangleY(y, i, q);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
            int annotationRefCount = 0;
            try {
                annotationRefCount = src.getROIAnnotationRefCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int q = 0; q < annotationRefCount; ++q) {
                try {
                    String annotationRef = src.getROIAnnotationRef(i, q);
                    dest.setROIAnnotationRef(annotationRef, i, q);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
    }

    private static void convertScreens(MetadataRetrieve src, MetadataStore dest) {
        int screenCount = 0;
        try {
            screenCount = src.getScreenCount();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        for (int i = 0; i < screenCount; ++i) {
            try {
                String id = src.getScreenID(i);
                dest.setScreenID(id, i);
            }
            catch (NullPointerException e) {
                continue;
            }
            try {
                String description = src.getScreenDescription(i);
                dest.setScreenDescription(description, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String name = src.getScreenName(i);
                if (name == null) {
                    name = "";
                }
                dest.setScreenName(name, i);
            }
            catch (NullPointerException e) {
                dest.setScreenName("", i);
            }
            try {
                String protocolDescription = src.getScreenProtocolDescription(i);
                dest.setScreenProtocolDescription(protocolDescription, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String protocolIdentifier = src.getScreenProtocolIdentifier(i);
                dest.setScreenProtocolIdentifier(protocolIdentifier, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String reagentSetDescription = src.getScreenReagentSetDescription(i);
                dest.setScreenReagentSetDescription(reagentSetDescription, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String reagentSetIdentifier = src.getScreenReagentSetIdentifier(i);
                dest.setScreenReagentSetIdentifier(reagentSetIdentifier, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String type = src.getScreenType(i);
                dest.setScreenType(type, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            int plateRefCount = 0;
            try {
                plateRefCount = src.getPlateRefCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int q = 0; q < plateRefCount; ++q) {
                try {
                    String plateRef = src.getScreenPlateRef(i, q);
                    dest.setScreenPlateRef(plateRef, i, q);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
            int annotationRefCount = 0;
            try {
                annotationRefCount = src.getScreenAnnotationRefCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int q = 0; q < annotationRefCount; ++q) {
                try {
                    String annotationRef = src.getScreenAnnotationRef(i, q);
                    dest.setScreenAnnotationRef(annotationRef, i, q);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
            int reagentCount = 0;
            try {
                reagentCount = src.getReagentCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int q = 0; q < reagentCount; ++q) {
                try {
                    String reagentID = src.getReagentID(i, q);
                    dest.setReagentID(reagentID, i, q);
                }
                catch (NullPointerException e) {
                    continue;
                }
                try {
                    String reagentDescription = src.getReagentDescription(i, q);
                    dest.setReagentDescription(reagentDescription, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String reagentName = src.getReagentName(i, q);
                    dest.setReagentName(reagentName, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String reagentIdentifier = src.getReagentReagentIdentifier(i, q);
                    dest.setReagentReagentIdentifier(reagentIdentifier, i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                int reagentAnnotationRefCount = 0;
                try {
                    reagentAnnotationRefCount = src.getReagentAnnotationRefCount(i, q);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                for (int r = 0; r < reagentAnnotationRefCount; ++r) {
                    try {
                        String reagentAnnotationRef = src.getReagentAnnotationRef(i, q, r);
                        dest.setReagentAnnotationRef(reagentAnnotationRef, i, q, r);
                        continue;
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static void convertTagAnnotations(MetadataRetrieve src, MetadataStore dest) {
        int tagAnnotationCount = 0;
        try {
            tagAnnotationCount = src.getTagAnnotationCount();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        for (int i = 0; i < tagAnnotationCount; ++i) {
            try {
                String id = src.getTagAnnotationID(i);
                dest.setTagAnnotationID(id, i);
            }
            catch (NullPointerException e) {
                continue;
            }
            try {
                String description = src.getTagAnnotationDescription(i);
                dest.setTagAnnotationDescription(description, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String namespace = src.getTagAnnotationNamespace(i);
                dest.setTagAnnotationNamespace(namespace, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String value = src.getTagAnnotationValue(i);
                dest.setTagAnnotationValue(value, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            int annotationRefCount = 0;
            try {
                annotationRefCount = src.getTagAnnotationAnnotationCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int a = 0; a < annotationRefCount; ++a) {
                try {
                    String id = src.getTagAnnotationAnnotationRef(i, a);
                    dest.setTagAnnotationAnnotationRef(id, i, a);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
    }

    private static void convertTermAnnotations(MetadataRetrieve src, MetadataStore dest) {
        int termAnnotationCount = 0;
        try {
            termAnnotationCount = src.getTermAnnotationCount();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        for (int i = 0; i < termAnnotationCount; ++i) {
            try {
                String id = src.getTermAnnotationID(i);
                dest.setTermAnnotationID(id, i);
            }
            catch (NullPointerException e) {
                continue;
            }
            try {
                String description = src.getTermAnnotationDescription(i);
                dest.setTermAnnotationDescription(description, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String namespace = src.getTermAnnotationNamespace(i);
                dest.setTermAnnotationNamespace(namespace, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String value = src.getTermAnnotationValue(i);
                dest.setTermAnnotationValue(value, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            int annotationRefCount = 0;
            try {
                annotationRefCount = src.getTermAnnotationAnnotationCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int a = 0; a < annotationRefCount; ++a) {
                try {
                    String id = src.getTermAnnotationAnnotationRef(i, a);
                    dest.setTermAnnotationAnnotationRef(id, i, a);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
    }

    private static void convertTimestampAnnotations(MetadataRetrieve src, MetadataStore dest) {
        int timestampAnnotationCount = 0;
        try {
            timestampAnnotationCount = src.getTimestampAnnotationCount();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        for (int i = 0; i < timestampAnnotationCount; ++i) {
            try {
                String id = src.getTimestampAnnotationID(i);
                dest.setTimestampAnnotationID(id, i);
            }
            catch (NullPointerException e) {
                continue;
            }
            try {
                String description = src.getTimestampAnnotationDescription(i);
                dest.setTimestampAnnotationDescription(description, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String namespace = src.getTimestampAnnotationNamespace(i);
                dest.setTimestampAnnotationNamespace(namespace, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                Timestamp value = src.getTimestampAnnotationValue(i);
                dest.setTimestampAnnotationValue(value, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            int annotationRefCount = 0;
            try {
                annotationRefCount = src.getTimestampAnnotationAnnotationCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int a = 0; a < annotationRefCount; ++a) {
                try {
                    String id = src.getTimestampAnnotationAnnotationRef(i, a);
                    dest.setTimestampAnnotationAnnotationRef(id, i, a);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
    }

    private static void convertXMLAnnotations(MetadataRetrieve src, MetadataStore dest) {
        int xmlAnnotationCount = 0;
        try {
            xmlAnnotationCount = src.getXMLAnnotationCount();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        for (int i = 0; i < xmlAnnotationCount; ++i) {
            try {
                String id = src.getXMLAnnotationID(i);
                dest.setXMLAnnotationID(id, i);
            }
            catch (NullPointerException e) {
                continue;
            }
            try {
                String description = src.getXMLAnnotationDescription(i);
                dest.setXMLAnnotationDescription(description, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String namespace = src.getXMLAnnotationNamespace(i);
                dest.setXMLAnnotationNamespace(namespace, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                String value = src.getXMLAnnotationValue(i);
                dest.setXMLAnnotationValue(value, i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            int annotationRefCount = 0;
            try {
                annotationRefCount = src.getXMLAnnotationAnnotationCount(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int a = 0; a < annotationRefCount; ++a) {
                try {
                    String id = src.getXMLAnnotationAnnotationRef(i, a);
                    dest.setXMLAnnotationAnnotationRef(id, i, a);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
    }

    private static void convertLightSources(MetadataRetrieve src, MetadataStore dest, int instrumentIndex) {
        int lightSourceCount = 0;
        try {
            lightSourceCount = src.getLightSourceCount(instrumentIndex);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        for (int lightSource = 0; lightSource < lightSourceCount; ++lightSource) {
            String serialNumber;
            Double power;
            String model;
            String manufacturer;
            String lotNumber;
            block106: {
                String id;
                String type = src.getLightSourceType(instrumentIndex, lightSource);
                if (type.equals("Arc")) {
                    block103: {
                        try {
                            id = src.getArcID(instrumentIndex, lightSource);
                            if (id == null) break block103;
                            dest.setArcID(id, instrumentIndex, lightSource);
                        }
                        catch (NullPointerException e) {
                            continue;
                        }
                    }
                    try {
                        lotNumber = src.getArcLotNumber(instrumentIndex, lightSource);
                        if (lotNumber != null) {
                            dest.setArcLotNumber(lotNumber, instrumentIndex, lightSource);
                        }
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        manufacturer = src.getArcManufacturer(instrumentIndex, lightSource);
                        if (manufacturer != null) {
                            dest.setArcManufacturer(manufacturer, instrumentIndex, lightSource);
                        }
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        model = src.getArcModel(instrumentIndex, lightSource);
                        if (model != null) {
                            dest.setArcModel(model, instrumentIndex, lightSource);
                        }
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        power = src.getArcPower(instrumentIndex, lightSource);
                        if (power != null) {
                            dest.setArcPower(power, instrumentIndex, lightSource);
                        }
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        serialNumber = src.getArcSerialNumber(instrumentIndex, lightSource);
                        if (serialNumber != null) {
                            dest.setArcSerialNumber(serialNumber, instrumentIndex, lightSource);
                        }
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        ArcType arcType = src.getArcType(instrumentIndex, lightSource);
                        if (arcType == null) continue;
                        dest.setArcType(arcType, instrumentIndex, lightSource);
                    }
                    catch (NullPointerException e) {}
                    continue;
                }
                if (type.equals("Filament")) {
                    block104: {
                        try {
                            id = src.getFilamentID(instrumentIndex, lightSource);
                            if (id == null) break block104;
                            dest.setFilamentID(id, instrumentIndex, lightSource);
                        }
                        catch (NullPointerException e) {
                            continue;
                        }
                    }
                    try {
                        lotNumber = src.getFilamentLotNumber(instrumentIndex, lightSource);
                        if (lotNumber != null) {
                            dest.setFilamentLotNumber(lotNumber, instrumentIndex, lightSource);
                        }
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        manufacturer = src.getFilamentManufacturer(instrumentIndex, lightSource);
                        if (manufacturer != null) {
                            dest.setFilamentManufacturer(manufacturer, instrumentIndex, lightSource);
                        }
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        model = src.getFilamentModel(instrumentIndex, lightSource);
                        if (model != null) {
                            dest.setFilamentModel(model, instrumentIndex, lightSource);
                        }
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        power = src.getFilamentPower(instrumentIndex, lightSource);
                        if (power != null) {
                            dest.setFilamentPower(power, instrumentIndex, lightSource);
                        }
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        serialNumber = src.getFilamentSerialNumber(instrumentIndex, lightSource);
                        if (serialNumber != null) {
                            dest.setFilamentSerialNumber(serialNumber, instrumentIndex, lightSource);
                        }
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        FilamentType filamentType = src.getFilamentType(instrumentIndex, lightSource);
                        if (filamentType == null) continue;
                        dest.setFilamentType(filamentType, instrumentIndex, lightSource);
                    }
                    catch (NullPointerException e) {}
                    continue;
                }
                if (type.equals("Laser")) {
                    block105: {
                        try {
                            id = src.getLaserID(instrumentIndex, lightSource);
                            if (id == null) break block105;
                            dest.setLaserID(id, instrumentIndex, lightSource);
                        }
                        catch (NullPointerException e) {
                            continue;
                        }
                    }
                    try {
                        lotNumber = src.getLaserLotNumber(instrumentIndex, lightSource);
                        if (lotNumber != null) {
                            dest.setLaserLotNumber(lotNumber, instrumentIndex, lightSource);
                        }
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        manufacturer = src.getLaserManufacturer(instrumentIndex, lightSource);
                        if (manufacturer != null) {
                            dest.setLaserManufacturer(manufacturer, instrumentIndex, lightSource);
                        }
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        model = src.getLaserModel(instrumentIndex, lightSource);
                        if (model != null) {
                            dest.setLaserModel(model, instrumentIndex, lightSource);
                        }
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        power = src.getLaserPower(instrumentIndex, lightSource);
                        if (power != null) {
                            dest.setLaserPower(power, instrumentIndex, lightSource);
                        }
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        serialNumber = src.getLaserSerialNumber(instrumentIndex, lightSource);
                        if (serialNumber != null) {
                            dest.setLaserSerialNumber(serialNumber, instrumentIndex, lightSource);
                        }
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        LaserType laserType = src.getLaserType(instrumentIndex, lightSource);
                        if (laserType != null) {
                            dest.setLaserType(laserType, instrumentIndex, lightSource);
                        }
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        PositiveInteger frequencyMultiplication = src.getLaserFrequencyMultiplication(instrumentIndex, lightSource);
                        if (frequencyMultiplication != null) {
                            dest.setLaserFrequencyMultiplication(frequencyMultiplication, instrumentIndex, lightSource);
                        }
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        LaserMedium medium = src.getLaserLaserMedium(instrumentIndex, lightSource);
                        if (medium != null) {
                            dest.setLaserLaserMedium(medium, instrumentIndex, lightSource);
                        }
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        Boolean pockelCell = src.getLaserPockelCell(instrumentIndex, lightSource);
                        if (pockelCell != null) {
                            dest.setLaserPockelCell(pockelCell, instrumentIndex, lightSource);
                        }
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        Pulse pulse = src.getLaserPulse(instrumentIndex, lightSource);
                        if (pulse != null) {
                            dest.setLaserPulse(pulse, instrumentIndex, lightSource);
                        }
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        String pump = src.getLaserPump(instrumentIndex, lightSource);
                        if (pump != null) {
                            dest.setLaserPump(pump, instrumentIndex, lightSource);
                        }
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        Double repetitionRate = src.getLaserRepetitionRate(instrumentIndex, lightSource);
                        if (repetitionRate != null) {
                            dest.setLaserRepetitionRate(repetitionRate, instrumentIndex, lightSource);
                        }
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        Boolean tuneable = src.getLaserTuneable(instrumentIndex, lightSource);
                        if (tuneable != null) {
                            dest.setLaserTuneable(tuneable, instrumentIndex, lightSource);
                        }
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        PositiveInteger wavelength = src.getLaserWavelength(instrumentIndex, lightSource);
                        if (wavelength == null) continue;
                        dest.setLaserWavelength(wavelength, instrumentIndex, lightSource);
                    }
                    catch (NullPointerException e) {}
                    continue;
                }
                if (!type.equals("LightEmittingDiode")) continue;
                try {
                    id = src.getLightEmittingDiodeID(instrumentIndex, lightSource);
                    if (id == null) break block106;
                    dest.setLightEmittingDiodeID(id, instrumentIndex, lightSource);
                }
                catch (NullPointerException e) {
                    continue;
                }
            }
            try {
                lotNumber = src.getLightEmittingDiodeLotNumber(instrumentIndex, lightSource);
                if (lotNumber != null) {
                    dest.setLightEmittingDiodeLotNumber(lotNumber, instrumentIndex, lightSource);
                }
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                manufacturer = src.getLightEmittingDiodeManufacturer(instrumentIndex, lightSource);
                if (manufacturer != null) {
                    dest.setLightEmittingDiodeManufacturer(manufacturer, instrumentIndex, lightSource);
                }
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                model = src.getLightEmittingDiodeModel(instrumentIndex, lightSource);
                if (model != null) {
                    dest.setLightEmittingDiodeModel(model, instrumentIndex, lightSource);
                }
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                power = src.getLightEmittingDiodePower(instrumentIndex, lightSource);
                if (power != null) {
                    dest.setLightEmittingDiodePower(power, instrumentIndex, lightSource);
                }
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                serialNumber = src.getLightEmittingDiodeSerialNumber(instrumentIndex, lightSource);
                if (serialNumber == null) continue;
                dest.setLightEmittingDiodeSerialNumber(serialNumber, instrumentIndex, lightSource);
                continue;
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
    }
}

