/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import loci.formats.FormatException;
import loci.formats.FormatWriter;
import loci.formats.gui.AWTImageTools;
import loci.formats.meta.MetadataRetrieve;

public abstract class ImageIOWriter
extends FormatWriter {
    protected String kind;

    public ImageIOWriter(String format, String suffix, String kind) {
        super(format, suffix);
        this.kind = kind;
    }

    public ImageIOWriter(String format, String[] suffixes, String kind) {
        super(format, suffixes);
        this.kind = kind;
    }

    @Override
    public void saveBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        this.checkParams(no, buf, x, y, w, h);
        MetadataRetrieve meta = this.getMetadataRetrieve();
        BufferedImage image = AWTImageTools.makeImage(buf, this.interleaved, meta, this.series);
        this.savePlane(no, image, x, y, w, h);
    }

    @Override
    public void savePlane(int no, Object plane, int x, int y, int w, int h) throws FormatException, IOException {
        if (!(plane instanceof Image)) {
            throw new IllegalArgumentException("Object to save must be a java.awt.Image");
        }
        if (!this.isFullPlane(x, y, w, h)) {
            throw new FormatException("ImageIOWriter does not support writing tiles");
        }
        BufferedImage img = AWTImageTools.makeBuffered((Image)plane, this.cm);
        ImageIO.write((RenderedImage)img, this.kind, this.out);
    }

    @Override
    public int[] getPixelTypes(String codec) {
        return new int[]{1, 3};
    }

    @Override
    public Class<?> getNativeDataType() {
        return Image.class;
    }
}

