/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.in;

import ij.ImageJ;
import ij.ImagePlus;
import java.io.IOException;
import loci.formats.FormatException;
import loci.plugins.BF;
import loci.plugins.LociImporter;
import loci.plugins.in.DisplayHandler;
import loci.plugins.in.ImagePlusReader;
import loci.plugins.in.ImportProcess;
import loci.plugins.in.ImporterOptions;
import loci.plugins.in.ImporterPrompter;
import loci.plugins.util.WindowTools;

public class Importer {
    private LociImporter plugin;

    public Importer(LociImporter plugin) {
        this.plugin = plugin;
    }

    public void run(String arg) {
        ImporterOptions options = null;
        try {
            BF.debug("parse core options");
            options = this.parseOptions(arg);
            if (this.plugin.canceled) {
                return;
            }
            ImportProcess process = new ImportProcess(options);
            BF.debug("display option dialogs");
            this.showDialogs(process);
            if (this.plugin.canceled) {
                return;
            }
            BF.debug("display metadata");
            DisplayHandler displayHandler = new DisplayHandler(process);
            displayHandler.displayOriginalMetadata();
            displayHandler.displayOMEXML();
            BF.debug("read pixel data");
            ImagePlusReader reader = new ImagePlusReader(process);
            ImagePlus[] imps = this.readPixels(reader, options, displayHandler);
            BF.debug("display pixels");
            displayHandler.displayImages(imps);
            BF.debug("display ROIs");
            displayHandler.displayROIs(imps);
            BF.debug("finish");
            this.finish(process);
        }
        catch (FormatException exc) {
            boolean quiet = options == null ? false : options.isQuiet();
            WindowTools.reportException(exc, quiet, "Sorry, there was a problem during import.");
        }
        catch (IOException exc) {
            boolean quiet = options == null ? false : options.isQuiet();
            WindowTools.reportException(exc, quiet, "Sorry, there was an I/O problem during import.");
        }
    }

    public ImporterOptions parseOptions(String arg) throws IOException {
        ImporterOptions options = new ImporterOptions();
        options.loadOptions();
        options.parseArg(arg);
        options.checkObsoleteOptions();
        return options;
    }

    public void showDialogs(ImportProcess process) throws FormatException, IOException {
        new ImporterPrompter(process);
        process.execute();
        if (process.wasCanceled()) {
            this.plugin.canceled = true;
        }
    }

    public ImagePlus[] readPixels(ImagePlusReader reader, ImporterOptions options, DisplayHandler displayHandler) throws FormatException, IOException {
        if (options.isViewNone()) {
            return null;
        }
        if (!options.isQuiet()) {
            reader.addStatusListener(displayHandler);
        }
        ImagePlus[] imps = reader.openImagePlus();
        return imps;
    }

    public void finish(ImportProcess process) throws IOException {
        if (!process.getOptions().isVirtual()) {
            process.getReader().close();
        }
        this.plugin.success = true;
    }

    public static void main(String[] args) {
        new ImageJ(null);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(args[i]);
        }
        new LociImporter().run(sb.toString());
    }
}

