/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.in;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import ij.Macro;
import ij.gui.GenericDialog;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JPanel;
import loci.formats.gui.BufferedImageReader;
import loci.plugins.in.ImportProcess;
import loci.plugins.in.ImporterDialog;
import loci.plugins.in.ThumbLoader;
import loci.plugins.util.WindowTools;

public class SeriesDialog
extends ImporterDialog
implements ActionListener {
    public static final int MAX_COMPONENTS = 256;
    public static final int MAX_SERIES_THUMBS = 200;
    public static final int MAX_SERIES_TOGGLES = 200;
    private BufferedImageReader thumbReader;
    private Panel[] p;
    private Checkbox[] boxes;

    public SeriesDialog(ImportProcess process) {
        super(process);
    }

    @Override
    protected boolean needPrompt() {
        return !this.process.isWindowless() && this.process.getSeriesCount() > 1 && !this.options.openAllSeries() && !this.options.isViewNone();
    }

    @Override
    protected GenericDialog constructDialog() {
        int seriesCount = this.process.getSeriesCount();
        if (seriesCount < 200) {
            this.thumbReader = new BufferedImageReader(this.process.getReader());
            this.p = new Panel[seriesCount];
            for (int i = 0; i < seriesCount; ++i) {
                this.thumbReader.setSeries(i);
                int sx = this.thumbReader.getThumbSizeX() + 10;
                int sy = this.thumbReader.getThumbSizeY();
                this.p[i] = new Panel();
                this.p[i].add(Box.createRigidArea(new Dimension(sx, sy)));
                if (!this.options.isForceThumbnails()) continue;
                ThumbLoader.loadThumb(this.thumbReader, i, this.p[i], this.options.isQuiet());
            }
        }
        GenericDialog gd = new GenericDialog("Bio-Formats Series Options");
        if (seriesCount < 200) {
            int nGroups = (seriesCount + 256 - 1) / 256;
            int nextSeries = 0;
            for (int i = 0; i < nGroups; ++i) {
                int nRows = Math.min(256, seriesCount - nextSeries);
                String[] labels = new String[nRows];
                boolean[] defaultValues = new boolean[nRows];
                for (int row = 0; row < nRows; ++row) {
                    labels[row] = this.process.getSeriesLabel(nextSeries);
                    defaultValues[row] = this.options.isSeriesOn(nextSeries);
                    ++nextSeries;
                }
                gd.addCheckboxGroup(nRows, 1, labels, defaultValues);
            }
            this.boxes = WindowTools.getCheckboxes(gd).toArray(new Checkbox[0]);
            this.rebuildDialog(gd, nGroups);
        } else {
            gd.addMessage("Please specify the image series you wish to import.\nUse commas to list multiple series. You can also use\na dash to represent a range of series. For example,\nto import series 1, 3, 4, 5, 7, 8, 9, 12, 15 & 16,\nyou could write: 1, 3-5, 7-9, 12, 15-16\n \nThere are " + seriesCount + " total series.");
            gd.addStringField("Series_list: ", "1");
        }
        return gd;
    }

    @Override
    protected boolean displayDialog(GenericDialog gd) {
        ThumbLoader loader = null;
        if (this.thumbReader != null && !this.options.isForceThumbnails()) {
            loader = new ThumbLoader(this.thumbReader, this.p, (Dialog)gd);
        }
        gd.showDialog();
        if (loader != null) {
            loader.stop();
        }
        return !gd.wasCanceled();
    }

    @Override
    protected boolean harvestResults(GenericDialog gd) {
        int i;
        String macroSeriesList;
        int seriesCount = this.process.getSeriesCount();
        this.options.clearSeries();
        String macroOptions = Macro.getOptions();
        String string = macroSeriesList = macroOptions == null ? null : Macro.getValue((String)macroOptions, (String)"series_list", null);
        if (macroSeriesList != null) {
            this.process.setSeriesList(macroSeriesList);
        }
        if (seriesCount < 200) {
            for (i = 0; i < seriesCount; ++i) {
                boolean on = gd.getNextBoolean();
                if (!on) continue;
                this.options.setSeriesOn(i, on);
            }
        } else {
            String seriesList = gd.getNextString();
            this.process.setSeriesList(seriesList);
        }
        if (macroOptions != null) {
            for (i = 0; i < seriesCount; ++i) {
                String seriesKey = "series_" + (i + 1);
                boolean on = this.options.checkKey(macroOptions, seriesKey);
                if (!on) continue;
                this.options.setSeriesOn(i, on);
            }
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if ("select".equals(cmd)) {
            for (int i = 0; i < this.boxes.length; ++i) {
                this.boxes[i].setState(true);
            }
            this.updateIfGlitched();
        } else if ("deselect".equals(cmd)) {
            for (int i = 0; i < this.boxes.length; ++i) {
                this.boxes[i].setState(false);
            }
            this.updateIfGlitched();
        }
    }

    private void updateIfGlitched() {
        if (IS_GLITCHED) {
            this.sleep(200L);
            for (int i = 0; i < this.boxes.length; ++i) {
                this.boxes[i].repaint();
            }
        }
    }

    private void rebuildDialog(GenericDialog gd, int buttonRow) {
        String cols = this.p == null ? "pref" : "pref, 3dlu, pref";
        StringBuilder sb = new StringBuilder("pref");
        for (int s = 1; s < this.boxes.length; ++s) {
            sb.append(", 3dlu, pref");
        }
        String rows = sb.toString();
        PanelBuilder builder = new PanelBuilder(new FormLayout(cols, rows));
        CellConstraints cc = new CellConstraints();
        int row = 1;
        for (int s = 0; s < this.boxes.length; ++s) {
            builder.add((Component)this.boxes[s], cc.xy(1, row));
            if (this.p != null) {
                builder.add((Component)this.p[s], cc.xy(3, row));
            }
            row += 2;
        }
        JPanel masterPanel = builder.getPanel();
        gd.removeAll();
        GridBagLayout gdl = (GridBagLayout)gd.getLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gdl.setConstraints(masterPanel, gbc);
        gd.add((Component)masterPanel);
        WindowTools.addScrollBars((Container)gd);
        gd.setBackground(Color.white);
        Panel buttons = new Panel();
        Button select = new Button("Select All");
        select.setActionCommand("select");
        select.addActionListener(this);
        Button deselect = new Button("Deselect All");
        deselect.setActionCommand("deselect");
        deselect.addActionListener(this);
        buttons.add(select);
        buttons.add(deselect);
        gbc.gridx = 2;
        gbc.gridy = buttonRow;
        gbc.anchor = 13;
        gbc.insets = new Insets(15, 0, 0, 0);
        gdl.setConstraints(buttons, gbc);
        gd.add((Component)buttons);
    }
}

