/*
 * Decompiled with CFR 0.152.
 */
package ome.xml;

import java.io.OutputStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

@Deprecated
public final class DOMUtil {
    public static final TransformerFactory TRANS_FACT = TransformerFactory.newInstance();
    public static final DocumentBuilderFactory DOC_FACT = DocumentBuilderFactory.newInstance();
    public static final SAXParserFactory SAX_FACT = SAXParserFactory.newInstance();

    private DOMUtil() {
    }

    public static void writeXML(OutputStream os, Document doc) throws TransformerException {
        Transformer idTransform = TRANS_FACT.newTransformer();
        DOMSource input = new DOMSource(doc);
        StreamResult output = new StreamResult(os);
        idTransform.transform(input, output);
    }

    public static String getName(Node node) {
        String name = node.getNodeName();
        int colon = name.lastIndexOf(":");
        return colon < 0 ? name : name.substring(colon + 1);
    }

    public static String getNamespace(Node node) {
        String name = node.getNodeName();
        int colon = name.lastIndexOf(":");
        return colon < 0 ? null : name.substring(0, colon);
    }

    public static String getCharacterData(Element el) {
        Text text = DOMUtil.getChildTextNode(el);
        return text == null ? null : text.getData();
    }

    public static void setCharacterData(String data, Element el) {
        Text text = DOMUtil.getChildTextNode(el);
        if (text == null) {
            text = el.getOwnerDocument().createTextNode(data);
            el.appendChild(text);
        } else {
            text.setData(data);
        }
    }

    public static void setCharacterData(Object data, Element el) {
        DOMUtil.setCharacterData(data.toString(), el);
    }

    public static Boolean getBooleanCharacterData(Element el) {
        return DOMUtil.stringToBoolean(DOMUtil.getCharacterData(el));
    }

    public static Double getDoubleCharacterData(Element el) {
        return DOMUtil.stringToDouble(DOMUtil.getCharacterData(el));
    }

    public static Float getFloatCharacterData(Element el) {
        return DOMUtil.stringToFloat(DOMUtil.getCharacterData(el));
    }

    public static Integer getIntegerCharacterData(Element el) {
        return DOMUtil.stringToInteger(DOMUtil.getCharacterData(el));
    }

    public static Long getLongCharacterData(Element el) {
        return DOMUtil.stringToLong(DOMUtil.getCharacterData(el));
    }

    public static Text getChildTextNode(Element el) {
        if (el == null) {
            return null;
        }
        NodeList list = el.getChildNodes();
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = list.item(i);
            if (!(node instanceof Text)) continue;
            return (Text)node;
        }
        return null;
    }

    public static Element getChildElement(String name, Element el) {
        if (name == null || el == null) {
            return null;
        }
        NodeList list = el.getChildNodes();
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element) || !name.equals(DOMUtil.getName(node))) continue;
            return (Element)node;
        }
        return null;
    }

    public static Vector getChildElements(Element el) {
        return DOMUtil.getChildElements(null, el);
    }

    public static Vector getChildElements(String name, Element el) {
        if (el == null) {
            return null;
        }
        Vector<Node> v = new Vector<Node>();
        NodeList list = el.getChildNodes();
        int size = list.getLength();
        String cName = ":" + name;
        for (int i = 0; i < size; ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element)) continue;
            String nodeName = node.getNodeName();
            if (name != null && !nodeName.equals(name) && !nodeName.endsWith(cName)) continue;
            v.add(node);
        }
        return v;
    }

    public static Element getChildElement(String name, Element el, int index) {
        if (el == null) {
            return null;
        }
        NodeList list = el.getChildNodes();
        int size = list.getLength();
        String cName = ":" + name;
        int q = 0;
        for (int i = 0; i < size; ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element)) continue;
            String nodeName = node.getNodeName();
            if (name != null && !nodeName.equals(name) && !nodeName.endsWith(cName)) continue;
            if (q == index) {
                return (Element)node;
            }
            ++q;
        }
        return null;
    }

    public static Element getAncestorElement(String name, Element el) {
        Node parent;
        if (name == null || el == null) {
            return null;
        }
        for (parent = el.getParentNode(); parent != null && !name.equals(DOMUtil.getName(parent)); parent = parent.getParentNode()) {
        }
        if (parent == null || !(parent instanceof Element)) {
            return null;
        }
        return (Element)parent;
    }

    public static Element findElement(String name, Document doc) {
        return DOMUtil.findElement(name, null, null, doc);
    }

    public static Element findElement(String name, String attrName, String attrValue, Document doc) {
        if (name == null) {
            return null;
        }
        NodeList list = doc.getElementsByTagName(name);
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element)) continue;
            Element el = (Element)node;
            if (attrName != null && attrValue != null && !attrValue.equals(DOMUtil.getAttribute(attrName, el))) continue;
            return el;
        }
        return null;
    }

    public static Vector findElementList(String name, Document doc) {
        return DOMUtil.findElementList(name, null, null, doc);
    }

    public static Vector findElementList(String name, String attrName, String attrValue, Document doc) {
        if (name == null) {
            return null;
        }
        Vector<Element> v = new Vector<Element>();
        NodeList list = doc.getElementsByTagName(name);
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element)) continue;
            Element el = (Element)node;
            if (attrName != null && attrValue != null && !attrValue.equals(DOMUtil.getAttribute(attrName, el))) continue;
            v.add(el);
        }
        return v;
    }

    public static Element createChild(Element el, String name) {
        return DOMUtil.createChild(el, name, true);
    }

    public static Element createChild(Element el, String name, boolean attach) {
        Element child = el.getOwnerDocument().createElement(name);
        if (attach) {
            el.appendChild(child);
        }
        return child;
    }

    public static String[] getAttributeNames(Element el) {
        NamedNodeMap map = el.getAttributes();
        int len = map.getLength();
        String[] attrNames = new String[len];
        for (int i = 0; i < len; ++i) {
            Attr attr = (Attr)map.item(i);
            attrNames[i] = attr == null ? null : attr.getName();
        }
        return attrNames;
    }

    public static String[] getAttributeValues(Element el) {
        NamedNodeMap map = el.getAttributes();
        int len = map.getLength();
        String[] attrValues = new String[len];
        for (int i = 0; i < len; ++i) {
            Attr attr = (Attr)map.item(i);
            attrValues[i] = attr == null ? null : attr.getValue();
        }
        return attrValues;
    }

    public static String getAttribute(String name, Element el) {
        if (name == null || el == null) {
            return null;
        }
        if (!el.hasAttribute(name)) {
            return null;
        }
        return el.getAttribute(name);
    }

    public static void setAttribute(String name, String value, Element el) {
        if (name == null || value == null || el == null) {
            return;
        }
        char[] v = value.toCharArray();
        int count = 0;
        for (int i = 0; i < v.length; ++i) {
            if (Character.isISOControl(v[i])) continue;
            ++count;
        }
        if (count < v.length) {
            char[] nv = new char[count];
            count = 0;
            for (int i = 0; i < v.length; ++i) {
                if (Character.isISOControl(v[i])) continue;
                nv[count++] = v[i];
            }
            value = new String(nv);
        }
        el.setAttribute(name, value);
    }

    public static void setAttribute(String name, Object value, Element el) {
        DOMUtil.setAttribute(name, value == null ? null : value.toString(), el);
    }

    public static Boolean getBooleanAttribute(String name, Element el) {
        return DOMUtil.stringToBoolean(DOMUtil.getAttribute(name, el));
    }

    public static Double getDoubleAttribute(String name, Element el) {
        return DOMUtil.stringToDouble(DOMUtil.getAttribute(name, el));
    }

    public static Float getFloatAttribute(String name, Element el) {
        return DOMUtil.stringToFloat(DOMUtil.getAttribute(name, el));
    }

    public static Integer getIntegerAttribute(String name, Element el) {
        return DOMUtil.stringToInteger(DOMUtil.getAttribute(name, el));
    }

    public static Long getLongAttribute(String name, Element el) {
        return DOMUtil.stringToLong(DOMUtil.getAttribute(name, el));
    }

    private static Boolean stringToBoolean(String value) {
        if (value == null) {
            return null;
        }
        if (value.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        return null;
    }

    private static Double stringToDouble(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new Double(value);
        }
        catch (NumberFormatException exc) {
            return null;
        }
    }

    private static Float stringToFloat(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new Float(value);
        }
        catch (NumberFormatException exc) {
            return null;
        }
    }

    private static Integer stringToInteger(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new Integer(value);
        }
        catch (NumberFormatException exc) {
            return null;
        }
    }

    private static Long stringToLong(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new Long(value);
        }
        catch (NumberFormatException exc) {
            return null;
        }
    }
}

