/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Annotation;
import ome.xml.model.AnnotationRef;
import ome.xml.model.Image;
import ome.xml.model.ImageRef;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.PlateAcquisition;
import ome.xml.model.Reference;
import ome.xml.model.Well;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WellSample
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/SPW/2012-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(WellSample.class);
    private NonNegativeInteger index;
    private Double positionX;
    private Double positionY;
    private String id;
    private Timestamp timepoint;
    private Image image;
    private List<Annotation> annotationLinks = new ArrayList<Annotation>();
    private List<PlateAcquisition> plateAcquisitions = new ArrayList<PlateAcquisition>();
    private Well well;

    public WellSample() {
    }

    public WellSample(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"WellSample".equals(tagName)) {
            LOGGER.debug("Expecting node name of WellSample got {}", (Object)tagName);
        }
        if (element.hasAttribute("Index")) {
            this.setIndex(NonNegativeInteger.valueOf(element.getAttribute("Index")));
        }
        if (element.hasAttribute("PositionX")) {
            this.setPositionX(Double.valueOf(element.getAttribute("PositionX")));
        }
        if (element.hasAttribute("PositionY")) {
            this.setPositionY(Double.valueOf(element.getAttribute("PositionY")));
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("WellSample missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if (element.hasAttribute("Timepoint")) {
            this.setTimepoint(Timestamp.valueOf(element.getAttribute("Timepoint")));
        }
        List<Element> ImageRef_nodeList = WellSample.getChildrenByTagName(element, "ImageRef");
        for (Element ImageRef_element : ImageRef_nodeList) {
            ImageRef image_reference = new ImageRef();
            image_reference.setID(ImageRef_element.getAttribute("ID"));
            model.addReference(this, image_reference);
        }
        List<Element> AnnotationRef_nodeList = WellSample.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : AnnotationRef_nodeList) {
            AnnotationRef annotationLinks_reference = new AnnotationRef();
            annotationLinks_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationLinks_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        if (reference instanceof ImageRef) {
            Image o_casted = (Image)o;
            o_casted.linkWellSample(this);
            this.image = o_casted;
            return true;
        }
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            o_casted.linkWellSample(this);
            if (!this.annotationLinks.contains(o_casted)) {
                this.annotationLinks.add(o_casted);
            }
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public NonNegativeInteger getIndex() {
        return this.index;
    }

    public void setIndex(NonNegativeInteger index) {
        this.index = index;
    }

    public Double getPositionX() {
        return this.positionX;
    }

    public void setPositionX(Double positionX) {
        this.positionX = positionX;
    }

    public Double getPositionY() {
        return this.positionY;
    }

    public void setPositionY(Double positionY) {
        this.positionY = positionY;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public Timestamp getTimepoint() {
        return this.timepoint;
    }

    public void setTimepoint(Timestamp timepoint) {
        this.timepoint = timepoint;
    }

    public Image getLinkedImage() {
        return this.image;
    }

    public void linkImage(Image o) {
        this.image = o;
    }

    public void unlinkImage(Image o) {
        if (this.image == o) {
            this.image = null;
        }
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationLinks.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationLinks);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationLinks.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationLinks.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        o.linkWellSample(this);
        if (!this.annotationLinks.contains(o)) {
            return this.annotationLinks.add(o);
        }
        return false;
    }

    public boolean unlinkAnnotation(Annotation o) {
        o.unlinkWellSample(this);
        return this.annotationLinks.remove(o);
    }

    public int sizeOfLinkedPlateAcquisitionList() {
        return this.plateAcquisitions.size();
    }

    public List<PlateAcquisition> copyLinkedPlateAcquisitionList() {
        return new ArrayList<PlateAcquisition>(this.plateAcquisitions);
    }

    public PlateAcquisition getLinkedPlateAcquisition(int index) {
        return this.plateAcquisitions.get(index);
    }

    public PlateAcquisition setLinkedPlateAcquisition(int index, PlateAcquisition o) {
        return this.plateAcquisitions.set(index, o);
    }

    public boolean linkPlateAcquisition(PlateAcquisition o) {
        if (!this.plateAcquisitions.contains(o)) {
            return this.plateAcquisitions.add(o);
        }
        return false;
    }

    public boolean unlinkPlateAcquisition(PlateAcquisition o) {
        return this.plateAcquisitions.remove(o);
    }

    public Well getWell() {
        return this.well;
    }

    public void setWell(Well well_BackReference) {
        this.well = well_BackReference;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element WellSample_element) {
        if (WellSample_element == null) {
            WellSample_element = document.createElementNS(NAMESPACE, "WellSample");
        }
        if (this.index != null) {
            WellSample_element.setAttribute("Index", this.index.toString());
        }
        if (this.positionX != null) {
            WellSample_element.setAttribute("PositionX", this.positionX.toString());
        }
        if (this.positionY != null) {
            WellSample_element.setAttribute("PositionY", this.positionY.toString());
        }
        if (this.id != null) {
            WellSample_element.setAttribute("ID", this.id.toString());
        }
        if (this.timepoint != null) {
            WellSample_element.setAttribute("Timepoint", this.timepoint.toString());
        }
        if (this.image != null) {
            ImageRef o = new ImageRef();
            o.setID(this.image.getID());
            WellSample_element.appendChild(o.asXMLElement(document));
        }
        if (this.annotationLinks != null) {
            for (Annotation annotationLinks_value : this.annotationLinks) {
                AnnotationRef o = new AnnotationRef();
                o.setID(annotationLinks_value.getID());
                WellSample_element.appendChild(o.asXMLElement(document));
            }
        }
        if (this.plateAcquisitions != null) {
            // empty if block
        }
        if (this.well != null) {
            // empty if block
        }
        return super.asXMLElement(document, WellSample_element);
    }
}

