/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums;

import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;

public enum ArcType implements Enumeration
{
    HG("Hg"),
    XE("Xe"),
    HGXE("HgXe"),
    OTHER("Other");

    private final String value;

    private ArcType(String value) {
        this.value = value;
    }

    public static ArcType fromString(String value) throws EnumerationException {
        if ("Hg".equals(value)) {
            return HG;
        }
        if ("Xe".equals(value)) {
            return XE;
        }
        if ("HgXe".equals(value)) {
            return HGXE;
        }
        if ("Other".equals(value)) {
            return OTHER;
        }
        String s = String.format("%s not a supported value of %s", value, ArcType.class);
        throw new EnumerationException(s);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }
}

