/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums;

import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;

public enum MicroscopeType implements Enumeration
{
    UPRIGHT("Upright"),
    INVERTED("Inverted"),
    DISSECTION("Dissection"),
    ELECTROPHYSIOLOGY("Electrophysiology"),
    OTHER("Other");

    private final String value;

    private MicroscopeType(String value) {
        this.value = value;
    }

    public static MicroscopeType fromString(String value) throws EnumerationException {
        if ("Upright".equals(value)) {
            return UPRIGHT;
        }
        if ("Inverted".equals(value)) {
            return INVERTED;
        }
        if ("Dissection".equals(value)) {
            return DISSECTION;
        }
        if ("Electrophysiology".equals(value)) {
            return ELECTROPHYSIOLOGY;
        }
        if ("Other".equals(value)) {
            return OTHER;
        }
        String s = String.format("%s not a supported value of %s", value, MicroscopeType.class);
        throw new EnumerationException(s);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }
}

