/*
 * Decompiled with CFR 0.152.
 */
package thredds.wcs;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public class GetCoverageRequest {
    private String coverage;
    private String time;
    private String vertical;
    private Format format;
    private LatLonRect bbox;

    public GetCoverageRequest(String coverage, String bbox, String time, String vertical, String format) {
        this.coverage = coverage == null ? null : coverage.trim();
        this.bbox = this.parseBB(bbox);
        this.time = time == null ? null : time.trim();
        this.vertical = vertical == null ? null : vertical.trim();
        this.format = Format.getType(format);
    }

    public String getCoverage() {
        return this.coverage;
    }

    public LatLonRect getBoundingBox() {
        return this.bbox;
    }

    public String getTime() {
        return this.time;
    }

    public String getVertical() {
        return this.vertical;
    }

    public Format getFormat() {
        return this.format;
    }

    private LatLonRect parseBB(String bbox) {
        if (bbox == null) {
            return null;
        }
        bbox = bbox.trim();
        StringTokenizer stoker = new StringTokenizer(bbox, ", ");
        double minx = Double.parseDouble(stoker.nextToken());
        double miny = Double.parseDouble(stoker.nextToken());
        double maxx = Double.parseDouble(stoker.nextToken());
        double maxy = Double.parseDouble(stoker.nextToken());
        LatLonPointImpl minll = new LatLonPointImpl(miny, minx);
        LatLonPointImpl maxll = new LatLonPointImpl(maxy, maxx);
        return new LatLonRect(minll, maxll);
    }

    public static class Format {
        private static LinkedHashMap hash = new LinkedHashMap(10);
        public static final Format NONE = new Format("");
        public static final Format GeoTIFF = new Format("GeoTIFF");
        public static final Format GeoTIFFfloat = new Format("GeoTIFFfloat");
        public static final Format NetCDF3 = new Format("NetCDF3");
        private String name;

        public static Collection getAllTypes() {
            return hash.values();
        }

        public static Format getType(String name) {
            if (name == null) {
                return null;
            }
            Format result = (Format)hash.get(name = name.trim());
            if (result != null) {
                return result;
            }
            return null;
        }

        public Format(String s) {
            this.name = s;
            hash.put(s, this);
        }

        public String toString() {
            return this.name;
        }
    }
}

