/*
 * Decompiled with CFR 0.152.
 */
package thredds.wcs;

import java.util.Date;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import thredds.catalog.XMLEntityResolver;
import thredds.wcs.SectionType;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.units.DateFormatter;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public class XMLwriter {
    protected static final Namespace wcsNS = Namespace.getNamespace((String)"http://www.opengis.net/wcs");
    protected static final Namespace xlinkNS = Namespace.getNamespace((String)"xlink", (String)"http://www.w3.org/1999/xlink");
    protected static final Namespace gmlNS = Namespace.getNamespace((String)"gml", (String)"http://www.opengis.net/gml");
    protected static final String wcsLocation = "http://schemas.opengis.net/wcs/1.0.0/wcsCapabilities.xsd";
    protected static final String dcLocation = "http://schemas.opengis.net/wcs/1.0.0/describeCoverage.xsd";
    public static String seqDate;
    private boolean useTimeRange = false;

    public Document makeCapabilities(String serverURL, GridDataset dataset, SectionType section) {
        Element rootElem = new Element("WCS_Capabilities", wcsNS);
        Document doc = new Document(rootElem);
        this.addNamespaces(rootElem, wcsLocation);
        if (section == null) {
            rootElem.addContent((Content)this.makeService(dataset));
            rootElem.addContent((Content)this.makeCapability(serverURL, dataset));
            rootElem.addContent((Content)this.makeContentMetadata(dataset));
        } else if (section == SectionType.Service) {
            rootElem.addContent((Content)this.makeService(dataset));
        } else if (section == SectionType.Capability) {
            rootElem.addContent((Content)this.makeCapability(serverURL, dataset));
        } else if (section == SectionType.ContentMetadata) {
            rootElem.addContent((Content)this.makeContentMetadata(dataset));
        }
        rootElem.setAttribute("updateSequence", seqDate);
        return doc;
    }

    private void addNamespaces(Element rootElem, String location) {
        rootElem.addNamespaceDeclaration(wcsNS);
        rootElem.addNamespaceDeclaration(xlinkNS);
        rootElem.addNamespaceDeclaration(gmlNS);
        rootElem.addNamespaceDeclaration(XMLEntityResolver.xsiNS);
        rootElem.setAttribute("version", "1.0.0");
        rootElem.setAttribute("schemaLocation", wcsNS.getURI() + " " + location, XMLEntityResolver.xsiNS);
    }

    private Element makeService(GridDataset dataset) {
        Element serviceElem = new Element("Service", wcsNS);
        this.addElement(serviceElem, "description", "Experimental THREDDS/WCS server for CDM gridded datasets");
        this.addElement(serviceElem, "name", dataset.getNetcdfFile().getLocation());
        this.addElement(serviceElem, "label", "Experimental THREDDS/WCS for " + dataset.getNetcdfFile().getLocation());
        Element keywords = this.addElement(serviceElem, "keywords", null);
        this.addElement(keywords, "keyword", null);
        this.addElement(serviceElem, "fees", "NONE");
        this.addElement(serviceElem, "accessConstraints", "NONE");
        return serviceElem;
    }

    private Element makeCapability(String serverURL, GridDataset dataset) {
        Element capabilityElem = new Element("Capability", wcsNS);
        Element reqElem = this.addElement(capabilityElem, "Request", null);
        Element capElem = this.addElement(reqElem, "GetCapabilities", null);
        capElem.addContent((Content)this.makeDCP(serverURL));
        Element descElem = this.addElement(reqElem, "DescribeCoverage", null);
        descElem.addContent((Content)this.makeDCP(serverURL));
        Element getElem = this.addElement(reqElem, "GetCoverage", null);
        getElem.addContent((Content)this.makeDCP(serverURL));
        Element exElem = this.addElement(capabilityElem, "Exception", null);
        this.addElement(exElem, "Format", "application/vnd.ogc.se_xml");
        return capabilityElem;
    }

    private Element makeDCP(String link) {
        Element dcpElem = new Element("DCPType", wcsNS);
        Element httpElem = this.addElement(dcpElem, "HTTP", null);
        Element getElem = this.addElement(httpElem, "Get", null);
        Element onlineElem = this.addElement(getElem, "OnlineResource", null);
        onlineElem.setAttribute("href", link, xlinkNS);
        onlineElem.setAttribute("type", "simple", xlinkNS);
        return dcpElem;
    }

    private Element makeContentMetadata(GridDataset dataset) {
        Element contentElem = new Element("ContentMetadata", wcsNS);
        List<GridDatatype> grids = dataset.getGrids();
        for (GridDatatype grid : grids) {
            Element elem = this.makeCoverageOfferingBrief(grid);
            if (null == elem) continue;
            contentElem.addContent((Content)elem);
        }
        return contentElem;
    }

    private Element makeCoverageOfferingBrief(GridDatatype grid) {
        Element briefElem = new Element("CoverageOfferingBrief", wcsNS);
        this.addElement(briefElem, "name", grid.getName());
        this.addElement(briefElem, "label", grid.getDescription());
        GridCoordSystem gcs = grid.getCoordinateSystem();
        if (!gcs.isRegularSpatial()) {
            System.out.println("**Coordinate System not regular for " + grid.getName());
            return null;
        }
        Element llElem = new Element("lonLatEnvelope", wcsNS);
        this.addLonLatEnvelope(llElem, gcs);
        briefElem.addContent((Content)llElem);
        return briefElem;
    }

    private void addLonLatEnvelope(Element elem, GridCoordSystem gcs) {
        elem.setAttribute("srsName", "WGS84(DD)");
        LatLonRect llbb = gcs.getLatLonBoundingBox();
        LatLonPointImpl llpt = llbb.getLowerLeftPoint();
        LatLonPointImpl urpt = llbb.getUpperRightPoint();
        elem.addContent((Content)this.makePos(llpt));
        double lon = llpt.getLongitude() + llbb.getWidth();
        elem.addContent((Content)this.makePos(urpt.getLatitude(), lon));
    }

    public Document makeDescribeCoverage(GridDataset dataset, String[] gridNames) {
        Element rootElem = new Element("CoverageDescription", wcsNS);
        Document doc = new Document(rootElem);
        this.addNamespaces(rootElem, dcLocation);
        if (gridNames == null) {
            List<GridDatatype> grids = dataset.getGrids();
            for (GridDatatype grid : grids) {
                Element elem = this.makeCoverageDescription(grid);
                rootElem.addContent((Content)elem);
            }
        } else {
            for (int i = 0; i < gridNames.length; ++i) {
                GridDatatype grid = dataset.findGridDatatype(gridNames[i]);
                Element elem = this.makeCoverageDescription(grid);
                rootElem.addContent((Content)elem);
            }
        }
        return doc;
    }

    private Element makeCoverageDescription(GridDatatype grid) {
        GridCoordSystem gcs = grid.getCoordinateSystem();
        Element offeringElem = this.makeCoverageOfferingBrief(grid);
        offeringElem.setName("CoverageOffering");
        offeringElem.addContent((Content)this.makeDomainSet(grid));
        offeringElem.addContent((Content)this.makeRangeSet(grid));
        offeringElem.addContent((Content)this.makeSupportedCRS(gcs));
        offeringElem.addContent((Content)this.makeSupportedFormats());
        offeringElem.addContent((Content)this.makeSupportedInterpolations());
        return offeringElem;
    }

    private Element makeDomainSet(GridDatatype grid) {
        Element domainElem = new Element("domainSet", wcsNS);
        domainElem.addContent((Content)this.makeSpatialDomain(grid));
        GridCoordSystem gcs = grid.getCoordinateSystem();
        CoordinateAxis1DTime taxis = gcs.getTimeAxis1D();
        if (null != taxis) {
            Date[] dates = taxis.getTimeDates();
            int n = dates.length;
            if (this.useTimeRange) {
                domainElem.addContent((Content)this.makeTemporalDomainRange(dates[0], dates[n - 1]));
            } else {
                domainElem.addContent((Content)this.makeTemporalDomain(dates));
            }
        }
        return domainElem;
    }

    private Element makePos(LatLonPoint pt) {
        Element posElem = new Element("pos", gmlNS);
        posElem.addContent(pt.getLongitude() + " " + pt.getLatitude());
        return posElem;
    }

    private Element makePos(double lat, double lon) {
        Element posElem = new Element("pos", gmlNS);
        posElem.addContent(lon + " " + lat);
        return posElem;
    }

    public Element makeRangeSet(GridDatatype grid) {
        Element rangeElem = new Element("rangeSet", wcsNS);
        Element RangeElem = this.addElement(rangeElem, "RangeSet", null);
        this.addElement(RangeElem, "name", "RangeSetName");
        this.addElement(RangeElem, "label", "RangeSetLabel");
        GridCoordSystem gcs = grid.getCoordinateSystem();
        CoordinateAxis1D zaxis = gcs.getVerticalAxis();
        if (zaxis != null) {
            Element axisElem = this.addElement(RangeElem, "axisDescription", null);
            Element AxisElem = this.addElement(axisElem, "AxisDescription", null);
            this.addElement(AxisElem, "name", "Vertical");
            this.addElement(AxisElem, "label", zaxis.getName());
            Element valueElem = this.addElement(AxisElem, "values", null);
            int z = 0;
            while ((long)z < zaxis.getSize()) {
                this.addElement(valueElem, "singleValue", zaxis.getCoordName(z).trim());
                ++z;
            }
        }
        if (grid.hasMissingData()) {
            Element nullElem = this.addElement(RangeElem, "nullValues", null);
            this.addElement(nullElem, "singleValue", "NaN");
        }
        return rangeElem;
    }

    private Element makeRectifiedGrid(GridCoordSystem gcs) {
        Element gridElem = new Element("RectifiedGrid", gmlNS);
        CoordinateAxis1D xaxis = (CoordinateAxis1D)gcs.getXHorizAxis();
        CoordinateAxis1D yaxis = (CoordinateAxis1D)gcs.getYHorizAxis();
        CoordinateAxis1D zaxis = gcs.getVerticalAxis();
        int ndim = zaxis != null ? 3 : 2;
        gridElem.setAttribute("dimension", Integer.toString(ndim));
        int[] minValues = new int[ndim];
        int[] maxValues = new int[ndim];
        maxValues[0] = (int)(xaxis.getSize() - 1L);
        maxValues[1] = (int)(yaxis.getSize() - 1L);
        if (zaxis != null) {
            maxValues[2] = (int)(zaxis.getSize() - 1L);
        }
        Element limitsElem = this.addElement(gridElem, "limits", null, gmlNS);
        Element gridEnvelopeElem = this.addElement(limitsElem, "GridEnvelope", null, gmlNS);
        this.addElement(gridEnvelopeElem, "low", this.toString(minValues), gmlNS);
        this.addElement(gridEnvelopeElem, "high", this.toString(maxValues), gmlNS);
        this.addElement(gridElem, "axisName", "x", gmlNS);
        this.addElement(gridElem, "axisName", "y", gmlNS);
        if (zaxis != null) {
            this.addElement(gridElem, "axisName", "z", gmlNS);
        }
        double[] origin = new double[ndim];
        origin[0] = xaxis.getStart();
        origin[1] = yaxis.getStart();
        if (zaxis != null) {
            origin[2] = zaxis.getStart();
        }
        Element originElem = this.addElement(gridElem, "origin", null, gmlNS);
        this.addElement(originElem, "pos", this.toString(origin), gmlNS);
        double[] xoffset = new double[ndim];
        xoffset[0] = xaxis.getIncrement();
        this.addElement(gridElem, "offsetVector", this.toString(xoffset), gmlNS);
        double[] yoffset = new double[ndim];
        yoffset[1] = yaxis.getIncrement();
        this.addElement(gridElem, "offsetVector", this.toString(yoffset), gmlNS);
        if (zaxis != null) {
            double[] zoffset = new double[ndim];
            zoffset[2] = zaxis.getIncrement();
            this.addElement(gridElem, "offsetVector", this.toString(zoffset), gmlNS);
        }
        return gridElem;
    }

    private Element makeSpatialDomain(GridDatatype grid) {
        Element spatialElem = new Element("spatialDomain", wcsNS);
        GridCoordSystem gcs = grid.getCoordinateSystem();
        Element envElem = new Element("Envelope", gmlNS);
        this.addLonLatEnvelope(envElem, gcs);
        spatialElem.addContent((Content)envElem);
        spatialElem.addContent((Content)this.makeRectifiedGrid(gcs));
        return spatialElem;
    }

    private Element makeSupportedCRS(GridCoordSystem gcs) {
        Element elem = new Element("supportedCRSs", wcsNS);
        this.addElement(elem, "requestCRSs", "EPSG:4326");
        this.addElement(elem, "responseCRSs", "EPSG:4326");
        if (gcs.isLatLon()) {
            this.addElement(elem, "nativeCRSs", "EPSG:4326");
        }
        return elem;
    }

    private Element makeSupportedFormats() {
        Element elem = new Element("supportedFormats", wcsNS);
        this.addElement(elem, "formats", "GeoTIFF");
        this.addElement(elem, "formats", "GeoTIFFfloat");
        this.addElement(elem, "formats", "NetCDF3");
        return elem;
    }

    private Element makeSupportedInterpolations() {
        Element elem = new Element("supportedInterpolations", wcsNS);
        this.addElement(elem, "interpolationMethod", "none");
        return elem;
    }

    private Element makeTemporalDomainRange(Date start, Date end) {
        Element temporalElem = new Element("temporalDomain", wcsNS);
        Element timeElem = new Element("timePeriod", wcsNS);
        temporalElem.addContent((Content)timeElem);
        DateFormatter formatter = new DateFormatter();
        this.addElement(timeElem, "beginPosition", formatter.toDateTimeStringISO(start));
        this.addElement(timeElem, "endPosition", formatter.toDateTimeStringISO(end));
        return temporalElem;
    }

    private Element makeTemporalDomain(Date[] dates) {
        Element temporalElem = new Element("temporalDomain", wcsNS);
        DateFormatter formatter = new DateFormatter();
        for (int i = 0; i < dates.length; ++i) {
            this.addElement(temporalElem, "timePosition", formatter.toDateTimeStringISO(dates[i]), gmlNS);
        }
        return temporalElem;
    }

    private Element addElement(Element parent, String name, String value) {
        Element elem = new Element(name, wcsNS);
        if (value != null) {
            elem.addContent(value);
        }
        parent.addContent((Content)elem);
        return elem;
    }

    private Element addElement(Element parent, String name, String value, Namespace ns) {
        Element elem = new Element(name, ns);
        if (value != null) {
            elem.addContent(value);
        }
        parent.addContent((Content)elem);
        return elem;
    }

    private String toString(int[] values) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            int value = values[i];
            buff.append(value);
            buff.append(' ');
        }
        return buff.toString();
    }

    private String toString(double[] values) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            double value = values[i];
            buff.append(value);
            buff.append(' ');
        }
        return buff.toString();
    }

    static {
        DateFormatter formatter = new DateFormatter();
        seqDate = formatter.toDateTimeStringISO(new Date());
    }
}

