/*
 * Decompiled with CFR 0.152.
 */
package thredds.wcs.v1_0_0_Plus;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.wcs.v1_0_0_Plus.WcsException;
import thredds.wcs.v1_0_0_Plus.WcsRequest;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public class GetCapabilities
extends WcsRequest {
    private static Logger log = LoggerFactory.getLogger(GetCapabilities.class);
    protected static final Namespace wcsNS = Namespace.getNamespace((String)"http://www.opengis.net/wcs");
    protected static final Namespace gmlNS = Namespace.getNamespace((String)"gml", (String)"http://www.opengis.net/gml");
    protected static final Namespace xlinkNS = Namespace.getNamespace((String)"xlink", (String)"http://www.w3.org/1999/xlink");
    private URI serverURI;
    private Section section;
    private ServiceInfo serviceInfo;
    private String updateSequence;
    private Document capabilitiesReport;

    public GetCapabilities(WcsRequest.Operation operation, String version, String datasetPath, GridDataset dataset, URI serverURI, Section section, String updateSequence, ServiceInfo serviceInfo) {
        super(operation, version, datasetPath, dataset);
        this.serverURI = serverURI;
        this.section = section;
        this.serviceInfo = serviceInfo;
        this.updateSequence = updateSequence;
        if (this.serverURI == null) {
            throw new IllegalArgumentException("Non-null server URI required.");
        }
        if (this.section == null) {
            throw new IllegalArgumentException("Non-null sections list required (may be empty).");
        }
    }

    String getCurrentUpdateSequence() {
        if (this.updateSequence == null) {
            return null;
        }
        return null;
    }

    public Document getCapabilitiesReport() throws WcsException {
        if (this.capabilitiesReport == null) {
            this.capabilitiesReport = this.generateCapabilities();
        }
        return this.capabilitiesReport;
    }

    public void writeCapabilitiesReport(PrintWriter pw) throws WcsException, IOException {
        XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
        xmlOutputter.output(this.getCapabilitiesReport(), (Writer)pw);
    }

    public Document generateCapabilities() throws WcsException {
        Element rootElem;
        if (this.section.equals((Object)Section.All)) {
            rootElem = new Element("WCS_Capabilities", wcsNS);
            rootElem.addContent((Content)this.generateServiceSection(this.serviceInfo));
            rootElem.addContent((Content)this.generateCapabilitySection());
            rootElem.addContent((Content)this.generateContentMetadataSection());
        } else if (this.section.equals((Object)Section.Service)) {
            rootElem = this.generateServiceSection(this.serviceInfo);
        } else if (this.section.equals((Object)Section.Capability)) {
            rootElem = this.generateCapabilitySection();
        } else if (this.section.equals((Object)Section.ContentMetadata)) {
            rootElem = this.generateContentMetadataSection();
        } else {
            throw new WcsException();
        }
        rootElem.addNamespaceDeclaration(gmlNS);
        rootElem.addNamespaceDeclaration(xlinkNS);
        rootElem.setAttribute("version", this.getVersion());
        if (this.getCurrentUpdateSequence() != null) {
            rootElem.setAttribute("updateSequence", this.getCurrentUpdateSequence());
        }
        return new Document(rootElem);
    }

    public Element generateServiceSection(ServiceInfo serviceInfo) {
        Element serviceElem = new Element("Service", wcsNS);
        if (serviceInfo != null) {
            ResponsibleParty respParty;
            if (serviceInfo.getDescription() != null) {
                serviceElem.addContent((Content)new Element("description", wcsNS).addContent(serviceInfo.getDescription()));
            }
            if (serviceInfo.getName() != null) {
                serviceElem.addContent((Content)new Element("name", wcsNS).addContent(serviceInfo.getName()));
            }
            if (serviceInfo.getLabel() != null) {
                serviceElem.addContent((Content)new Element("label", wcsNS).addContent(serviceInfo.getLabel()));
            }
            if (serviceInfo.getKeywords() != null && serviceInfo.getKeywords().size() > 0) {
                Element keywordsElem = new Element("keywords", wcsNS);
                for (String curKey : serviceInfo.getKeywords()) {
                    keywordsElem.addContent((Content)new Element("keyword", wcsNS).addContent(curKey));
                }
                serviceElem.addContent((Content)keywordsElem);
            }
            if ((respParty = serviceInfo.getResponsibleParty()) != null) {
                Element respPartyElem = new Element("responsibleParty", wcsNS);
                if (respParty.getIndividualName() != null) {
                    respPartyElem.addContent((Content)new Element("individualName", wcsNS).addContent(respParty.getIndividualName()));
                }
                if (respParty.getOrganizationName() != null) {
                    respPartyElem.addContent((Content)new Element("organisationName", wcsNS).addContent(respParty.getOrganizationName()));
                }
                if (respParty.getPositionName() != null) {
                    respPartyElem.addContent((Content)new Element("positionName", wcsNS).addContent(respParty.getPositionName()));
                }
                if (respParty.getContact() != null) {
                    ResponsibleParty.OnlineResource onlineRes;
                    ResponsibleParty.Address contactAddress;
                    Element contactElem = new Element("contactInfo", wcsNS);
                    Element phoneElem = new Element("phone", wcsNS);
                    if (respParty.getContact().getVoicePhone() != null) {
                        for (String curVoicePhone : respParty.getContact().getVoicePhone()) {
                            phoneElem.addContent((Content)new Element("voice", wcsNS).addContent(curVoicePhone));
                        }
                    }
                    if (respParty.getContact().getFaxPhone() != null) {
                        for (String curFaxPhone : respParty.getContact().getFaxPhone()) {
                            phoneElem.addContent((Content)new Element("facsimile", wcsNS).addContent(curFaxPhone));
                        }
                    }
                    if (phoneElem.getContentSize() > 0) {
                        contactElem.addContent((Content)phoneElem);
                    }
                    if ((contactAddress = respParty.getContact().getAddress()) != null) {
                        Element addressElem = new Element("address", wcsNS);
                        if (contactAddress.getDeliveryPoint() != null) {
                            for (String curDP : contactAddress.getDeliveryPoint()) {
                                addressElem.addContent((Content)new Element("deliveryPoint", wcsNS).addContent(curDP));
                            }
                        }
                        if (contactAddress.getCity() != null) {
                            addressElem.addContent((Content)new Element("city", wcsNS).addContent(contactAddress.getCity()));
                        }
                        if (contactAddress.getAdminArea() != null) {
                            addressElem.addContent((Content)new Element("administrativeArea", wcsNS).addContent(contactAddress.getAdminArea()));
                        }
                        if (contactAddress.getPostalCode() != null) {
                            addressElem.addContent((Content)new Element("postalCode", wcsNS).addContent(contactAddress.getPostalCode()));
                        }
                        if (contactAddress.getCountry() != null) {
                            addressElem.addContent((Content)new Element("country", wcsNS).addContent(contactAddress.getCountry()));
                        }
                        if (contactAddress.getEmail() != null) {
                            for (String curEmail : contactAddress.getEmail()) {
                                addressElem.addContent((Content)new Element("electronicMailAddress", wcsNS).addContent(curEmail));
                            }
                        }
                        contactElem.addContent((Content)addressElem);
                    }
                    if ((onlineRes = respParty.getContact().getOnlineResource()) != null) {
                        Element onlineResElem = new Element("onlineResource", wcsNS);
                        onlineResElem.setAttribute("type", "simple");
                        if (onlineRes.getTitle() != null) {
                            onlineResElem.setAttribute("title", onlineRes.getTitle(), xlinkNS);
                        }
                        if (onlineRes.getLink() != null) {
                            onlineResElem.setAttribute("href", onlineRes.getLink().toString(), xlinkNS);
                        }
                        contactElem.addContent((Content)onlineResElem);
                    }
                    respPartyElem.addContent((Content)contactElem);
                }
                serviceElem.addContent((Content)respPartyElem);
            }
        }
        serviceElem.addContent((Content)new Element("fees", wcsNS).addContent("NONE"));
        serviceElem.addContent((Content)new Element("accessConstraints", wcsNS).addContent("NONE"));
        return serviceElem;
    }

    public Element generateCapabilitySection() {
        Element capElem = new Element("Capability", wcsNS);
        Element requestElem = new Element("Request", wcsNS);
        requestElem.addContent((Content)this.genCapabilityOperationElem(WcsRequest.Operation.GetCapabilities.toString()));
        requestElem.addContent((Content)this.genCapabilityOperationElem(WcsRequest.Operation.DescribeCoverage.toString()));
        requestElem.addContent((Content)this.genCapabilityOperationElem(WcsRequest.Operation.GetCoverage.toString()));
        capElem.addContent((Content)requestElem);
        capElem.addContent((Content)new Element("Exception", wcsNS).addContent((Content)new Element("Format", wcsNS).addContent("application/vnd.ogc.se_xml")));
        return capElem;
    }

    private Element genCapabilityOperationElem(String operationAsString) {
        Element getCapOpsElem = new Element(operationAsString, wcsNS);
        getCapOpsElem.addContent((Content)new Element("DCPType", wcsNS).addContent((Content)new Element("HTTP", wcsNS).addContent((Content)new Element("Get", wcsNS).addContent((Content)new Element("OnlineResource", wcsNS).setAttribute("href", this.serverURI.toString(), xlinkNS)))));
        return getCapOpsElem;
    }

    public Element generateContentMetadataSection() {
        Element contMdElem = new Element("ContentMetadata", wcsNS);
        for (GridDatatype curGridDatatype : this.getDataset().getGrids()) {
            contMdElem.addContent((Content)this.genContentOfferingBrief(curGridDatatype));
        }
        return contMdElem;
    }

    public Element genContentOfferingBrief(GridDatatype gridDt) {
        Element briefElem = new Element("ContentOfferingBrief", wcsNS);
        briefElem.addContent((Content)new Element("name", wcsNS).addContent(gridDt.getName()));
        briefElem.addContent((Content)new Element("label", wcsNS).addContent(gridDt.getDescription()));
        GridCoordSystem gcs = gridDt.getCoordinateSystem();
        if (!gcs.isRegularSpatial()) {
            log.warn("genContentOfferingBrief(): Coordinate system not regular for " + gridDt.getName());
            return null;
        }
        briefElem.addContent((Content)this.genLonLatEnvelope(gcs));
        return briefElem;
    }

    private Element genLonLatEnvelope(GridCoordSystem gcs) {
        Element latLonEnvelopeElem = new Element("lonLatEnvelope", wcsNS);
        latLonEnvelopeElem.setAttribute("srsName", "WGS84(DD)");
        LatLonRect llbb = gcs.getLatLonBoundingBox();
        LatLonPointImpl llpt = llbb.getLowerLeftPoint();
        LatLonPointImpl urpt = llbb.getUpperRightPoint();
        latLonEnvelopeElem.addContent((Content)new Element("pos", gmlNS).addContent(llpt.getLongitude() + " " + llpt.getLatitude()));
        double lon = llpt.getLongitude() + llbb.getWidth();
        latLonEnvelopeElem.addContent((Content)new Element("pos", gmlNS).addContent(lon + " " + urpt.getLatitude()));
        return latLonEnvelopeElem;
    }

    public static class ResponsibleParty {
        private String individualName;
        private String organizationName;
        private String positionName;
        private ContactInfo contactInfo;

        public ResponsibleParty(String individualName, String organizationName, String positionName, ContactInfo contactInfo) {
            this.individualName = individualName;
            this.organizationName = organizationName;
            this.positionName = positionName;
            this.contactInfo = contactInfo;
        }

        public String getIndividualName() {
            return this.individualName;
        }

        public String getOrganizationName() {
            return this.organizationName;
        }

        public String getPositionName() {
            return this.positionName;
        }

        public ContactInfo getContact() {
            return this.contactInfo;
        }

        public static class OnlineResource {
            private URI link;
            private String title;

            public OnlineResource(URI link, String title) {
                this.link = link;
                this.title = title;
            }

            public URI getLink() {
                return this.link;
            }

            public String getTitle() {
                return this.title;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Address {
            private List<String> deliveryPoint;
            private String city;
            private String adminArea;
            private String postalCode;
            private String country;
            private List<String> email;

            public Address(List<String> deliveryPoint, String city, String adminArea, String postalCode, String country, List<String> email) {
                this.deliveryPoint = new ArrayList<String>(deliveryPoint);
                this.city = city;
                this.adminArea = adminArea;
                this.postalCode = postalCode;
                this.country = country;
                this.email = new ArrayList<String>(email);
            }

            public List<String> getDeliveryPoint() {
                return Collections.unmodifiableList(this.deliveryPoint);
            }

            public String getCity() {
                return this.city;
            }

            public String getAdminArea() {
                return this.adminArea;
            }

            public String getPostalCode() {
                return this.postalCode;
            }

            public String getCountry() {
                return this.country;
            }

            public List<String> getEmail() {
                return Collections.unmodifiableList(this.email);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class ContactInfo {
            private List<String> voicePhone;
            private List<String> faxPhone;
            private Address address;
            private OnlineResource onlineResource;

            public ContactInfo(List<String> voicePhone, List<String> faxPhone, Address address, OnlineResource onlineResource) {
                this.voicePhone = new ArrayList<String>(voicePhone);
                this.faxPhone = new ArrayList<String>(faxPhone);
                this.address = address;
                this.onlineResource = onlineResource;
            }

            public List<String> getVoicePhone() {
                return Collections.unmodifiableList(this.voicePhone);
            }

            public List<String> getFaxPhone() {
                return Collections.unmodifiableList(this.faxPhone);
            }

            public Address getAddress() {
                return this.address;
            }

            public OnlineResource getOnlineResource() {
                return this.onlineResource;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ServiceInfo {
        private String name;
        private String label;
        private String description;
        private List<String> keywords;
        private ResponsibleParty responsibleParty;
        private String fees;
        private List<String> accessConstraints;

        public ServiceInfo(String name, String label, String description, List<String> keywords, ResponsibleParty responsibleParty, String fees, List<String> accessConstraints) {
            this.name = name;
            this.label = label;
            this.description = description;
            this.keywords = new ArrayList<String>(keywords);
            this.responsibleParty = responsibleParty;
            this.fees = fees;
            this.accessConstraints = new ArrayList<String>(accessConstraints);
        }

        public String getName() {
            return this.name;
        }

        public String getLabel() {
            return this.label;
        }

        public String getDescription() {
            return this.description;
        }

        public List<String> getKeywords() {
            return Collections.unmodifiableList(this.keywords);
        }

        public ResponsibleParty getResponsibleParty() {
            return this.responsibleParty;
        }

        public String getFees() {
            return this.fees;
        }

        public List<String> getAccessConstraints() {
            return Collections.unmodifiableList(this.accessConstraints);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Section {
        All(""),
        Service("WCS_Capabilities/Service"),
        Capability("WCS_Capabilities/Capability"),
        ContentMetadata("WCS_Capabilities/ContentMetadata");

        private final String altId;

        private Section(String altId) {
            this.altId = altId;
        }

        public String toString() {
            return this.altId;
        }

        public static Section getSection(String altId) {
            for (Section curSection : Section.values()) {
                if (!curSection.altId.equals(altId)) continue;
                return curSection;
            }
            throw new IllegalArgumentException("No suce instance <" + altId + ">.");
        }
    }
}

