/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.nc2.NCdump;
import ucar.nc2.NetcdfFile;
import ucar.unidata.util.Parameter;

public class Attribute {
    protected String name;
    protected DataType dataType;
    protected int nelems;
    protected Array values;
    private volatile int hashCode = 0;
    protected Index ima;

    public String getName() {
        return this.name;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public boolean isString() {
        return this.dataType == DataType.STRING;
    }

    public boolean isArray() {
        return this.getLength() > 1;
    }

    public int getLength() {
        return this.nelems;
    }

    public Array getValues() {
        return this.values;
    }

    public String getStringValue() {
        return this.getStringValue(0);
    }

    public String getStringValue(int index) {
        if (!this.isString() || index < 0 || index >= this.nelems) {
            return null;
        }
        return (String)this.values.getObject(this.ima().set0(index));
    }

    public Number getNumericValue() {
        return this.getNumericValue(0);
    }

    public Number getNumericValue(int index) {
        if (this.isString() || index < 0 || index >= this.nelems) {
            return null;
        }
        if (this.dataType == DataType.STRING) {
            try {
                return new Double(this.getStringValue(index));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (this.dataType == DataType.BYTE) {
            return this.values.getByte(this.ima().set0(index));
        }
        if (this.dataType == DataType.SHORT) {
            return this.values.getShort(this.ima().set0(index));
        }
        if (this.dataType == DataType.INT) {
            return this.values.getInt(this.ima().set0(index));
        }
        if (this.dataType == DataType.FLOAT) {
            return Float.valueOf(this.values.getFloat(this.ima().set0(index)));
        }
        if (this.dataType == DataType.DOUBLE) {
            return this.values.getDouble(this.ima().set0(index));
        }
        if (this.dataType == DataType.LONG) {
            return this.values.getLong(this.ima().set0(index));
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        if (!this.name.equals(attribute.name)) {
            return false;
        }
        if (this.nelems != attribute.nelems) {
            return false;
        }
        if (!this.dataType.equals(attribute.dataType)) {
            return false;
        }
        if (this.values != null) {
            for (int i = 0; i < this.getLength(); ++i) {
                int r2;
                int r1 = this.isString() ? this.getStringValue(i).hashCode() : this.getNumericValue(i).hashCode();
                int n = r2 = attribute.isString() ? attribute.getStringValue(i).hashCode() : attribute.getNumericValue(i).hashCode();
                if (r1 == r2) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.getName().hashCode();
            result = 37 * result + this.getDataType().hashCode();
            for (int i = 0; i < this.getLength(); ++i) {
                int h = this.isString() ? this.getStringValue(i).hashCode() : this.getNumericValue(i).hashCode();
                result = 37 * result + h;
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.getName());
        if (this.isString()) {
            buff.append(" = ");
            for (int i = 0; i < this.getLength(); ++i) {
                if (i != 0) {
                    buff.append(", ");
                }
                buff.append("\"").append(NCdump.encodeString(this.getStringValue(i))).append("\"");
            }
        } else {
            buff.append(" = ");
            for (int i = 0; i < this.getLength(); ++i) {
                if (i != 0) {
                    buff.append(", ");
                }
                buff.append(this.getNumericValue(i));
                if (this.dataType == DataType.FLOAT) {
                    buff.append("f");
                    continue;
                }
                if (this.dataType == DataType.SHORT) {
                    buff.append("s");
                    continue;
                }
                if (this.dataType != DataType.BYTE) continue;
                buff.append("b");
            }
        }
        return buff.toString();
    }

    public Attribute(String name, Attribute from) {
        this.name = NetcdfFile.createValidNetcdfObjectName(name);
        this.dataType = from.dataType;
        this.nelems = from.nelems;
        this.values = from.values;
    }

    public Attribute(String name, String val) {
        this.name = NetcdfFile.createValidNetcdfObjectName(name);
        this.setStringValue(val);
    }

    public Attribute(String name, Number val) {
        this.name = NetcdfFile.createValidNetcdfObjectName(name);
        int[] shape = new int[]{1};
        DataType dt = DataType.getType(val.getClass());
        Array vala = Array.factory(dt.getPrimitiveClassType(), shape);
        Index ima = vala.getIndex();
        vala.setDouble(ima.set0(0), val.doubleValue());
        this.setValues(vala);
    }

    public Attribute(String name, Array values) {
        this.name = NetcdfFile.createValidNetcdfObjectName(name);
        this.setValues(values);
    }

    public Attribute(String name, List values) {
        this.name = NetcdfFile.createValidNetcdfObjectName(name);
        int n = values.size();
        Object[] pa = null;
        Class<?> c = values.get(0).getClass();
        if (c == String.class) {
            String[] va;
            pa = va = new String[n];
            for (int i = 0; i < n; ++i) {
                va[i] = (String)values.get(i);
            }
        } else if (c == Integer.class) {
            int[] va = new int[n];
            pa = va;
            for (int i = 0; i < n; ++i) {
                va[i] = (Integer)values.get(i);
            }
        } else if (c == Double.class) {
            double[] va = new double[n];
            pa = va;
            for (int i = 0; i < n; ++i) {
                va[i] = (Double)values.get(i);
            }
        } else if (c == Float.class) {
            float[] va = new float[n];
            pa = va;
            for (int i = 0; i < n; ++i) {
                va[i] = ((Float)values.get(i)).floatValue();
            }
        } else if (c == Short.class) {
            short[] va = new short[n];
            pa = va;
            for (int i = 0; i < n; ++i) {
                va[i] = (Short)values.get(i);
            }
        } else if (c == Byte.class) {
            byte[] va = new byte[n];
            pa = va;
            for (int i = 0; i < n; ++i) {
                va[i] = (Byte)values.get(i);
            }
        } else if (c == Long.class) {
            long[] va = new long[n];
            pa = va;
            for (int i = 0; i < n; ++i) {
                va[i] = (Long)values.get(i);
            }
        }
        this.setValues(Array.factory(c, new int[]{n}, (Object)pa));
    }

    public Attribute(Parameter param) {
        this.name = NetcdfFile.createValidNetcdfObjectName(param.getName());
        if (param.isString()) {
            this.setStringValue(param.getStringValue());
        } else {
            double[] values = param.getNumericValues();
            int n = values.length;
            Array vala = Array.factory(DataType.DOUBLE.getPrimitiveClassType(), new int[]{n}, (Object)values);
            this.setValues(vala);
        }
    }

    protected Attribute(String name) {
        this(name, true);
    }

    protected Attribute(String name, boolean validate) {
        this.name = NetcdfFile.createValidNetcdfObjectName(name);
    }

    private void validate(String name) {
        if (!NetcdfFile.isValidNetcdfObjectName(name)) {
            throw new IllegalArgumentException("Illegal Netcdf Object Name = '" + name + "', should be " + NetcdfFile.getValidNetcdfObjectNamePattern());
        }
    }

    private void setStringValue(String val) {
        int len;
        for (len = val.length(); len > 0 && val.charAt(len - 1) == '\u0000'; --len) {
        }
        if (len != val.length()) {
            val = val.substring(0, len);
        }
        this.values = Array.factory(String.class, new int[]{1});
        this.values.setObject(this.values.getIndex(), (Object)val);
        this.setValues(this.values);
    }

    protected void setValues(Array arr) {
        if (DataType.getType(arr.getElementType()) == null) {
            throw new IllegalArgumentException("Cant set Attribute with type " + arr.getElementType());
        }
        if (arr.getElementType() == Character.TYPE) {
            ArrayChar carr = (ArrayChar)arr;
            arr = carr.make1DStringArray();
        }
        if (arr.getRank() != 1) {
            arr = arr.reshape(new int[]{(int)arr.getSize()});
        }
        this.values = arr;
        this.nelems = (int)arr.getSize();
        this.dataType = DataType.getType(arr.getElementType());
        this.hashCode = 0;
    }

    private Index ima() {
        if (this.ima == null) {
            this.ima = this.values.getIndex();
        }
        return this.ima;
    }
}

