/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import opendap.dap.DConnect2;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import thredds.util.net.EasySSLProtocolSocketFactory;
import ucar.unidata.io.http.HTTPRandomAccessFile;

public class HttpClientManager {
    private static boolean debug = false;
    private static HttpClient _client;
    private static int timeout;

    public static void init(CredentialsProvider provider, String userAgent) {
        HttpClientManager.initHttpClient();
        if (provider != null) {
            _client.getParams().setParameter("http.authentication.credential-provider", (Object)provider);
        }
        if (userAgent != null) {
            _client.getParams().setParameter("http.useragent", (Object)(userAgent + "/NetcdfJava/HttpClient"));
        } else {
            _client.getParams().setParameter("http.useragent", (Object)"NetcdfJava/HttpClient");
        }
        String proxyHost = System.getProperty("http.proxyHost");
        String proxyPort = System.getProperty("http.proxyPort");
        if (proxyHost != null && proxyPort != null) {
            _client.getHostConfiguration().setProxy(proxyHost, Integer.parseInt(proxyPort));
        }
        HttpClientManager.setHttpClient(_client);
    }

    public static void setHttpClient(HttpClient client) {
        _client = client;
        DConnect2.setHttpClient((HttpClient)_client);
        HTTPRandomAccessFile.setHttpClient(_client);
    }

    public static HttpClient getHttpClient() {
        return _client;
    }

    private static synchronized void initHttpClient() {
        if (_client != null) {
            return;
        }
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        _client = new HttpClient((HttpConnectionManager)connectionManager);
        HttpClientParams params = _client.getParams();
        params.setParameter("http.socket.timeout", (Object)timeout);
        params.setParameter("http.protocol.allow-circular-redirects", (Object)Boolean.TRUE);
        params.setParameter("http.protocol.cookie-policy", (Object)"rfc2109");
        Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)new EasySSLProtocolSocketFactory(), 8443));
    }

    public static void clearState() {
        _client.getState().clearCookies();
        _client.getState().clearCredentials();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContent(String urlString) throws IOException {
        GetMethod m = new GetMethod(urlString);
        m.setFollowRedirects(true);
        try {
            _client.executeMethod((HttpMethod)m);
            String string = m.getResponseBodyAsString();
            return string;
        }
        finally {
            m.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int putContent(String urlString, String content) throws IOException {
        PutMethod m = new PutMethod(urlString);
        m.setDoAuthentication(true);
        try {
            Header locationHeader;
            m.setRequestEntity((RequestEntity)new StringRequestEntity(content));
            _client.executeMethod((HttpMethod)m);
            int resultCode = m.getStatusCode();
            if (resultCode == 302 && (locationHeader = m.getResponseHeader("location")) != null) {
                String redirectLocation = locationHeader.getValue();
                if (debug) {
                    System.out.println("***Follow Redirection = " + redirectLocation);
                }
                resultCode = HttpClientManager.putContent(redirectLocation, content);
            }
            int n = resultCode;
            return n;
        }
        finally {
            m.releaseConnection();
        }
    }

    static {
        timeout = 0;
    }
}

