/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.grid;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dataset.grid.GeoGrid;
import ucar.nc2.dataset.grid.GridDataset;
import ucar.nc2.units.DateUnit;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.units.TimeUnit;

public class GridDatasetInfo {
    private GridDataset gds;
    private String path;
    private StringBuffer parseInfo = new StringBuffer();
    private StringBuffer userAdvice = new StringBuffer();

    public GridDatasetInfo(GridDataset gds, String path) {
        this.gds = gds;
        this.path = path;
    }

    public StringBuffer getParseInfo() {
        return this.parseInfo;
    }

    public StringBuffer getUserAdvice() {
        return this.userAdvice;
    }

    void addParseInfo(String info) {
        this.parseInfo.append(info);
    }

    void addUserAdvice(String advice) {
        this.userAdvice.append(advice);
    }

    public String writeXML() {
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        return fmt.outputString(this.makeDocument());
    }

    public void writeXML(OutputStream os) throws IOException {
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        fmt.output(this.makeDocument(), os);
    }

    public Document makeDocument() {
        Element rootElem = new Element("gridDatasetInfo");
        Document doc = new Document(rootElem);
        rootElem.setAttribute("location", this.gds.getName());
        rootElem.setAttribute("path", this.path);
        int nDataVariables = 0;
        boolean nOtherVariables = false;
        List grids = this.gds.getGrids();
        for (int i = 0; i < grids.size(); ++i) {
            GeoGrid grid = (GeoGrid)grids.get(i);
            ++nDataVariables;
            Element gridElem = new Element("grid");
            rootElem.addContent((Content)gridElem);
            gridElem.setAttribute("name", grid.getName());
        }
        return doc;
    }

    private String getDecl(VariableEnhanced ve) {
        StringBuffer sb = new StringBuffer();
        sb.append(ve.getDataType().toString());
        sb.append(" ");
        ve.getNameAndDimensions(sb, true, true);
        return sb.toString();
    }

    private String getCoordSys(VariableEnhanced ve) {
        List<CoordinateSystem> csList = ve.getCoordinateSystems();
        if (csList.size() == 1) {
            CoordinateSystem cs = csList.get(0);
            return cs.getName();
        }
        if (csList.size() > 1) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < csList.size(); ++i) {
                CoordinateSystem cs = csList.get(i);
                if (i > 0) {
                    sb.append(";");
                }
                sb.append(cs.getName());
            }
            return sb.toString();
        }
        return " ";
    }

    private String isUdunits(String unit) {
        SimpleUnit su = SimpleUnit.factory(unit);
        if (null == su) {
            return "false";
        }
        if (su instanceof DateUnit) {
            return "date";
        }
        if (su instanceof TimeUnit) {
            return "time";
        }
        return su.getUnit().getCanonicalString();
    }

    public static void main(String[] args) throws IOException {
        String url = "C:/data/grib/ruc/c20s/RUC2_CONUS_20km_surface_20060327_0900.grib1";
        GridDataset ncd = GridDataset.open(url);
        GridDatasetInfo info = new GridDatasetInfo(ncd, "path");
        FileOutputStream fos2 = new FileOutputStream("C:/TEMP/gridInfo.xml");
        info.writeXML(fos2);
        fos2.close();
        String infoString = info.writeXML();
        System.out.println(infoString);
    }
}

