/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import java.util.StringTokenizer;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;
import ucar.unidata.geoloc.vertical.OceanSigma;
import ucar.unidata.geoloc.vertical.VerticalTransform;
import ucar.unidata.util.Parameter;

public class VOceanSigma
extends AbstractCoordTransBuilder {
    private String s = "";
    private String eta = "";
    private String depth = "";

    public String getTransformName() {
        return "ocean_sigma_coordinate";
    }

    public TransformType getTransformType() {
        return TransformType.Vertical;
    }

    public CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
        String formula_terms = this.getFormula(ds, ctv);
        if (null == formula_terms) {
            return null;
        }
        StringTokenizer stoke = new StringTokenizer(formula_terms);
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken();
            if (toke.equalsIgnoreCase("sigma:")) {
                this.s = stoke.nextToken();
                continue;
            }
            if (toke.equalsIgnoreCase("eta:")) {
                this.eta = stoke.nextToken();
                continue;
            }
            if (!toke.equalsIgnoreCase("depth:")) continue;
            this.depth = stoke.nextToken();
        }
        VerticalCT rs = new VerticalCT("OceanSigma_Transform_" + ctv.getName(), this.getTransformName(), VerticalCT.Type.OceanSigma, this);
        rs.addParameter(new Parameter("standard_name", this.getTransformName()));
        rs.addParameter(new Parameter("formula_terms", formula_terms));
        rs.addParameter(new Parameter("height_formula", "height(x,y,z) = eta(x,y) + sigma(k)*(depth(x,y) + eta(x,y))"));
        if (!this.addParameter(rs, "Eta_variableName", ds, this.eta)) {
            return null;
        }
        if (!this.addParameter(rs, "Sigma_variableName", ds, this.s)) {
            return null;
        }
        if (!this.addParameter(rs, "Depth_variableName", ds, this.depth)) {
            return null;
        }
        return rs;
    }

    public String toString() {
        return "OceanS: sigma:" + this.s + " eta:" + this.eta + " depth:" + this.depth;
    }

    public VerticalTransform makeMathTransform(NetcdfDataset ds, Dimension timeDim, VerticalCT vCT) {
        return new OceanSigma(ds, timeDim, vCT);
    }
}

