/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dods;

import java.util.Iterator;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.nc2.Attribute;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.unidata.util.StringUtil;

public class DODSAttribute
extends Attribute {
    private static String[] escapeAttributeStrings = new String[]{"\\", "\""};
    private static String[] substAttributeStrings = new String[]{"\\\\", "\\\""};

    public DODSAttribute(String dodsName, opendap.dap.Attribute att) {
        super(DODSNetcdfFile.makeNetcdfName(dodsName));
        DataType ncType = DODSNetcdfFile.convertToNCType(att.getType());
        int nvals = 0;
        Iterator iter = att.getValuesIterator();
        while (iter.hasNext()) {
            iter.next();
            ++nvals;
        }
        String[] vals = new String[nvals];
        iter = att.getValuesIterator();
        int count = 0;
        while (iter.hasNext()) {
            int n;
            String val = (String)iter.next();
            if (val.charAt(0) == '\"') {
                val = val.substring(1);
            }
            if ((n = val.length()) > 0 && val.charAt(n - 1) == '\"') {
                val = val.substring(0, n - 1);
            }
            vals[count++] = this.unescapeAttributeStringValues(val);
        }
        Array data = null;
        if (ncType == DataType.STRING) {
            data = Array.factory(ncType.getPrimitiveClassType(), new int[]{nvals}, (Object)vals);
        } else {
            try {
                data = Array.factory(ncType.getPrimitiveClassType(), new int[]{nvals});
                Index ima = data.getIndex();
                for (int i = 0; i < nvals; ++i) {
                    double dval = Double.parseDouble(vals[i]);
                    data.setDouble(ima.set(i), dval);
                }
            }
            catch (NumberFormatException e) {
                System.out.println("ILLEGAL NUMERIC VALUE");
            }
        }
        this.setValues(data);
    }

    protected DODSAttribute(String dodsName, String val) {
        super(DODSNetcdfFile.makeNetcdfName(dodsName), val);
    }

    private String unescapeAttributeStringValues(String value) {
        return StringUtil.substitute(value, substAttributeStrings, escapeAttributeStrings);
    }
}

