/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.point;

import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.PointObsDataset;
import ucar.nc2.dt.PointObsDatatype;
import ucar.nc2.dt.TypedDatasetImpl;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateUnit;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.LatLonRect;

public abstract class PointObsDatasetImpl
extends TypedDatasetImpl
implements PointObsDataset {
    protected static SimpleUnit meterUnit = SimpleUnit.factory("m");
    protected DateUnit timeUnit;
    protected DateFormatter formatter;

    protected static double getMetersConversionFactor(String unitsString) throws Exception {
        SimpleUnit unit = SimpleUnit.factoryWithExceptions(unitsString);
        return unit.convertTo(1.0, meterUnit);
    }

    public PointObsDatasetImpl() {
    }

    public PointObsDatasetImpl(String title, String description, String location) {
        super(title, description, location);
    }

    public PointObsDatasetImpl(NetcdfDataset ncfile) {
        super(ncfile);
    }

    protected abstract void setTimeUnits();

    public String getDetailInfo() {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append("PointObsDataset\n");
        sbuff.append("  adapter   = " + this.getClass().getName() + "\n");
        sbuff.append("  timeUnit  = " + this.getTimeUnits() + "\n");
        sbuff.append("  dataClass = " + this.getDataClass() + "\n");
        sbuff.append("  dataCount = " + this.getDataCount() + "\n");
        sbuff.append(super.getDetailInfo());
        return sbuff.toString();
    }

    public thredds.catalog.DataType getScientificDataType() {
        return thredds.catalog.DataType.POINT;
    }

    public Class getDataClass() {
        return PointObsDatatype.class;
    }

    public DateUnit getTimeUnits() {
        return this.timeUnit;
    }

    public List getData() throws IOException {
        return this.getData((CancelTask)null);
    }

    public List getData(LatLonRect boundingBox) throws IOException {
        return this.getData(boundingBox, null);
    }

    public List getData(LatLonRect boundingBox, Date start, Date end) throws IOException {
        return this.getData(boundingBox, start, end, null);
    }

    protected double getTime(Variable timeVar, StructureData sdata) throws ParseException {
        if (timeVar == null) {
            return 0.0;
        }
        if (timeVar.getDataType() == DataType.CHAR || timeVar.getDataType() == DataType.STRING) {
            String time = sdata.getScalarString(timeVar.getShortName());
            if (null == this.formatter) {
                this.formatter = new DateFormatter();
            }
            Date date = this.formatter.isoDateTimeFormat(time);
            return (double)date.getTime() / 1000.0;
        }
        return sdata.getScalarFloat(timeVar.getShortName());
    }
}

