/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp;

import java.util.ArrayList;
import java.util.List;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.iosp.Indexer;
import ucar.nc2.iosp.SingleChunkIndexer;

public class RegularSectionLayout
extends Indexer {
    private List<Dim> dimList = new ArrayList<Dim>();
    private Index dataIndex;
    private Index resultIndex;
    private int elemSize;
    private long startPos;
    private int startElem;
    private Indexer.Chunk chunk;
    private int nelems;
    private long total;
    private long done;
    private boolean debug = false;
    private boolean debugMerge = false;
    private boolean debugDetail = false;
    private boolean debugNext = false;

    public static Indexer factory(long startFilePos, int elemSize, Section dataSection, Section wantSection) throws InvalidRangeException {
        if (dataSection.equals(wantSection)) {
            return new SingleChunkIndexer(startFilePos, (int)dataSection.computeSize(), elemSize);
        }
        return new RegularSectionLayout(startFilePos, elemSize, dataSection, wantSection);
    }

    public RegularSectionLayout(long startFilePos, int elemSize, Section dataSection, Section wantSection) throws InvalidRangeException {
        assert (startFilePos >= 0L);
        assert (elemSize > 0);
        this.elemSize = elemSize;
        this.done = 0L;
        Section intersect = dataSection.intersect(wantSection);
        this.total = intersect.computeSize();
        if (this.total <= 0L) {
            System.out.println("hey");
        }
        assert (this.total > 0L);
        int varRank = intersect.getRank();
        int wantStride = 1;
        int dataStride = 1;
        for (int ii = varRank - 1; ii >= 0; --ii) {
            Range dr = dataSection.getRange(ii);
            Range wr = wantSection.getRange(ii);
            Range ir = intersect.getRange(ii);
            this.dimList.add(new Dim(dr, wr, ir, dataStride, wantStride));
            dataStride *= dr.length();
            wantStride *= wr.length();
        }
        long fileOffset = 0L;
        for (Dim dim : this.dimList) {
            int d = dim.intersect.first() - dim.data.first();
            if (d <= 0) continue;
            fileOffset += (long)(elemSize * dim.dataStride * d);
        }
        this.startPos = startFilePos + fileOffset;
        this.startElem = wantSection.offset(intersect);
        if (varRank == 0) {
            this.nelems = 1;
        } else {
            Dim innerDim = this.dimList.get(0);
            this.nelems = innerDim.ncontigElements;
            if (innerDim.ncontigElements > 1) {
                innerDim.wantNelems = 1;
                innerDim.wantStride = innerDim.ncontigElements;
            }
        }
        int rank = this.dimList.size();
        int[] dataStrides = new int[rank];
        int[] resultStrides = new int[rank];
        int[] shape = new int[rank];
        for (int i = 0; i < this.dimList.size(); ++i) {
            Dim dim = this.dimList.get(i);
            dataStrides[rank - i - 1] = dim.dataStride * dim.want.stride();
            resultStrides[rank - i - 1] = dim.wantStride;
            shape[rank - i - 1] = dim.wantNelems;
        }
        if (this.debugDetail) {
            this.printa(" indexShape=", shape);
            this.printa(" dataStrides=", dataStrides);
            this.printa(" wantStride=", resultStrides);
            System.out.println(" indexChunks=" + Index.computeSize(shape));
        }
        this.dataIndex = new Index(shape, dataStrides);
        this.resultIndex = new Index(shape, resultStrides);
        if (this.debugDetail) {
            System.out.println(" dataIndex=" + this.dataIndex.toStringDebug());
            System.out.println(" resultIndex=" + this.resultIndex.toStringDebug());
        }
        long nchunks = Index.computeSize(shape);
        assert (nchunks * (long)this.nelems == this.total);
        if (this.debug) {
            System.out.println("RegularSectionLayout total = " + this.total + " nchunks= " + nchunks + " nelems= " + this.nelems + " elemSize= " + elemSize + " dataSection= " + dataSection + " wantSection= " + wantSection + " intersect= " + intersect + this);
        }
    }

    public long getTotalNelems() {
        return this.total;
    }

    public int getElemSize() {
        return this.elemSize;
    }

    public boolean hasNext() {
        return this.done < this.total;
    }

    public Indexer.Chunk next() {
        if (this.chunk == null) {
            this.chunk = new Indexer.Chunk(this.startPos, this.nelems, this.startElem);
        } else {
            this.dataIndex.incr();
            this.resultIndex.incr();
        }
        this.chunk.setFilePos(this.startPos + (long)(this.elemSize * this.dataIndex.currentElement()));
        this.chunk.setStartElem(this.startElem + this.resultIndex.currentElement());
        if (this.debugNext) {
            System.out.println(" chunk: " + this.chunk);
        }
        if (this.debugDetail) {
            System.out.println(" dataIndex: " + this.dataIndex);
            System.out.println(" wantIndex: " + this.resultIndex);
        }
        this.done += (long)this.nelems;
        return this.chunk;
    }

    public String toString() {
        StringBuffer sbuff = new StringBuffer();
        for (int i = 0; i < this.dimList.size(); ++i) {
            Dim elem = this.dimList.get(i);
            sbuff.append("\n");
            sbuff.append(elem);
        }
        return sbuff.toString();
    }

    private class Dim {
        Range data;
        Range want;
        Range intersect;
        int dataStride;
        int wantStride;
        int wantNelems;
        int ncontigElements;

        Dim(Range data, Range want, Range intersect, int dataStride, int wantStride) {
            this.data = data;
            this.want = want;
            this.intersect = intersect;
            this.dataStride = dataStride;
            this.wantStride = wantStride;
            this.ncontigElements = intersect.stride() == 1 ? intersect.length() : 1;
            this.wantNelems = intersect.length();
            if (RegularSectionLayout.this.debugMerge) {
                System.out.println("Dim=" + this);
            }
        }

        public String toString() {
            return "  data = " + this.data + " want = " + this.want + " intersect = " + this.intersect + " ncontigElements = " + this.ncontigElements;
        }
    }
}

