/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import thredds.util.DateFromString;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.MAMath;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.DatasetConstructor;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.fmrc.ForecastModelRunInventory;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ncml.Aggregation;
import ucar.nc2.ncml.AggregationExisting;
import ucar.nc2.ncml.AggregationFmrc;
import ucar.nc2.ncml.AggregationIF;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.util.CancelTask;
import ucar.unidata.util.StringUtil;

public class AggregationFmrcSingle
extends AggregationFmrc {
    private Calendar cal = new GregorianCalendar();
    private List<Aggregation.DirectoryScan> scanFmrcList = new ArrayList<Aggregation.DirectoryScan>();
    private List<Aggregation.MyFile> currentFiles;
    private Map<Date, List<Aggregation.Dataset>> runHash = new HashMap<Date, List<Aggregation.Dataset>>();
    private List<Date> runs;
    private CoordinateAxis1D timeAxis = null;
    private int max_times = 0;
    private Aggregation.Dataset typicalDataset = null;
    private boolean debug = false;

    public AggregationFmrcSingle(NetcdfDataset ncd, String dimName, String recheckS) {
        super(ncd, dimName, AggregationIF.Type.FORECAST_MODEL_SINGLE, recheckS);
    }

    public void addDirectoryScanFmrc(String dirName, String suffix, String regexpPatternString, String subdirs, String olderThan, String runMatcher, String forecastMatcher, String offsetMatcher) throws IOException {
        Aggregation.DirectoryScan d = new Aggregation.DirectoryScan(dirName, suffix, regexpPatternString, subdirs, olderThan, runMatcher, forecastMatcher, offsetMatcher);
        this.scanFmrcList.add(d);
        this.isDate = true;
    }

    protected boolean rescan() throws IOException {
        boolean changed;
        this.lastChecked = System.currentTimeMillis();
        if (this.debug) {
            System.out.println(" *Sync at " + new Date());
        }
        ArrayList<Aggregation.MyFile> fileList = new ArrayList<Aggregation.MyFile>();
        for (Aggregation.DirectoryScan dir : this.scanFmrcList) {
            dir.scanDirectory(fileList, null);
        }
        boolean bl = changed = fileList.size() != this.currentFiles.size();
        if (!changed) {
            for (Aggregation.MyFile newFile : fileList) {
                if (this.currentFiles.indexOf(newFile) >= 0) continue;
                changed = true;
                if (!this.debugSyncDetail) break;
                System.out.println("  rescan found new file= " + newFile.file.getPath());
                break;
            }
        }
        if (!changed) {
            for (Aggregation.MyFile oldFile : this.currentFiles) {
                if (fileList.indexOf(oldFile) >= 0) continue;
                changed = true;
                if (!this.debugSyncDetail) break;
                System.out.println("  sync found deleted Dataset= " + oldFile.file.getPath());
                break;
            }
        }
        if (changed) {
            this.scanFmrc(null);
        }
        return changed;
    }

    protected void buildDataset(boolean isNew, CancelTask cancelTask) throws IOException {
        ucar.nc2.dt.GridDataset typicalGds = this.scanFmrc(cancelTask);
        if (typicalGds == null) {
            return;
        }
        this.buildDataset(this.typicalDataset, typicalGds, cancelTask);
    }

    private ucar.nc2.dt.GridDataset scanFmrc(CancelTask cancelTask) throws IOException {
        NetcdfDataset typicalDS;
        this.currentFiles = new ArrayList<Aggregation.MyFile>();
        for (Aggregation.DirectoryScan dir : this.scanFmrcList) {
            dir.scanDirectory(this.currentFiles, cancelTask);
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return null;
        }
        this.runHash = new HashMap<Date, List<Aggregation.Dataset>>();
        for (Aggregation.MyFile myf : this.currentFiles) {
            String location = StringUtil.replace(myf.file.getAbsolutePath(), '\\', "/");
            if (myf.dir.runMatcher != null) {
                myf.runDate = DateFromString.getDateUsingDemarkatedMatch(location, myf.dir.runMatcher, '#');
                if (null == myf.runDate) {
                    logger.error("Cant extract rundate from =" + location + " using format " + myf.dir.runMatcher);
                    continue;
                }
            }
            if (myf.dir.forecastMatcher != null) {
                myf.dateCoord = DateFromString.getDateUsingDemarkatedMatch(location, myf.dir.forecastMatcher, '#');
                if (null == myf.dateCoord) {
                    logger.error("Cant extract forecast date from =" + location + " using format " + myf.dir.forecastMatcher);
                    continue;
                }
                myf.dateCoordS = this.formatter.toDateTimeStringISO(myf.dateCoord);
            }
            if (myf.dir.offsetMatcher != null) {
                myf.offset = DateFromString.getHourUsingDemarkatedMatch(location, myf.dir.offsetMatcher, '#');
                if (null == myf.offset) {
                    logger.error("Cant extract forecast offset from =" + location + " using format " + myf.dir.offsetMatcher);
                    continue;
                }
                myf.dateCoord = this.addHour(myf.runDate, myf.offset);
                myf.dateCoordS = this.formatter.toDateTimeStringISO(myf.dateCoord);
            }
            Aggregation.Dataset ds = this.makeDataset(location, location, null, myf.dateCoordS, true, null);
            ds.coordValueDate = myf.dateCoord;
            ds.ncoord = 1;
            List<Aggregation.Dataset> runDatasets = this.runHash.get(myf.runDate);
            if (runDatasets == null) {
                runDatasets = new ArrayList<Aggregation.Dataset>();
                this.runHash.put(myf.runDate, runDatasets);
            }
            if (this.debugScan) {
                System.out.println("  adding " + myf.file.getAbsolutePath() + " forecast date= " + myf.dateCoordS + "(" + myf.dateCoord + ")" + " run date= " + this.formatter.toDateTimeStringISO(myf.runDate));
            }
            runDatasets.add(ds);
            if (this.typicalDataset != null) continue;
            this.typicalDataset = ds;
        }
        NetcdfFile typicalFile = this.typicalDataset.acquireFile(cancelTask);
        NetcdfDataset netcdfDataset = typicalDS = typicalFile instanceof NetcdfDataset ? (NetcdfDataset)typicalFile : new NetcdfDataset(typicalFile);
        if (typicalDS.getEnhanceMode() == NetcdfDataset.EnhanceMode.None) {
            typicalDS.enhance();
        }
        GridDataset gds = new GridDataset(typicalDS);
        for (GridDatatype grid : gds.getGrids()) {
            GridCoordSystem gcc = grid.getCoordinateSystem();
            this.timeAxis = gcc.getTimeAxis1D();
            if (null == this.timeAxis) continue;
            break;
        }
        if (this.timeAxis == null) {
            throw new IllegalStateException("No time variable");
        }
        this.max_times = 0;
        this.nestedDatasets = new ArrayList();
        this.runs = new ArrayList<Date>(this.runHash.keySet());
        Collections.sort(this.runs);
        for (Date runDate : this.runs) {
            String runDateS = this.formatter.toDateTimeStringISO(runDate);
            List<Aggregation.Dataset> runDatasets = this.runHash.get(runDate);
            this.max_times = Math.max(this.max_times, runDatasets.size());
            Collections.sort(runDatasets, new Comparator<Aggregation.Dataset>(){

                @Override
                public int compare(Aggregation.Dataset ds1, Aggregation.Dataset ds2) {
                    return ds1.coordValueDate.compareTo(ds2.coordValueDate);
                }
            });
            NetcdfDataset ncd = new NetcdfDataset();
            ncd.setLocation("Run" + runDateS);
            DateFormatter format = new DateFormatter();
            if (this.debugScan) {
                System.out.println("Run" + format.toDateTimeString(runDate));
            }
            AggregationExisting agg = new AggregationExisting(ncd, this.timeAxis.getName(), null);
            for (Aggregation.Dataset dataset : runDatasets) {
                agg.addDataset(dataset);
                if (!this.debugScan) continue;
                System.out.println("  adding Forecast " + format.toDateTimeString(dataset.coordValueDate) + " " + dataset.getLocation());
            }
            ncd.setAggregation(agg);
            agg.finish(cancelTask);
            this.nestedDatasets.add(new OpenDataset(ncd, runDate, runDateS));
        }
        return gds;
    }

    private Date addHour(Date d, double hour) {
        this.cal.setTime(d);
        int ihour = (int)hour;
        int imin = (int)(hour - (double)ihour) * 60;
        this.cal.add(11, ihour);
        this.cal.add(12, imin);
        return this.cal.getTime();
    }

    protected Aggregation.Dataset getTypicalDataset() throws IOException {
        return this.typicalDataset;
    }

    protected void makeTimeCoordinate(ucar.nc2.dt.GridDataset gds, CancelTask cancelTask) throws IOException {
        String innerDimName = this.timeAxis.getName();
        Dimension innerDim = new Dimension(innerDimName, this.max_times);
        this.ncDataset.removeDimension(null, innerDimName);
        this.ncDataset.addDimension(null, innerDim);
        int[] shape = new int[]{this.runs.size(), this.max_times};
        Array timeCoordVals = Array.factory(DataType.DOUBLE, shape);
        MAMath.setDouble(timeCoordVals, Double.NaN);
        Index ima = timeCoordVals.getIndex();
        Date baseDate = null;
        for (int i = 0; i < this.runs.size(); ++i) {
            Date runDate = this.runs.get(i);
            if (baseDate == null) {
                baseDate = runDate;
            }
            List<Aggregation.Dataset> runDatasets = this.runHash.get(runDate);
            for (int j = 0; j < runDatasets.size(); ++j) {
                Aggregation.Dataset dataset = runDatasets.get(j);
                double offset = ForecastModelRunInventory.getOffsetInHours(baseDate, dataset.coordValueDate);
                timeCoordVals.setDouble(ima.set(i, j), offset);
            }
        }
        String dims = this.dimName + " " + innerDimName;
        String units = "hours since " + this.formatter.toDateTimeStringISO(baseDate);
        String desc = "calculated forecast date from AggregationFmrcSingle processing";
        VariableDS vagg = new VariableDS(this.ncDataset, null, null, innerDimName, DataType.DOUBLE, dims, units, desc);
        vagg.setCachedData(timeCoordVals, false);
        DatasetConstructor.transferVariableAttributes(this.timeAxis, vagg);
        vagg.addAttribute(new Attribute("units", units));
        vagg.addAttribute(new Attribute("long_name", desc));
        vagg.addAttribute(new Attribute("missing_value", Double.NaN));
        this.ncDataset.addCoordinateAxis(vagg);
        if (this.debug) {
            System.out.println("FmrcAggregation: promoted timeCoord " + innerDimName);
        }
    }

    protected void readTimeCoordinates(VariableDS timeAxis, CancelTask cancelTask) throws IOException {
        String dimName = timeAxis.getName();
        Dimension timeDim = this.ncDataset.findDimension(dimName);
        timeDim.setLength(this.max_times);
        List<Variable> vars = this.ncDataset.getVariables();
        for (Variable v : vars) {
            if (v.findDimensionIndex(dimName) < 0) continue;
            v.setDimensions(v.getDimensionsString());
            v.setCachedData(null, false);
        }
        int[] shape = new int[]{this.runs.size(), this.max_times};
        Array timeCoordVals = Array.factory(DataType.DOUBLE, shape);
        MAMath.setDouble(timeCoordVals, Double.NaN);
        Index ima = timeCoordVals.getIndex();
        Date baseDate = null;
        for (int i = 0; i < this.runs.size(); ++i) {
            Date runDate = this.runs.get(i);
            if (baseDate == null) {
                baseDate = runDate;
            }
            List<Aggregation.Dataset> runDatasets = this.runHash.get(runDate);
            for (int j = 0; j < runDatasets.size(); ++j) {
                Aggregation.Dataset dataset = runDatasets.get(j);
                double offset = ForecastModelRunInventory.getOffsetInHours(baseDate, dataset.coordValueDate);
                timeCoordVals.setDouble(ima.set(i, j), offset);
            }
        }
        timeAxis.setCachedData(timeCoordVals, true);
        String units = "hours since " + this.formatter.toDateTimeStringISO(baseDate);
        timeAxis.addAttribute(new Attribute("units", units));
    }

    public class OpenDataset
    extends Aggregation.Dataset {
        private NetcdfFile openFile;

        protected OpenDataset(NetcdfFile openFile, Date coordValueDate, String coordValue) {
            super(openFile.getLocation());
            this.openFile = openFile;
            this.ncoord = 1;
            this.coordValueDate = coordValueDate;
            this.coordValue = coordValue;
        }

        protected NetcdfFile acquireFile(CancelTask cancelTask) throws IOException {
            return this.openFile;
        }

        protected void close() throws IOException {
            this.openFile.close();
        }
    }
}

