/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import ucar.unidata.util.StringUtil;

public class DiskCache {
    private static String root;
    private static boolean standardPolicy;

    public static void setRootDirectory(String cacheDir) {
        File dir;
        String oldRoot = root;
        if (!cacheDir.endsWith("/")) {
            cacheDir = cacheDir + "/";
        }
        if (!(dir = new File(root = StringUtil.replace(cacheDir, '\\', "/"))).exists() && !dir.mkdirs()) {
            System.out.println("DiskCache.setRootDirectory(): could not create root directory <" + root + ">.");
            root = oldRoot;
        }
    }

    public static String getRootDirectory() {
        return root;
    }

    public static void setCachePolicy(boolean alwaysInCache) {
        standardPolicy = alwaysInCache;
    }

    public static File getFileStandardPolicy(String fileLocation) {
        return DiskCache.getFile(fileLocation, standardPolicy);
    }

    public static File getFile(String fileLocation, boolean alwaysInCache) {
        if (alwaysInCache) {
            return DiskCache.getCacheFile(fileLocation);
        }
        File f = new File(fileLocation);
        if (f.exists()) {
            return f;
        }
        try {
            if (f.createNewFile()) {
                f.delete();
                return f;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return DiskCache.getCacheFile(fileLocation);
    }

    public static File getCacheFile(String fileLocation) {
        File f = new File(DiskCache.makeCachePath(fileLocation));
        if (f.exists()) {
            f.setLastModified(System.currentTimeMillis());
        }
        return f;
    }

    private static String makeCachePath(String fileLocation) {
        String cachePath;
        try {
            cachePath = URLEncoder.encode(fileLocation, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            cachePath = URLEncoder.encode(fileLocation);
        }
        return root + cachePath;
    }

    public static void showCache(PrintStream pw) {
        pw.println("Cache files");
        pw.println("Size   LastModified       Filename");
        File dir = new File(root);
        for (File file2 : dir.listFiles()) {
            String org = null;
            try {
                org = URLDecoder.decode(file2.getName(), "UTF8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            pw.println(" " + file2.length() + " " + new Date(file2.lastModified()) + " " + org);
        }
    }

    public static void cleanCache(Date cutoff, StringBuffer sbuff) {
        if (sbuff != null) {
            sbuff.append("CleanCache files before ").append(cutoff).append("\n");
        }
        File dir = new File(root);
        for (File file2 : dir.listFiles()) {
            Date lastMod = new Date(file2.lastModified());
            if (!lastMod.before(cutoff)) continue;
            file2.delete();
            if (sbuff == null) continue;
            sbuff.append(" delete ").append(file2).append(" (").append(lastMod).append(")\n");
        }
    }

    public static void cleanCache(long maxBytes, StringBuffer sbuff) {
        DiskCache.cleanCache(maxBytes, new FileLengthComparator(), sbuff);
    }

    public static void cleanCache(long maxBytes, Comparator fileComparator, StringBuffer sbuff) {
        if (sbuff != null) {
            sbuff.append("CleanCache maxBytes= ").append(maxBytes).append("\n");
        }
        File dir = new File(root);
        File[] files = dir.listFiles();
        List<File> fileList = Arrays.asList(files);
        Collections.sort(fileList, fileComparator);
        long total = 0L;
        long total_delete = 0L;
        for (File file2 : fileList) {
            if (file2.length() + total > maxBytes) {
                total_delete += file2.length();
                if (sbuff != null) {
                    sbuff.append(" delete ").append(file2).append(" (").append(file2.length()).append(")\n");
                }
                file2.delete();
                continue;
            }
            total += file2.length();
        }
        if (sbuff != null) {
            sbuff.append("Total bytes deleted= ").append(total_delete).append("\n");
            sbuff.append("Total bytes left in cache= ").append(total).append("\n");
        }
    }

    static void make(String filename) throws IOException {
        File want = DiskCache.getCacheFile(filename);
        System.out.println("make=" + want.getPath() + "; exists = " + want.exists());
        if (!want.exists()) {
            want.createNewFile();
        }
        System.out.println(" canRead= " + want.canRead() + " canWrite = " + want.canWrite() + " lastMod = " + new Date(want.lastModified()));
        try {
            String enc = URLEncoder.encode(filename, "UTF8");
            System.out.println(" original=" + URLDecoder.decode(enc, "UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws IOException {
        DiskCache.setRootDirectory("C:/temp/chill/");
        DiskCache.make("C:/junk.txt");
        DiskCache.make("C:/some/enchanted/evening/joots+3478.txt");
        DiskCache.make("http://www.unidata.ucar.edu/some/enc hanted/eve'ning/nowrite.gibberish");
        DiskCache.showCache(System.out);
        StringBuffer sbuff = new StringBuffer();
        DiskCache.cleanCache(10000000L, sbuff);
        System.out.println(sbuff);
    }

    static {
        String policy;
        root = null;
        standardPolicy = false;
        root = System.getProperty("nj22.cache");
        if (root == null) {
            String home = System.getProperty("user.home");
            if (home == null) {
                home = System.getProperty("user.dir");
            }
            if (home == null) {
                home = ".";
            }
            root = home + "/.unidata/cache/";
        }
        if ((policy = System.getProperty("nj22.cachePolicy")) != null) {
            standardPolicy = policy.equalsIgnoreCase("true");
        }
    }

    private static class FileLengthComparator
    implements Comparator {
        private FileLengthComparator() {
        }

        public int compare(Object o1, Object o2) {
            File f1 = (File)o1;
            File f2 = (File)o2;
            return (int)(f1.length() - f2.length());
        }
    }
}

