/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.imagereaders.imageio;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.io.AdapterIInputStreamToInputStream;
import ch.systemsx.cisd.base.io.IInputStream;
import ch.systemsx.cisd.base.io.IRandomAccessFile;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.imagereaders.AbstractImageReader;
import ch.systemsx.cisd.imagereaders.IImageReader;
import ch.systemsx.cisd.imagereaders.IImageReaderLibrary;
import ch.systemsx.cisd.imagereaders.IReadParams;
import ch.systemsx.cisd.imagereaders.ImageID;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.apache.commons.io.FilenameUtils;

public class ImageIOReaderLibrary
implements IImageReaderLibrary {
    @Override
    public String getName() {
        return "ImageIO";
    }

    @Override
    public List<String> getReaderNames() {
        return this.removeDuplicates(ImageIO.getReaderFormatNames());
    }

    @Override
    public IImageReader tryGetReader(String readerName) {
        assert (readerName != null) : "Reader name cannot be null";
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(readerName.toUpperCase());
        return this.tryGetReader(iterator);
    }

    @Override
    public IImageReader tryGetReaderForFile(String fileName) {
        String fileSuffix = FilenameUtils.getExtension((String)fileName);
        Iterator<ImageReader> iterator = null;
        if (!StringUtils.isBlank((String)fileSuffix)) {
            iterator = ImageIO.getImageReadersBySuffix(fileSuffix);
        }
        return this.tryGetReader(iterator);
    }

    private IImageReader tryGetReader(Iterator<ImageReader> iterator) {
        if (iterator != null && iterator.hasNext()) {
            ImageReader ioReader = iterator.next();
            return this.adaptImageIOReader(ioReader);
        }
        return null;
    }

    private IImageReader adaptImageIOReader(final ImageReader ioReader) {
        String libraryName = this.getName();
        String readerName = this.getReaderName(ioReader);
        return new AbstractImageReader(libraryName, readerName){

            @Override
            public BufferedImage readImage(IRandomAccessFile handle, ImageID imageID, IReadParams ignored) throws IOExceptionUnchecked {
                try {
                    ImageInputStream imageInput = this.adaptHandle(handle);
                    ioReader.setInput(imageInput);
                    return ioReader.read(0);
                }
                catch (IOException ex) {
                    throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
                }
            }

            @Override
            public Dimension readDimensions(IRandomAccessFile handle, ImageID imageID) {
                try {
                    ImageInputStream imageInput = this.adaptHandle(handle);
                    ioReader.setInput(imageInput);
                    return new Dimension(ioReader.getWidth(0), ioReader.getHeight(0));
                }
                catch (IOException ex) {
                    throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
                }
            }

            @Override
            public Integer readColorDepth(IRandomAccessFile handle, ImageID imageID) {
                try {
                    ImageInputStream imageInput = this.adaptHandle(handle);
                    ioReader.setInput(imageInput);
                    return ioReader.read(0).getColorModel().getPixelSize();
                }
                catch (IOException ex) {
                    throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
                }
            }

            private ImageInputStream adaptHandle(IRandomAccessFile handle) {
                AdapterIInputStreamToInputStream input = new AdapterIInputStreamToInputStream((IInputStream)handle);
                return new MemoryCacheImageInputStream((InputStream)input);
            }
        };
    }

    private String getReaderName(ImageReader ioReader) {
        try {
            return ioReader.getFormatName();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private List<String> removeDuplicates(String[] readerFormatNames) {
        HashSet<String> names = new HashSet<String>();
        String[] stringArray = readerFormatNames;
        int n = readerFormatNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            names.add(name.toLowerCase());
            ++n2;
        }
        return new ArrayList<String>(names);
    }
}

