/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.imagereaders.imageio;

import ch.systemsx.cisd.base.io.IRandomAccessFile;
import ch.systemsx.cisd.base.io.RandomAccessFileImpl;
import ch.systemsx.cisd.imagereaders.IImageReader;
import ch.systemsx.cisd.imagereaders.ImageID;
import ch.systemsx.cisd.imagereaders.ImageReaderTestCase;
import ch.systemsx.cisd.imagereaders.imageio.ImageIOReaderLibrary;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.Map;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ImageIOReaderLibraryTest
extends ImageReaderTestCase {
    @DataProvider(name="image-files")
    public Object[][] librariesToTest() {
        return new Object[][]{{"pond.bmp", 24}, {"pond.gif", 8}, {"pond.jpg", 24}, {"pond.png", 24}};
    }

    @Test(dataProvider="image-files")
    public void testSingleImageExamples(String imageFileName, int expectedDepth) throws Exception {
        ImageIOReaderLibrary library = new ImageIOReaderLibrary();
        String libraryName = library.getName();
        File imageFile = this.getImageFileForLibrary(libraryName, imageFileName);
        IImageReader reader = library.tryGetReaderForFile(imageFile.getPath());
        List<ImageID> imageIDs = reader.getImageIDs(imageFile);
        ImageIOReaderLibraryTest.assertEquals((String)"[0-0-0-0]", (String)imageIDs.toString());
        Map<String, Object> metaData = reader.readMetaData(imageFile, imageIDs.get(0), null);
        ImageIOReaderLibraryTest.assertEquals((int)0, (int)metaData.size());
        BufferedImage image = reader.readImage(imageFile, imageIDs.get(0), null);
        ImageIOReaderLibraryTest.assertEquals((int)512, (int)image.getWidth());
        ImageIOReaderLibraryTest.assertEquals((int)384, (int)image.getHeight());
        int depth = reader.readColorDepth((IRandomAccessFile)new RandomAccessFileImpl(new RandomAccessFile(imageFile, "r")), imageIDs.get(0));
        ImageIOReaderLibraryTest.assertEquals((int)expectedDepth, (int)depth);
    }
}

