/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngFilterType;

class FilterWriteStrategy {
    private static final int COMPUTE_STATS_EVERY_N_LINES = 8;
    final ImageInfo imgInfo;
    private final PngFilterType configuredType;
    private PngFilterType currentType;
    private int lastRowTested = -1000000;
    private long[] lastSums = new long[5];
    private int discoverEachLines = -1;

    FilterWriteStrategy(ImageInfo imgInfo, PngFilterType configuredType) {
        this.imgInfo = imgInfo;
        this.configuredType = configuredType;
        this.currentType = configuredType.val < 0 ? (imgInfo.rows < 8 && imgInfo.cols < 8 || imgInfo.indexed || imgInfo.bitDepth < 8 ? PngFilterType.FILTER_NONE : PngFilterType.FILTER_PAETH) : configuredType;
        if (configuredType == PngFilterType.FILTER_AGRESSIVE) {
            this.discoverEachLines = 8;
        }
    }

    boolean shouldTestAll(int rown) {
        return this.discoverEachLines > 0 && this.lastRowTested + this.discoverEachLines <= rown;
    }

    void fillResultsForFilter(int rown, PngFilterType type, long sum) {
        this.lastRowTested = rown;
        this.lastSums[type.val] = sum;
        this.currentType = null;
    }

    PngFilterType gimmeFilterType(int rown) {
        if (this.currentType == null) {
            long bestsum = Long.MAX_VALUE;
            int i = 0;
            while (i < 5) {
                if (this.lastSums[i] <= bestsum) {
                    bestsum = this.lastSums[i];
                    this.currentType = PngFilterType.getByVal(i);
                }
                ++i;
            }
        }
        if (this.configuredType == PngFilterType.FILTER_ALTERNATE) {
            this.currentType = PngFilterType.getByVal((this.currentType.val + 1) % 5);
        }
        return this.currentType;
    }
}

