/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.PngjInputException;
import ar.com.hjg.pngj.PngjOutputException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.CRC32;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PngHelper {
    private static final ThreadLocal<CRC32> crcProvider = new ThreadLocal<CRC32>(){

        @Override
        protected CRC32 initialValue() {
            return new CRC32();
        }
    };
    static final byte[] pngIdBytes = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    public static Charset charsetLatin1 = Charset.forName("ISO-8859-1");
    static boolean DEBUG = false;

    public static CRC32 getCRC() {
        return crcProvider.get();
    }

    public static void writeInt2(OutputStream os, int n) {
        byte[] temp = new byte[]{(byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        PngHelper.writeBytes(os, temp);
    }

    public static int readInt2(InputStream is) {
        int b2;
        int b1;
        block3: {
            try {
                b1 = is.read();
                b2 = is.read();
                if (b1 != -1 && b2 != -1) break block3;
                return -1;
            }
            catch (IOException e) {
                throw new PngjInputException("error reading readInt2", e);
            }
        }
        return (b1 << 8) + b2;
    }

    public static int readInt4(InputStream is) {
        int b4;
        int b3;
        int b2;
        int b1;
        block3: {
            try {
                b1 = is.read();
                b2 = is.read();
                b3 = is.read();
                b4 = is.read();
                if (b1 != -1 && b2 != -1 && b3 != -1 && b4 != -1) break block3;
                return -1;
            }
            catch (IOException e) {
                throw new PngjInputException("error reading readInt4", e);
            }
        }
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
    }

    public static int readInt1fromByte(byte[] b, int offset) {
        return b[offset] & 0xFF;
    }

    public static int readInt2fromBytes(byte[] b, int offset) {
        return (b[offset] & 0xFF) << 16 | b[offset + 1] & 0xFF;
    }

    public static int readInt4fromBytes(byte[] b, int offset) {
        return (b[offset] & 0xFF) << 24 | (b[offset + 1] & 0xFF) << 16 | (b[offset + 2] & 0xFF) << 8 | b[offset + 3] & 0xFF;
    }

    public static void writeInt2tobytes(int n, byte[] b, int offset) {
        b[offset] = (byte)(n >> 8 & 0xFF);
        b[offset + 1] = (byte)(n & 0xFF);
    }

    public static void writeInt4tobytes(int n, byte[] b, int offset) {
        b[offset] = (byte)(n >> 24 & 0xFF);
        b[offset + 1] = (byte)(n >> 16 & 0xFF);
        b[offset + 2] = (byte)(n >> 8 & 0xFF);
        b[offset + 3] = (byte)(n & 0xFF);
    }

    public static void writeInt4(OutputStream os, int n) {
        byte[] temp = new byte[4];
        PngHelper.writeInt4tobytes(n, temp, 0);
        PngHelper.writeBytes(os, temp);
    }

    public static void readBytes(InputStream is, byte[] b, int offset, int len) {
        if (len == 0) {
            return;
        }
        try {
            int read = 0;
            while (read < len) {
                int n = is.read(b, offset + read, len - read);
                if (n < 1) {
                    throw new RuntimeException("error reading, " + n + " !=" + len);
                }
                read += n;
            }
        }
        catch (IOException e) {
            throw new PngjInputException("error reading", e);
        }
    }

    public static void writeBytes(OutputStream os, byte[] b) {
        try {
            os.write(b);
        }
        catch (IOException e) {
            throw new PngjOutputException(e);
        }
    }

    public static void writeBytes(OutputStream os, byte[] b, int offset, int n) {
        try {
            os.write(b, offset, n);
        }
        catch (IOException e) {
            throw new PngjOutputException(e);
        }
    }

    public static int readByte(InputStream is) {
        try {
            return is.read();
        }
        catch (IOException e) {
            throw new PngjOutputException(e);
        }
    }

    public static void writeByte(OutputStream os, byte b) {
        try {
            os.write(b);
        }
        catch (IOException e) {
            throw new PngjOutputException(e);
        }
    }

    public static int filterPaethPredictor(int a, int b, int c) {
        int p = a + b - c;
        int pa = Math.abs(p - a);
        int pb = Math.abs(p - b);
        int pc = Math.abs(p - c);
        if (pa <= pb && pa <= pc) {
            return a;
        }
        if (pb <= pc) {
            return b;
        }
        return c;
    }

    public static void logdebug(String msg) {
        if (DEBUG) {
            System.out.println(msg);
        }
    }

    public static Set<String> asSet(String ... values) {
        return new HashSet<String>(Arrays.asList(values));
    }

    public static Set<String> unionSets(Set<String> set1, Set<String> set2) {
        HashSet<String> s = new HashSet<String>();
        s.addAll(set1);
        s.addAll(set2);
        return s;
    }

    public static Set<String> unionSets(Set<String> set1, Set<String> set2, Set<String> set3) {
        HashSet<String> s = new HashSet<String>();
        s.addAll(set1);
        s.addAll(set2);
        s.addAll(set3);
        return s;
    }

    public static double resMetersToDpi(long res) {
        return (double)res * 0.0254;
    }

    public static long resDpiToMeters(double dpi) {
        return (long)(dpi / 0.0254 + 0.5);
    }

    public static int doubleToInt100000(double d) {
        return (int)(d * 100000.0 + 0.5);
    }

    public static double intToDouble100000(int i) {
        return (double)i / 100000.0;
    }
}

