/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.PngHelper;
import ar.com.hjg.pngj.PngjBadCrcException;
import ar.com.hjg.pngj.PngjInputException;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.CRC32;

class PngIDatChunkInputStream
extends InputStream {
    private final InputStream inputStream;
    private final CRC32 crcEngine;
    private int lenLastChunk;
    private byte[] idLastChunk = new byte[4];
    private int toReadThisChunk = 0;
    private boolean ended = false;
    private long offset;
    List<IdatChunkInfo> foundChunksInfo = new ArrayList<IdatChunkInfo>();

    PngIDatChunkInputStream(InputStream iStream, int lenFirstChunk, int offset) {
        this.offset = offset;
        this.inputStream = iStream;
        this.crcEngine = new CRC32();
        this.lenLastChunk = lenFirstChunk;
        this.toReadThisChunk = lenFirstChunk;
        System.arraycopy(ChunkHelper.IDAT, 0, this.idLastChunk, 0, 4);
        this.crcEngine.update(this.idLastChunk, 0, 4);
        this.foundChunksInfo.add(new IdatChunkInfo(this.lenLastChunk, offset - 8));
        if (this.lenLastChunk == 0) {
            this.endChunkGoForNext();
        }
    }

    public void close() throws IOException {
        super.close();
    }

    private void endChunkGoForNext() {
        do {
            int crc = PngHelper.readInt4(this.inputStream);
            this.offset += 4L;
            int crccalc = (int)this.crcEngine.getValue();
            if (this.lenLastChunk > 0 && crc != crccalc) {
                throw new PngjBadCrcException("error reading idat; offset: " + this.offset);
            }
            this.crcEngine.reset();
            this.lenLastChunk = PngHelper.readInt4(this.inputStream);
            if (this.lenLastChunk < 0) {
                throw new PngjInputException("invalid len for chunk: " + this.lenLastChunk);
            }
            this.toReadThisChunk = this.lenLastChunk;
            PngHelper.readBytes(this.inputStream, this.idLastChunk, 0, 4);
            this.offset += 8L;
            boolean bl = this.ended = !Arrays.equals(this.idLastChunk, ChunkHelper.IDAT);
            if (this.ended) continue;
            this.foundChunksInfo.add(new IdatChunkInfo(this.lenLastChunk, (int)(this.offset - 8L)));
            this.crcEngine.update(this.idLastChunk, 0, 4);
        } while (this.lenLastChunk == 0 && !this.ended);
    }

    void forceChunkEnd() {
        if (!this.ended) {
            byte[] dummy = new byte[this.toReadThisChunk];
            PngHelper.readBytes(this.inputStream, dummy, 0, this.toReadThisChunk);
            this.crcEngine.update(dummy, 0, this.toReadThisChunk);
            this.endChunkGoForNext();
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.toReadThisChunk == 0) {
            throw new RuntimeException("this should not happen");
        }
        int n = this.inputStream.read(b, off, len >= this.toReadThisChunk ? this.toReadThisChunk : len);
        if (n > 0) {
            this.crcEngine.update(b, off, n);
            this.offset += (long)n;
            this.toReadThisChunk -= n;
        }
        if (this.toReadThisChunk == 0) {
            this.endChunkGoForNext();
        }
        return n;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read() throws IOException {
        byte[] b1 = new byte[1];
        int r = this.read(b1, 0, 1);
        return r < 0 ? -1 : b1[0];
    }

    int getLenLastChunk() {
        return this.lenLastChunk;
    }

    byte[] getIdLastChunk() {
        return this.idLastChunk;
    }

    long getOffset() {
        return this.offset;
    }

    boolean isEnded() {
        return this.ended;
    }

    static class IdatChunkInfo {
        public final int len;
        public final int offset;

        private IdatChunkInfo(int len, int offset) {
            this.len = len;
            this.offset = offset;
        }
    }
}

