/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

abstract class ProgressiveOutputStream
extends ByteArrayOutputStream {
    private final int size;

    public ProgressiveOutputStream(int size) {
        this.size = size;
    }

    public void close() throws IOException {
        this.flush();
        super.close();
    }

    public void flush() throws IOException {
        super.flush();
        this.checkFlushBuffer(true);
    }

    public void write(byte[] b, int off, int len) {
        super.write(b, off, len);
        this.checkFlushBuffer(false);
    }

    public void write(byte[] b) throws IOException {
        super.write(b);
        this.checkFlushBuffer(false);
    }

    public void write(int arg0) {
        super.write(arg0);
        this.checkFlushBuffer(false);
    }

    public synchronized void reset() {
        super.reset();
    }

    private void checkFlushBuffer(boolean forced) {
        while (forced || this.count >= this.size) {
            int bytesleft;
            int nb = this.size;
            if (nb > this.count) {
                nb = this.count;
            }
            if (nb == 0) {
                return;
            }
            this.flushBuffer(this.buf, nb);
            this.count = bytesleft = this.count - nb;
            if (bytesleft <= 0) continue;
            System.arraycopy(this.buf, nb, this.buf, 0, bytesleft);
        }
    }

    public abstract void flushBuffer(byte[] var1, int var2);
}

