/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.chunks.PngChunk;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkList {
    private List<PngChunk> chunks = new ArrayList<PngChunk>();
    private Map<String, List<Integer>> positions = new HashMap<String, List<Integer>>();
    private boolean positionsDirty = true;

    public void check() {
    }

    private void recalcPositions() {
        this.positions.clear();
        int i = 0;
        while (i < this.chunks.size()) {
            String chunkid = this.chunks.get((int)i).id;
            if (!this.positions.containsKey(chunkid)) {
                this.positions.put(chunkid, new ArrayList());
            }
            this.positions.get(chunkid).add(i);
            ++i;
        }
        this.positionsDirty = false;
    }

    public void appendChunk(PngChunk chunk) {
        this.chunks.add(chunk);
        this.positionsDirty = true;
    }

    public void insertChunk(PngChunk chunk, int afterPos) {
        this.chunks.add(afterPos + 1, chunk);
        this.positionsDirty = true;
    }

    public void insertChunk(PngChunk chunk) {
        this.positionsDirty = true;
    }

    public void removeChunk(PngChunk chunk) {
        this.chunks.remove(chunk);
        this.positionsDirty = true;
    }

    public void removeChunk(int pos) {
        this.chunks.remove(pos);
        this.positionsDirty = true;
    }

    public List<PngChunk> getChunks() {
        if (this.positionsDirty) {
            this.recalcPositions();
        }
        return this.chunks;
    }

    public PngChunk getChunk(int i) {
        if (i < 0) {
            return null;
        }
        return this.chunks.get(i);
    }

    public int nOcurrences(String chunkId) {
        if (this.positionsDirty) {
            this.recalcPositions();
        }
        return this.positions.containsKey(chunkId) ? this.positions.get(chunkId).size() : 0;
    }

    public int firstOcurrence(String chunkId) {
        if (this.positionsDirty) {
            this.recalcPositions();
        }
        return this.positions.containsKey(chunkId) ? this.positions.get(chunkId).get(0) : -1;
    }

    public List<Integer> allOcurrences(String chunkId) {
        if (this.positionsDirty) {
            this.recalcPositions();
        }
        return this.positions.containsKey(chunkId) ? this.positions.get(chunkId) : Collections.EMPTY_LIST;
    }

    public int positionIDAT() {
        return this.firstOcurrence("IDAT");
    }

    public int positionIEND() {
        return this.firstOcurrence("IEND");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (PngChunk chunk : this.chunks) {
            sb.append(chunk).append("\n");
        }
        return sb.toString();
    }
}

