/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelper;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;

public class PngChunkGAMA
extends PngChunk {
    private double gamma;

    public PngChunkGAMA(ImageInfo info) {
        super("gAMA", info);
    }

    public ChunkRaw createChunk() {
        ChunkRaw c = this.createEmptyChunk(4, true);
        int g = (int)(this.gamma * 100000.0 + 0.5);
        PngHelper.writeInt4tobytes(g, c.data, 0);
        return c;
    }

    public void parseFromChunk(ChunkRaw chunk) {
        if (chunk.len != 4) {
            throw new PngjException("bad chunk " + chunk);
        }
        int g = PngHelper.readInt4fromBytes(chunk.data, 0);
        this.gamma = (double)g / 100000.0;
    }

    public void cloneDataFromRead(PngChunk other) {
        this.gamma = ((PngChunkGAMA)other).gamma;
    }

    public double getGamma() {
        return this.gamma;
    }

    public void setGamma(double gamma) {
        this.gamma = gamma;
    }
}

