/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelper;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;
import java.io.ByteArrayInputStream;

public class PngChunkIHDR
extends PngChunk {
    public int cols;
    public int rows;
    public int bitspc;
    public int colormodel;
    public int compmeth;
    public int filmeth;
    public int interlaced;

    public PngChunkIHDR(ImageInfo info) {
        super("IHDR", info);
    }

    public ChunkRaw createChunk() {
        ChunkRaw c = new ChunkRaw(13, ChunkHelper.IHDR, true);
        int offset = 0;
        PngHelper.writeInt4tobytes(this.cols, c.data, offset);
        PngHelper.writeInt4tobytes(this.rows, c.data, offset += 4);
        offset += 4;
        c.data[offset++] = (byte)this.bitspc;
        c.data[offset++] = (byte)this.colormodel;
        c.data[offset++] = (byte)this.compmeth;
        c.data[offset++] = (byte)this.filmeth;
        c.data[offset++] = (byte)this.interlaced;
        return c;
    }

    public void parseFromChunk(ChunkRaw c) {
        if (c.len != 13) {
            throw new PngjException("Bad IDHR len " + c.len);
        }
        ByteArrayInputStream st = c.getAsByteStream();
        this.cols = PngHelper.readInt4(st);
        this.rows = PngHelper.readInt4(st);
        this.bitspc = PngHelper.readByte(st);
        this.colormodel = PngHelper.readByte(st);
        this.compmeth = PngHelper.readByte(st);
        this.filmeth = PngHelper.readByte(st);
        this.interlaced = PngHelper.readByte(st);
    }

    public void cloneDataFromRead(PngChunk other) {
        PngChunkIHDR otherx = (PngChunkIHDR)other;
        this.cols = otherx.cols;
        this.rows = otherx.rows;
        this.bitspc = otherx.bitspc;
        this.colormodel = otherx.colormodel;
        this.compmeth = otherx.compmeth;
        this.filmeth = otherx.filmeth;
        this.interlaced = otherx.interlaced;
    }
}

